/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.compliance.core;

import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.compliance.core.AddSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.SaveSpecialReviewEvent;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.common.framework.compliance.core.ValidSpecialReviewApproval;
import org.kuali.coeus.common.framework.compliance.exemption.SpecialReviewExemption;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.CollectionUtils;

public class SpecialReviewRuleBase<T extends SpecialReview<? extends SpecialReviewExemption>>
extends KcTransactionalDocumentRuleBase {
    private static final String TYPE_CODE_FIELD = "specialReviewTypeCode";
    private static final String APPROVAL_TYPE_CODE_FIELD = "approvalTypeCode";
    private static final String PROTOCOL_NUMBER_FIELD = "protocolNumber";
    private static final String PROTOCOL_NUMBER_TITLE = "Protocol Number";
    private static final String APPLICATION_DATE_FIELD = "applicationDate";
    private static final String APPLICATION_DATE_TITLE = "Application Date";
    private static final String APPROVAL_DATE_FIELD = "approvalDate";
    private static final String APPROVAL_DATE_TITLE = "Approval Date";
    private static final String EXPIRATION_DATE_FIELD = "expirationDate";
    private static final String EXPIRATION_DATE_TITLE = "Expiration Date";
    private static final String EXEMPTION_TYPE_CODE_FIELD = "exemptionTypeCodes";
    private static final String EXEMPTION_TYPE_CODE_TITLE = "Exemption #";

    protected boolean processAddSpecialReviewEvent(AddSpecialReviewEvent<T> addSpecialReviewEvent) {
        boolean rulePassed = true;
        T specialReview = addSpecialReviewEvent.getSpecialReview();
        this.getDictionaryValidationService().validateBusinessObject(specialReview);
        rulePassed &= GlobalVariables.getMessageMap().hasNoErrors();
        rulePassed &= this.validateSpecialReviewApprovalFields(specialReview);
        return rulePassed &= this.validateDateFields(specialReview);
    }

    protected boolean processSaveSpecialReviewEvent(SaveSpecialReviewEvent<T> saveSpecialReviewEvent) {
        boolean rulePassed = true;
        List<T> specialReviews = saveSpecialReviewEvent.getSpecialReviews();
        int i = 0;
        for (SpecialReview specialReview : specialReviews) {
            String errorPath = saveSpecialReviewEvent.getArrayErrorPathPrefix() + "[" + i++ + "]";
            GlobalVariables.getMessageMap().addToErrorPath(errorPath);
            rulePassed &= this.validateSpecialReviewApprovalFields(specialReview);
            rulePassed &= this.validateDateFields(specialReview);
            GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
        }
        return rulePassed;
    }

    private boolean validateSpecialReviewApprovalFields(T specialReview) {
        boolean isValid = true;
        if (StringUtils.isNotBlank((CharSequence)((SpecialReview)specialReview).getSpecialReviewTypeCode()) && StringUtils.isNotBlank((CharSequence)((SpecialReview)specialReview).getApprovalTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(TYPE_CODE_FIELD, ((SpecialReview)specialReview).getSpecialReviewTypeCode());
            fieldValues.put(APPROVAL_TYPE_CODE_FIELD, ((SpecialReview)specialReview).getApprovalTypeCode());
            Collection validApprovals = this.getBusinessObjectService().findMatching(ValidSpecialReviewApproval.class, fieldValues);
            for (ValidSpecialReviewApproval validApproval : validApprovals) {
                String validApprovalErrorString = this.getValidApprovalErrorString(validApproval);
                isValid &= this.validateApprovalFields(validApproval, specialReview, validApprovalErrorString);
            }
        }
        return isValid;
    }

    private String getValidApprovalErrorString(ValidSpecialReviewApproval approval) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(approval.getSpecialReviewType().getDescription());
        stringBuilder.append("/");
        stringBuilder.append(approval.getSpecialReviewApprovalType().getDescription());
        return stringBuilder.toString();
    }

    private boolean validateApprovalFields(ValidSpecialReviewApproval approval, T specialReview, String errorString) {
        boolean isValid = true;
        if (approval.isProtocolNumberFlag() && StringUtils.isBlank((CharSequence)((SpecialReview)specialReview).getProtocolNumber())) {
            isValid = false;
            this.reportError(PROTOCOL_NUMBER_FIELD, "error.special.review.required.for.valid", PROTOCOL_NUMBER_TITLE, errorString);
        }
        if (approval.isApplicationDateFlag() && ((SpecialReview)specialReview).getApplicationDate() == null) {
            isValid = false;
            this.reportError(APPLICATION_DATE_FIELD, "error.special.review.required.for.valid", APPLICATION_DATE_TITLE, errorString);
        }
        if (approval.isApprovalDateFlag() && ((SpecialReview)specialReview).getApprovalDate() == null) {
            isValid = false;
            this.reportError(APPROVAL_DATE_FIELD, "error.special.review.required.for.valid", APPROVAL_DATE_TITLE, errorString);
        }
        boolean kradScreen = !StringUtils.equals((CharSequence)EXEMPTION_TYPE_CODE_FIELD, (CharSequence)this.getExemptionTypeCodeField());
        boolean noExceptions = CollectionUtils.isEmpty(kradScreen ? ((SpecialReview)specialReview).getSpecialReviewExemptions() : ((SpecialReview)specialReview).getExemptionTypeCodes());
        if (approval.isExemptNumberFlag()) {
            if (noExceptions) {
                isValid = false;
                this.reportError(this.getExemptionTypeCodeField(), "error.special.review.required.for.valid", EXEMPTION_TYPE_CODE_TITLE, errorString);
            }
        } else if (!noExceptions) {
            isValid = false;
            this.reportError(this.getExemptionTypeCodeField(), "error.special.review.cannot.select.exemption.for.valid", errorString);
        }
        return isValid;
    }

    private String getExemptionTypeCodeField() {
        List errorPath = this.getGlobalVariableService().getMessageMap().getErrorPath();
        if (errorPath.isEmpty() || StringUtils.equals((CharSequence)((CharSequence)GlobalVariables.getMessageMap().getErrorPath().get(0)), (CharSequence)"specialReviewHelper.newSpecialReview")) {
            return EXEMPTION_TYPE_CODE_FIELD;
        }
        return "specialReviewExemptions";
    }

    private boolean validateDateFields(T specialReview) {
        boolean isValid = true;
        isValid &= this.validateDateOrder(((SpecialReview)specialReview).getApplicationDate(), ((SpecialReview)specialReview).getApprovalDate(), APPROVAL_DATE_FIELD, APPLICATION_DATE_TITLE, APPROVAL_DATE_TITLE);
        isValid &= this.validateDateOrder(((SpecialReview)specialReview).getApprovalDate(), ((SpecialReview)specialReview).getExpirationDate(), EXPIRATION_DATE_FIELD, APPROVAL_DATE_TITLE, EXPIRATION_DATE_TITLE);
        return isValid &= this.validateDateOrder(((SpecialReview)specialReview).getApplicationDate(), ((SpecialReview)specialReview).getExpirationDate(), EXPIRATION_DATE_FIELD, APPLICATION_DATE_TITLE, EXPIRATION_DATE_TITLE);
    }

    private boolean validateDateOrder(Date firstDate, Date secondDate, String errorField, String firstDateTitle, String secondDateTitle) {
        boolean isValid = true;
        if (firstDate != null && secondDate != null && secondDate.before(firstDate)) {
            isValid = false;
            this.reportError(errorField, "error.special.review.date.same.or.later", secondDateTitle, firstDateTitle);
        }
        return isValid;
    }

    public GlobalVariableService getGlobalVariableService() {
        return KcServiceLocator.getService(GlobalVariableService.class);
    }
}

