/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.bo;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.web.format.BooleanFormatter;
import org.kuali.rice.core.web.format.CollectionFormatter;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.rule.RuleTemplate;
import org.kuali.rice.kew.api.rule.RuleTemplateAttribute;
import org.kuali.rice.kew.lookupable.MyColumns;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.WorkflowRuleAttributeRows;
import org.kuali.rice.kew.rule.bo.AbstractRuleLookupableHelperServiceImpl;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.service.RuleServiceInternal;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.LookupableHelperService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.web.comparator.CellComparatorHelper;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;

public class RuleBaseValuesLookupableHelperServiceImpl
extends AbstractRuleLookupableHelperServiceImpl {
    private LookupableHelperService ruleDelegationLookupableHelperService;
    private List<?> delegationPkNames;
    private static final String RULE_TEMPLATE_PROPERTY_NAME = "ruleTemplate.name";
    private static final String RULE_ID_PROPERTY_NAME = "id";
    private static final String RULE_TEMPLATE_ID_PROPERTY_NAME = "ruleTemplateId";
    private static final String ACTIVE_IND_PROPERTY_NAME = "active";
    private static final String DELEGATE_RULE_PROPERTY_NAME = "delegateRule";
    private static final String DOC_TYP_NAME_PROPERTY_NAME = "documentType.name";
    private static final String RULE_DESC_PROPERTY_NAME = "description";

    public boolean checkForAdditionalFields(Map<String, String> fieldValues) {
        String ruleTemplateNameParam = fieldValues.get(RULE_TEMPLATE_PROPERTY_NAME);
        return super.checkForAdditionalFields(fieldValues, ruleTemplateNameParam);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        Principal principal;
        String docTypeNameParam = fieldValues.get(DOC_TYP_NAME_PROPERTY_NAME);
        String ruleTemplateIdParam = fieldValues.get(RULE_TEMPLATE_ID_PROPERTY_NAME);
        String ruleTemplateNameParam = fieldValues.get(RULE_TEMPLATE_PROPERTY_NAME);
        String groupIdParam = fieldValues.get("groupReviewer");
        String groupNameParam = fieldValues.get("groupReviewerName");
        String groupNamespaceParam = fieldValues.get("groupReviewerNamespace");
        String networkIdParam = fieldValues.get("personReviewer");
        String userDirectiveParam = fieldValues.get("personReviewerType");
        String activeParam = fieldValues.get(ACTIVE_IND_PROPERTY_NAME);
        String ruleIdParam = fieldValues.get(RULE_ID_PROPERTY_NAME);
        Object ruleDescription = fieldValues.get(RULE_DESC_PROPERTY_NAME);
        String deleteSelection = fieldValues.get(DELEGATE_RULE_PROPERTY_NAME);
        Object docTypeSearchName = null;
        String workflowId = null;
        String workgroupId = null;
        String ruleTemplateId = null;
        Boolean isDelegateRule = null;
        Boolean isActive = null;
        String ruleId = null;
        if (StringUtils.isNotBlank((String)deleteSelection)) {
            isDelegateRule = deleteSelection.equalsIgnoreCase("Y") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (StringUtils.isNotBlank((String)ruleIdParam)) {
            ruleId = ruleIdParam.trim();
        }
        if (StringUtils.isNotBlank((String)activeParam)) {
            isActive = activeParam.equals("Y") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (StringUtils.isNotBlank((String)docTypeNameParam)) {
            docTypeSearchName = docTypeNameParam.replace('*', '%');
            docTypeSearchName = "%" + ((String)docTypeSearchName).trim() + "%";
        }
        if (StringUtils.isNotBlank((String)networkIdParam) && (principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(networkIdParam)) != null) {
            workflowId = principal.getPrincipalId();
        }
        if (!StringUtils.isEmpty((String)groupIdParam) || !StringUtils.isEmpty((String)groupNameParam)) {
            Group group = null;
            if (groupIdParam != null && !"".equals(groupIdParam)) {
                group = this.getGroupService().getGroup(groupIdParam.trim());
            } else {
                if (groupNamespaceParam == null) {
                    groupNamespaceParam = "KUALI";
                }
                if ((group = this.getGroupService().getGroupByNamespaceCodeAndName(groupNamespaceParam, groupNameParam.trim())) == null) {
                    GlobalVariables.getMessageMap().putError("groupReviewerNamespace", "error.custom", new String[]{"The Group Reviewer Namespace and Name combination is not valid"});
                } else {
                    workgroupId = group.getId();
                }
            }
        }
        HashMap<String, String> attributes = null;
        MyColumns myColumns = new MyColumns();
        if (StringUtils.isNotBlank((String)ruleTemplateNameParam) || StringUtils.isNotBlank((String)ruleTemplateIdParam) && !"null".equals(ruleTemplateIdParam)) {
            RuleTemplate ruleTemplate = null;
            if (StringUtils.isNotBlank((String)ruleTemplateIdParam)) {
                ruleTemplate = KewApiServiceLocator.getRuleService().getRuleTemplate(ruleTemplateIdParam);
            } else {
                ruleTemplate = KewApiServiceLocator.getRuleService().getRuleTemplateByName(ruleTemplateNameParam.trim());
                ruleTemplateId = ruleTemplate.getId();
            }
            attributes = new HashMap<String, String>();
            for (RuleTemplateAttribute ruleTemplateAttribute : ruleTemplate.getActiveRuleTemplateAttributes()) {
                if (!RuleAttribute.isWorkflowAttribute(ruleTemplateAttribute.getRuleAttribute().getType())) continue;
                WorkflowRuleAttributeRows workflowRuleAttributeRows = KEWServiceLocator.getWorkflowRuleAttributeMediator().getSearchRows(fieldValues, ruleTemplateAttribute, false);
                for (RemotableAttributeError remotableAttributeError : workflowRuleAttributeRows.getValidationErrors()) {
                    GlobalVariables.getMessageMap().putError(remotableAttributeError.getAttributeName(), "error.custom", new String[]{remotableAttributeError.getMessage()});
                }
                for (Row row : workflowRuleAttributeRows.getRows()) {
                    for (Field field : row.getFields()) {
                        String attributeParam;
                        if (fieldValues.get(field.getPropertyName()) != null && !(attributeParam = fieldValues.get(field.getPropertyName())).equals("")) {
                            attributes.put(field.getPropertyName(), attributeParam.trim());
                        }
                        if (!field.getFieldType().equals("text") && !field.getFieldType().equals("dropdown") && !field.getFieldType().equals("dropdown_refresh") && !field.getFieldType().equals("radio")) continue;
                        myColumns.getColumns().add((KeyValue)new ConcreteKeyValue(field.getPropertyName(), ruleTemplateAttribute.getId()));
                    }
                }
            }
        }
        if (!StringUtils.isEmpty((String)ruleDescription)) {
            ruleDescription = ((String)ruleDescription).replace('*', '%');
            ruleDescription = "%" + ((String)ruleDescription).trim() + "%";
        }
        if (!GlobalVariables.getMessageMap().hasNoErrors()) {
            throw new ValidationException("errors in search criteria");
        }
        List<RuleBaseValues> rules = this.getRuleService().search((String)docTypeSearchName, ruleId, ruleTemplateId, (String)ruleDescription, workgroupId, workflowId, isDelegateRule, isActive, attributes, userDirectiveParam);
        ArrayList<RuleBaseValues> displayList = new ArrayList<RuleBaseValues>();
        for (RuleBaseValues record : rules) {
            if (StringUtils.isEmpty((String)record.getDescription())) {
                record.setDescription("");
            }
            if (ruleTemplateNameParam != null && !ruleTemplateNameParam.trim().equals("") || ruleTemplateIdParam != null && !"".equals(ruleTemplateIdParam) && !"null".equals(ruleTemplateIdParam)) {
                MyColumns myNewColumns = new MyColumns();
                for (KeyValue pair : myColumns.getColumns()) {
                    ConcreteKeyValue newPair = record.getRuleExtensionValue(pair.getValue(), pair.getKey().toString()) != null ? new ConcreteKeyValue(pair.getKey(), record.getRuleExtensionValue(pair.getValue(), pair.getKey().toString()).getValue()) : new ConcreteKeyValue(pair.getKey(), "");
                    myNewColumns.getColumns().add((KeyValue)newPair);
                    record.getFieldValues().put(newPair.getKey(), newPair.getValue());
                }
                record.setMyColumns(myNewColumns);
            }
            StringBuffer returnUrl = new StringBuffer("<a href=\"");
            returnUrl.append(fieldValues.get("backLocation")).append("?methodToCall=refresh&docFormKey=").append(fieldValues.get("docFormKey")).append("&");
            returnUrl.append(RULE_ID_PROPERTY_NAME);
            returnUrl.append("=").append(record.getId()).append("\">return value</a>");
            record.setReturnUrl(returnUrl.toString());
            String string = "<a href=\"Rule.do?methodToCall=report&currentRuleId=" + record.getId() + "\">report</a>";
            record.setDestinationUrl(string);
            displayList.add(record);
        }
        return displayList;
    }

    private RuleServiceInternal getRuleService() {
        return (RuleServiceInternal)KEWServiceLocator.getService("enRuleServiceInternal");
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        List displayList = bounded ? this.getSearchResults(lookupForm.getFieldsForLookup()) : this.getSearchResultsUnbounded(lookupForm.getFieldsForLookup());
        HashMap<String, Class> propertyTypes = new HashMap<String, Class>();
        boolean hasReturnableRow = false;
        List returnKeys = this.getReturnKeys();
        List pkNames = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        Person user = GlobalVariables.getUserSession().getPerson();
        for (BusinessObject element : displayList) {
            if (element instanceof PersistableBusinessObject) {
                lookupForm.setLookupObjectId(((PersistableBusinessObject)element).getObjectId());
            }
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            HtmlData returnUrl = this.getReturnUrl(element, lookupForm, returnKeys, businessObjectRestrictions);
            String actionUrls = this.getActionUrls(element, pkNames, businessObjectRestrictions);
            if ("".equals(actionUrls)) {
                actionUrls = "&nbsp;";
            }
            boolean isRuleDelegation = element instanceof RuleBaseValues && ((RuleBaseValues)element).getDelegateRule() != false;
            List<Column> columns = this.getColumns();
            Iterator<Column> iterator = columns.iterator();
            while (iterator.hasNext()) {
                Class propClass;
                Column element2;
                Column col = element2 = iterator.next();
                Formatter formatter = col.getFormatter();
                String propValue = "";
                Object prop = null;
                boolean skipPropTypeCheck = false;
                if (element instanceof RuleBaseValues) {
                    prop = ((RuleBaseValues)element).getFieldValues().get(col.getPropertyName());
                    skipPropTypeCheck = true;
                }
                if (prop == null) {
                    prop = KradDataServiceLocator.getDataObjectService().wrap((Object)element).getPropertyValueNullSafe(col.getPropertyName());
                }
                if ((propClass = (Class)propertyTypes.get(col.getPropertyName())) == null && !skipPropTypeCheck) {
                    try {
                        propClass = KRADServiceLocatorWeb.getLegacyDataAdapter().getPropertyType((Object)element, col.getPropertyName());
                        propertyTypes.put(col.getPropertyName(), propClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot access PropertyType for property '" + col.getPropertyName() + "'  on an instance of '" + element.getClass().getName() + "'.", e);
                    }
                }
                if (prop != null) {
                    if (prop instanceof Boolean) {
                        formatter = new BooleanFormatter();
                    }
                    if (prop instanceof Date) {
                        formatter = new DateFormatter();
                    }
                    if (prop instanceof Collection && formatter == null) {
                        formatter = new CollectionFormatter();
                    }
                    propValue = formatter != null ? (String)formatter.format(prop) : prop.toString();
                }
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                propValue = this.maskValueIfNecessary(element.getClass(), col.getPropertyName(), propValue, businessObjectRestrictions);
                col.setPropertyValue(propValue);
                if (!StringUtils.isNotBlank((String)propValue)) continue;
                if (RULE_ID_PROPERTY_NAME.equals(col.getPropertyName()) && isRuleDelegation) {
                    List<RuleDelegationBo> delegationList = KEWServiceLocator.getRuleDelegationService().findByDelegateRuleId(((RuleBaseValues)element).getId());
                    if (KRADUtils.isNotNull(delegationList) && !delegationList.isEmpty()) {
                        BusinessObject ruleDelegation = (BusinessObject)delegationList.get(0);
                        col.setColumnAnchor(this.getInquiryUrl(ruleDelegation, "ruleDelegationId"));
                        continue;
                    }
                    col.setColumnAnchor(this.getInquiryUrl(element, col.getPropertyName()));
                    continue;
                }
                col.setColumnAnchor(this.getInquiryUrl(element, col.getPropertyName()));
            }
            ResultRow row = new ResultRow(columns, returnUrl.constructCompleteHtmlTag(), actionUrls);
            row.setRowId(returnUrl.getName());
            row.setReturnUrlHtmlData(returnUrl);
            if (this.getBusinessObjectDictionaryService().isExportable(this.getBusinessObjectClass()).booleanValue()) {
                row.setBusinessObject(element);
            }
            if (element instanceof PersistableBusinessObject) {
                row.setObjectId(((PersistableBusinessObject)element).getObjectId());
            }
            boolean rowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(rowReturnable);
            if (rowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
        return displayList;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        RuleBaseValues ruleBaseValues = (RuleBaseValues)businessObject;
        List<Object> htmlDataList = new ArrayList<HtmlData>();
        if (StringUtils.isNotBlank((String)ruleBaseValues.getRuleTemplateName()) && StringUtils.isNotBlank((String)this.getMaintenanceDocumentTypeName())) {
            if (ruleBaseValues.getDelegateRule().booleanValue()) {
                List<RuleDelegationBo> delegationList = KEWServiceLocator.getRuleDelegationService().findByDelegateRuleId(ruleBaseValues.getId());
                if (KRADUtils.isNotNull(delegationList) && !delegationList.isEmpty()) {
                    BusinessObject ruleDelegation = (BusinessObject)delegationList.get(0);
                    if (this.ruleDelegationLookupableHelperService == null) {
                        this.ruleDelegationLookupableHelperService = KNSServiceLocator.getLookupable((String)KNSServiceLocator.getBusinessObjectDictionaryService().getLookupableID(ruleDelegation.getClass())).getLookupableHelperService();
                        if (this.ruleDelegationLookupableHelperService.getBusinessObjectClass() == null) {
                            this.ruleDelegationLookupableHelperService.setBusinessObjectClass(ruleDelegation.getClass());
                        }
                        this.delegationPkNames = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(ruleDelegation.getClass());
                    }
                    htmlDataList = this.ruleDelegationLookupableHelperService.getCustomActionUrls(ruleDelegation, this.delegationPkNames);
                }
            } else {
                if (this.allowsMaintenanceEditAction(businessObject)) {
                    htmlDataList.add((HtmlData)this.getUrlData(businessObject, "edit", pkNames));
                }
                if (this.allowsMaintenanceNewOrCopyAction()) {
                    htmlDataList.add((HtmlData)this.getUrlData(businessObject, "copy", pkNames));
                }
            }
        }
        return htmlDataList;
    }
}

