/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.SimpleMemberModel;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.Collections12;
import freemarker.template.utility.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public final class SimpleMethodModel
extends SimpleMemberModel
implements TemplateMethodModelEx,
TemplateSequenceModel {
    private final Object object;
    private final BeansWrapper wrapper;

    SimpleMethodModel(Object object, Method method, Class[] argTypes, BeansWrapper wrapper) {
        super(method, argTypes);
        this.object = object;
        this.wrapper = wrapper;
    }

    public Object exec(List arguments) throws TemplateModelException {
        try {
            return this.wrapper.invokeMethod(this.object, (Method)this.getMember(), this.unwrapArguments(arguments, this.wrapper));
        }
        catch (TemplateModelException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable t;
            while (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof Exception) {
                e = (Exception)t;
            }
            if ((this.getMember().getModifiers() & 8) != 0) {
                throw new TemplateModelException("Method " + StringUtil.jQuote(this.getMember()) + " threw an exception; see cause exception", e);
            }
            throw new TemplateModelException("Method " + StringUtil.jQuote(this.getMember()) + " threw an exception when invoked on " + this.object.getClass().getName() + " object " + StringUtil.jQuote(StringUtil.tryToString(this.object)) + ". See cause exception.", e);
        }
    }

    public TemplateModel get(int index) throws TemplateModelException {
        return (TemplateModel)this.exec(Collections12.singletonList(new SimpleNumber(new Integer(index))));
    }

    public int size() throws TemplateModelException {
        throw new TemplateModelException("Getting the number of items or enumerating the items is not supported on this " + ClassUtil.getFTLTypeDescription(this) + " value.\n" + "(" + "Hint 1: Maybe you wanted to call this method first and then do something with its return value. " + "Hint 2: Getting items by intex possibly works, hence it's a \"+sequence\"." + ")");
    }

    public String toString() {
        return this.getMember().toString();
    }
}

