/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.transition;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.Node;
import org.kuali.rice.kew.engine.node.ProcessResult;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.transition.Transition;

public abstract class TransitionEngine {
    private RouteHelper helper;

    public RouteNodeInstance transitionTo(RouteNodeInstance nextNodeInstance, RouteContext context) throws Exception {
        return nextNodeInstance;
    }

    public abstract ProcessResult isComplete(RouteContext var1) throws Exception;

    public Transition transitionFrom(RouteContext context, ProcessResult processResult) throws Exception {
        return new Transition(this.resolveNextNodeInstances(context.getNodeInstance()));
    }

    protected void setRouteHelper(RouteHelper helper) {
        this.helper = helper;
    }

    protected RouteHelper getRouteHelper() {
        return this.helper;
    }

    protected Node getNode(RouteNode routeNode, Class nodeClass) throws Exception {
        return this.helper.getNode(routeNode);
    }

    protected List<RouteNodeInstance> resolveNextNodeInstances(RouteNodeInstance nodeInstance, List<RouteNode> nextRouteNodes) {
        ArrayList<RouteNodeInstance> nextNodeInstances = new ArrayList<RouteNodeInstance>();
        for (RouteNode nextRouteNode : nextRouteNodes) {
            RouteNodeInstance nextNodeInstance = this.getRouteHelper().getNodeFactory().createRouteNodeInstance(nodeInstance.getDocumentId(), nextRouteNode);
            nextNodeInstance.setBranch(nodeInstance.getBranch());
            nextNodeInstance.setProcess(nodeInstance.getProcess());
            nextNodeInstances.add(nextNodeInstance);
        }
        return nextNodeInstances;
    }

    protected List<RouteNodeInstance> resolveNextNodeInstances(RouteNodeInstance nodeInstance) {
        return this.resolveNextNodeInstances(nodeInstance, nodeInstance.getRouteNode().getNextNodes());
    }
}

