/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;

public class QuerySearchRequest
extends TransportRequest
implements IndicesRequest {
    private long id;
    private AggregatedDfs dfs;
    private OriginalIndices originalIndices;

    public QuerySearchRequest() {
    }

    public QuerySearchRequest(OriginalIndices originalIndices, long id, AggregatedDfs dfs) {
        this.id = id;
        this.dfs = dfs;
        this.originalIndices = originalIndices;
    }

    public QuerySearchRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readLong();
        this.dfs = new AggregatedDfs(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        this.dfs.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }

    public long id() {
        return this.id;
    }

    public AggregatedDfs dfs() {
        return this.dfs;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("id[");
        sb.append(this.id);
        sb.append("], ");
        sb.append("indices[");
        Strings.arrayToDelimitedString(this.originalIndices.indices(), ",", sb);
        sb.append("]");
        return sb.toString();
    }
}

