/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class WrappedConnection
implements Connection {
    private Connection _conn = null;
    private boolean _isClosed = false;

    public WrappedConnection(Connection connection) {
        this._conn = connection;
    }

    public Connection getDelegate() {
        return this._conn;
    }

    public Connection getInnermostDelegate() {
        Connection connection = this._conn;
        while (connection != null && connection instanceof WrappedConnection) {
            if (this != (connection = ((WrappedConnection)connection).getDelegate())) continue;
            return null;
        }
        return connection;
    }

    public void setDelegate(Connection connection) {
        this._conn = connection;
    }

    protected void checkOpen() throws SQLException {
        if (this._isClosed) {
            throw new SQLException("Connection is closed. " + this);
        }
    }

    public void activateConnection() {
        this._isClosed = false;
        if (this._conn instanceof WrappedConnection) {
            ((WrappedConnection)this._conn).activateConnection();
        }
    }

    public void passivateConnection() throws SQLException {
        this._isClosed = true;
        if (this._conn instanceof WrappedConnection) {
            ((WrappedConnection)this._conn).passivateConnection();
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("wrapped connection", this._conn != null ? this._conn.toString() : null).toString();
    }

    @Override
    public void close() throws SQLException {
        this.passivateConnection();
        this._conn.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._isClosed || this._conn.isClosed();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return this._conn.createStatement();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkOpen();
        return this._conn.createStatement(n, n2);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string, n, n2);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkOpen();
        return this._conn.prepareCall(string);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        return this._conn.prepareCall(string, n, n2);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this._conn.clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        this._conn.commit();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this._conn.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this._conn.getCatalog();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this._conn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this._conn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.checkOpen();
        return this._conn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this._conn.getWarnings();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this._conn.isReadOnly();
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.checkOpen();
        return this._conn.nativeSQL(string);
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        this._conn.rollback();
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkOpen();
        this._conn.setAutoCommit(bl);
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.checkOpen();
        this._conn.setCatalog(string);
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.checkOpen();
        this._conn.setReadOnly(bl);
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.checkOpen();
        this._conn.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkOpen();
        this._conn.setTypeMap(map);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.checkOpen();
        return this._conn.isWrapperFor(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkOpen();
        return this._conn.unwrap(clazz);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.checkOpen();
        return this._conn.createArrayOf(string, objectArray);
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkOpen();
        return this._conn.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkOpen();
        return this._conn.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkOpen();
        return this._conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkOpen();
        return this._conn.createSQLXML();
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.checkOpen();
        return this._conn.createStruct(string, objectArray);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkOpen();
        return this._conn.getClientInfo();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkOpen();
        return this._conn.getClientInfo(string);
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        this.checkOpen();
        return this._conn.isValid(n);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this._conn.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        this._conn.setClientInfo(string, string2);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return this._conn.getHoldability();
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.checkOpen();
        this._conn.setHoldability(n);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        return this._conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.checkOpen();
        return this._conn.setSavepoint(string);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this._conn.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this._conn.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        return this._conn.createStatement(n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string, n, n2, n3);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        return this._conn.prepareCall(string, n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string, n);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string, nArray);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string, stringArray);
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this._conn.setSchema(string);
    }

    @Override
    public String getSchema() throws SQLException {
        return this._conn.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this._conn.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this._conn.setNetworkTimeout(executor, n);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this._conn.getNetworkTimeout();
    }
}

