/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.krms;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.impl.krms.FunctionParamComparator;
import org.kuali.coeus.common.impl.krms.FunctionTermResolver;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krms.api.repository.function.FunctionDefinition;
import org.kuali.rice.krms.api.repository.function.FunctionParameterDefinition;

public class JavaFunctionResolver
extends FunctionTermResolver {
    protected final Logger LOG = LogManager.getLogger(JavaFunctionResolver.class);
    private static final HashSet<Class<?>> WRAPPER_TYPES = JavaFunctionResolver.getWrapperTypes();

    public JavaFunctionResolver(List<String> orderedInputParams, Set<String> parameterNames, String output, FunctionDefinition functionTerm) {
        super(orderedInputParams, parameterNames, output);
        this.setFunctionTerm(functionTerm);
    }

    @Override
    protected Object executeFunction(String serviceName, String methodName, Map<String, Object> resolvedPrereqs, Map<String, String> resolvedParameters) {
        List<Object> orderedParamValues = this.extractParamValues(resolvedPrereqs, resolvedParameters);
        if (serviceName == null) {
            throw new RuntimeException("Service name is not defined for the term:" + this.getOutput());
        }
        return this.callFunction(serviceName, methodName, orderedParamValues);
    }

    private static HashSet<Class<?>> getWrapperTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        return ret;
    }

    private Object callFunction(String serviceName, String methodName, List<Object> orderedParamValues) {
        try {
            ArrayList<Object> functionParamObjects = new ArrayList<Object>();
            List functionParams = this.getFunctionTerm().getParameters();
            ArrayList modifiableParams = new ArrayList(functionParams);
            Collections.sort(modifiableParams, new FunctionParamComparator());
            Class[] classtypes = new Class[orderedParamValues.size()];
            for (int i = 0; i < orderedParamValues.size(); ++i) {
                Object objValue = orderedParamValues.get(i);
                String paramClassType = ((FunctionParameterDefinition)modifiableParams.get(i)).getParameterType();
                Class<?> paramClass = Class.forName(paramClassType);
                if (WRAPPER_TYPES.contains(paramClass)) {
                    Object convertedObject = this.wrapValue(objValue, paramClassType);
                    classtypes[i] = paramClass;
                    functionParamObjects.add(convertedObject);
                    continue;
                }
                classtypes[i] = paramClass;
                functionParamObjects.add(objValue);
            }
            Object javaFucntionService = KcServiceLocator.getService(serviceName);
            Class<?> javaFucntionServiceClass = javaFucntionService.getClass();
            Method method = javaFucntionServiceClass.getMethod(methodName, classtypes);
            return method.invoke(javaFucntionService, functionParamObjects.toArray());
        }
        catch (Exception e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Object wrapValue(Object objValue, String paramClassType) {
        Object retObj = objValue;
        if (objValue == null) {
            return null;
        }
        if (paramClassType.equals("java.lang.Integer")) {
            retObj = new Integer(objValue.toString());
        } else if (paramClassType.equals("java.lang.Long")) {
            retObj = new Long(objValue.toString());
        } else if (paramClassType.equals("java.lang.Boolean")) {
            retObj = new Boolean(objValue.toString());
        } else if (paramClassType.equals("java.lang.Float")) {
            retObj = new Float(objValue.toString());
        } else if (paramClassType.equals("java.lang.Double")) {
            retObj = new Double(objValue.toString());
        }
        return retObj;
    }
}

