/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.map;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.type.OrganizationTypeContract;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionAnswerService;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.propdev.api.abstrct.ProposalAbstractContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityCfdaContract;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.propdev.api.s2s.override.S2sOverrideContract;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.questionnaire.ProposalDevelopmentModuleQuestionnaireBean;
import org.kuali.coeus.propdev.impl.s2s.map.ApplicantOrganization;
import org.kuali.coeus.propdev.impl.s2s.map.AttachmentMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.Compliance;
import org.kuali.coeus.propdev.impl.s2s.map.FundingOpportunity;
import org.kuali.coeus.propdev.impl.s2s.map.MappingConstants;
import org.kuali.coeus.propdev.impl.s2s.map.PersonMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.Project;
import org.kuali.coeus.propdev.impl.s2s.map.RenewalInformation;
import org.kuali.coeus.propdev.impl.s2s.map.S2sMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.SubmissionInformation;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sModuleQuestionnaireBean;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetInfoService;
import org.kuali.coeus.sys.api.model.Cfda;
import org.kuali.coeus.sys.api.model.Coded;
import org.kuali.coeus.sys.api.model.CodedNumeric;
import org.kuali.coeus.sys.api.model.Inactivatable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="s2sMappingService")
public class S2sMappingServiceImpl
implements S2sMappingService {
    @Autowired
    @Qualifier(value="personMappingService")
    private PersonMappingService personMappingService;
    @Autowired
    @Qualifier(value="questionnaireAnswerService")
    private QuestionnaireAnswerService questionnaireAnswerService;
    @Autowired
    @Qualifier(value="attachmentMappingService")
    private AttachmentMappingService attachmentMappingService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;
    @Autowired
    @Qualifier(value="questionAnswerService")
    private QuestionAnswerService questionAnswerService;
    @Autowired
    @Qualifier(value="s2SBudgetInfoService")
    private S2SBudgetInfoService s2SBudgetInfoService;
    private static final SimpleDateFormat questionnaireDateFormatter = new SimpleDateFormat("MM/dd/yyyy", Locale.ENGLISH);

    @Override
    public Project toProject(ProposalDevelopmentDocumentContract pdDoc) {
        DevelopmentProposal proposal = (DevelopmentProposal)pdDoc.getDevelopmentProposal();
        ProposalDevelopmentModuleQuestionnaireBean moduleBean = new ProposalDevelopmentModuleQuestionnaireBean(proposal);
        ProposalDevelopmentS2sModuleQuestionnaireBean s2sModuleBean = new ProposalDevelopmentS2sModuleQuestionnaireBean(proposal);
        List<AnswerHeader> questionnaireAnswers = Stream.concat(this.questionnaireAnswerService.getQuestionnaireAnswer(moduleBean).stream(), this.questionnaireAnswerService.getQuestionnaireAnswer(s2sModuleBean).stream()).collect(Collectors.toList());
        Project project = new Project();
        project.setTitle(proposal.getTitle());
        this.getAbstract(proposal, "1").ifPresent(project::setProjectDescription);
        this.getAbstract(proposal, "16").ifPresent(project::setAreasAffected);
        this.getAbstract(proposal, "15").ifPresent(project::setDeviationAuthorization);
        this.getAbstract(proposal, "12").ifPresent(project::setSuggestedReviewers);
        this.getAbstract(proposal, "14").ifPresent(project::setReviewersNotToInclude);
        project.setStartDate(proposal.getRequestedStartDateInitial());
        project.setEndDate(proposal.getRequestedEndDateInitial());
        project.setAwardNumber(proposal.getCurrentAwardNumber());
        this.getAgencyName(proposal).ifPresent(project::setAgencyName);
        project.setCfdaNumbers(this.getCfdaNumbers(proposal));
        project.setCfdaProgramTitle(proposal.getProgramAnnouncementTitle());
        this.getActivityTitle(proposal).ifPresent(project::setActivityTitle);
        this.getFundingOpportunity(proposal).ifPresent(project::setFundingOpportunity);
        project.setApplicantOrganization(this.getApplicantOrganization(proposal));
        this.personMappingService.getProjectDirector(proposal).ifPresent(project::setProjectDirector);
        this.personMappingService.getContactPerson(proposal).ifPresent(project::setContactPerson);
        project.setCompliance(this.getCompliance(questionnaireAnswers));
        project.setRenewalInformation(this.getRenewalInformation(questionnaireAnswers));
        project.setAttachments(this.attachmentMappingService.getAttachments(proposal));
        project.setSubmissionInformation(this.getSubmissionInformation(proposal, questionnaireAnswers));
        project.setAdditionalProperty("budgetSummary", this.s2SBudgetInfoService.getBudgetInfo(pdDoc));
        return project;
    }

    private Optional<String> getActivityTitle(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getS2sOpportunity()).map(S2sOpportunityContract::getS2sOpportunityCfdas).map(cfdas -> (S2sOpportunityCfdaContract)cfdas.stream().findFirst().get()).map(Cfda::getCfdaDescription);
    }

    private ApplicantOrganization getApplicantOrganization(DevelopmentProposalContract proposal) {
        ApplicantOrganization applicantOrganization = new ApplicantOrganization();
        ProposalSiteContract proposalSite = proposal.getApplicantOrganization();
        applicantOrganization.setName(proposalSite.getLocationName());
        applicantOrganization.setHumanSubjectsAssuranceNumber(proposalSite.getOrganization().getHumanSubAssurance());
        applicantOrganization.setAuthorizedRepresentative(this.getPersonMappingService().getAor(proposal));
        this.getEmployerTaxpayerId(proposal).ifPresent(applicantOrganization::setEmployerTaxpayerId);
        applicantOrganization.setDunsNumber(proposalSite.getOrganization().getDunsNumber());
        applicantOrganization.setCongressionalDistrict(proposalSite.getOrganization().getCongressionalDistrict());
        applicantOrganization.setApplicantTypes(this.getApplicantTypes(proposalSite.getOrganization()));
        applicantOrganization.setApplicantTypeOtherDescriptions(this.getApplicantTypeOtherDescriptions(proposalSite.getOrganization()));
        Optional.ofNullable(proposalSite.getState()).ifPresent(applicantOrganization::setState);
        this.getDepartmentName(proposal).ifPresent(applicantOrganization::setDepartmentName);
        this.getDivisionName(proposal).ifPresent(applicantOrganization::setDivisionName);
        return applicantOrganization;
    }

    private Optional<String> getDepartmentName(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getOwnedByUnit()).map(UnitContract::getUnitName);
    }

    private Optional<String> getDivisionName(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getOwnedByUnit()).map(UnitContract::getParentUnit).map(UnitContract::getUnitName).or(() -> Optional.ofNullable(proposal.getOwnedByUnit()).map(UnitContract::getUnitName));
    }

    private List<String> getApplicantTypes(OrganizationContract organization) {
        return this.getOrganizationTypeCodes(organization).map(MappingConstants.APPLICANT_TYPES::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<String> getApplicantTypeOtherDescriptions(OrganizationContract organization) {
        return this.getOrganizationTypeCodes(organization).map(MappingConstants.APPLICANT_OTHER_TYPE_DESCRIPTIONS::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Stream<Integer> getOrganizationTypeCodes(OrganizationContract organization) {
        return organization.getOrganizationTypes().stream().map(OrganizationTypeContract::getOrganizationTypeList).map(CodedNumeric::getCode);
    }

    private String getApplicationTypeCode(DevelopmentProposalContract proposal) {
        String proposalTypeCode = proposal.getProposalType().getCode();
        if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_NEW").contains(proposalTypeCode)) {
            return MappingConstants.ApplicationType.New.toString();
        }
        if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_REVISION").contains(proposalTypeCode)) {
            return MappingConstants.ApplicationType.Revision.toString();
        }
        if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RENEWAL").contains(proposalTypeCode)) {
            return MappingConstants.ApplicationType.Renewal.toString();
        }
        if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RESUBMISSION").contains(proposalTypeCode)) {
            return MappingConstants.ApplicationType.Resubmission.toString();
        }
        if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_CONTINUATION").contains(proposalTypeCode)) {
            return MappingConstants.ApplicationType.Continuation.toString();
        }
        return null;
    }

    private Optional<String> getAgencyName(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getSponsor()).map(SponsorContract::getSponsorName).or(() -> Optional.ofNullable(proposal.getPrimeSponsor()).map(SponsorContract::getSponsorName));
    }

    private List<String> getCfdaNumbers(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getProposalCfdas()).orElse(List.of()).stream().map(Cfda::getCfdaNumber).collect(Collectors.toList());
    }

    private Optional<FundingOpportunity> getFundingOpportunity(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getS2sOpportunity()).map(opportunity -> {
            FundingOpportunity fundingOpportunity = new FundingOpportunity();
            fundingOpportunity.setNumber(opportunity.getOpportunityId());
            fundingOpportunity.setTitle(opportunity.getOpportunityTitle());
            return fundingOpportunity;
        });
    }

    private Optional<String> getEmployerTaxpayerId(DevelopmentProposalContract proposal) {
        boolean isNIH = ((DevelopmentProposal)proposal).isNIHSponsor();
        return Optional.ofNullable(proposal.getApplicantOrganization()).map(ProposalSiteContract::getOrganization).map(org -> isNIH && StringUtils.isNotBlank((CharSequence)org.getPhsAccount()) ? org.getPhsAccount() : org.getFederalEmployerId());
    }

    private Compliance getCompliance(List<AnswerHeader> questionnaireAnswers) {
        Compliance compliance = new Compliance();
        this.getAnswerAsBoolean(questionnaireAnswers, 145).ifPresent(compliance::setVertebrateAnimals);
        this.getAnswerAsBoolean(questionnaireAnswers, 146).ifPresent(compliance::setAnimalEuthanasiaIndicator);
        this.getAnswerAsBoolean(questionnaireAnswers, 147).ifPresent(compliance::setAVMAConsistentIndicator);
        this.getQuestionAnswer(questionnaireAnswers, 148).ifPresent(compliance::setEuthanasiaMethodDescription);
        this.getAnswerAsBoolean(questionnaireAnswers, 5).ifPresent(compliance::setIsHumanStemCellsInvolved);
        this.getAnswerAsBoolean(questionnaireAnswers, 6).ifPresent(compliance::setStemCellsIndicator);
        this.getQuestionAnswers(questionnaireAnswers, 149).ifPresent(compliance::setCellLines);
        this.getAnswerAsBoolean(questionnaireAnswers, -10145).ifPresent(compliance::setIsHumanFetalTissueInvolved);
        return compliance;
    }

    private RenewalInformation getRenewalInformation(List<AnswerHeader> questionnaireAnswers) {
        RenewalInformation renewal = new RenewalInformation();
        this.getAnswerAsBoolean(questionnaireAnswers, 118).ifPresent(renewal::setIsRenewalApplication);
        this.getAnswerAsBoolean(questionnaireAnswers, 120).ifPresent(renewal::setIsPreviouslyReported);
        this.getAnswerAsBoolean(questionnaireAnswers, 119).ifPresent(renewal::setIsInventionsAndPatents);
        this.getAnswerAsBoolean(questionnaireAnswers, 114).ifPresent(renewal::setIsChangeOfPDPI);
        this.getAnswerAsBoolean(questionnaireAnswers, 116).ifPresent(renewal::setIsChangeOfInstitution);
        this.getQuestionAnswer(questionnaireAnswers, 117).ifPresent(renewal::setFormerInstitutionName);
        this.getQuestionAnswer(questionnaireAnswers, 115).map(Integer::parseInt).flatMap(this.personMappingService::fromRolodex).ifPresent(renewal::setFormerPD);
        return renewal;
    }

    private SubmissionInformation getSubmissionInformation(DevelopmentProposalContract proposal, List<AnswerHeader> questionnaireAnswers) {
        SubmissionInformation submissionInformation = new SubmissionInformation();
        submissionInformation.setApplicantId(proposal.getProposalNumber());
        Optional.ofNullable(proposal.getSponsorProposalNumber()).ifPresent(submissionInformation::setFederalId);
        this.getSubmissionTypeCode(proposal).ifPresent(submissionInformation::setSubmissionTypeCode);
        submissionInformation.setSubmittedDate(this.getSubmittedDate(proposal));
        Optional.ofNullable(proposal.getAgencyRoutingIdentifier()).ifPresent(submissionInformation::setAgencyRoutingNumber);
        Optional.ofNullable(proposal.getPrevGrantsGovTrackingID()).ifPresent(submissionInformation::setGgTrackingId);
        submissionInformation.setApplicationTypeCode(this.getApplicationTypeCode(proposal));
        this.getRevisionCode(proposal).ifPresent(submissionInformation::setRevisionCode);
        this.getRevisionCodeOtherExplanation(proposal).ifPresent(submissionInformation::setRevisionCodeOtherExplanation);
        this.getAnswerAsBoolean(questionnaireAnswers, 128).ifPresent(submissionInformation::setIsOtherAgencySubmission);
        this.getQuestionAnswerDescription(questionnaireAnswers, 111).ifPresent(submissionInformation::setOtherAgencySubmissionExplanation);
        this.getStateReviewTypeCode(questionnaireAnswers).ifPresent(submissionInformation::setStateReviewTypeCode);
        this.getQuestionAnswer(questionnaireAnswers, 130).map(this::parseAnswerDate).ifPresent(submissionInformation::setStateReviewDate);
        return submissionInformation;
    }

    private Date getSubmittedDate(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getS2sOverride()).filter(Inactivatable::isActive).map(S2sOverrideContract::getSubmittedDate).map(sqlDate -> new Date(sqlDate.getTime())).orElse(Calendar.getInstance().getTime());
    }

    private Optional<String> getSubmissionTypeCode(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getS2sOpportunity()).map(S2sOpportunityContract::getS2sSubmissionType).map(Coded::getCode).map(MappingConstants.SubmissionType::fromCode).map(opportunitySubmissionType -> this.applySubmissionTypeOverride((MappingConstants.SubmissionType)((Object)opportunitySubmissionType), proposal)).map(Enum::toString);
    }

    private MappingConstants.SubmissionType applySubmissionTypeOverride(MappingConstants.SubmissionType opportunitySubmissionType, DevelopmentProposalContract proposal) {
        if (proposal.getProposalType() != null) {
            String proposalTypeCode = proposal.getProposalType().getCode();
            if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_NEW_CHANGE_CORRECTED").contains(proposalTypeCode) || this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_SUPPLEMENT_CHANGE_CORRECTED").contains(proposalTypeCode) || this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RENEWAL_CHANGE_CORRECTED").contains(proposalTypeCode) || this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RESUBMISSION_CHANGE_CORRECTED").contains(proposalTypeCode)) {
                return MappingConstants.SubmissionType.ChangeCorrected;
            }
            if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_PRE_PROPOSAL").contains(proposalTypeCode)) {
                return MappingConstants.SubmissionType.Preapplication;
            }
        }
        return opportunitySubmissionType;
    }

    private Optional<String> getRevisionCode(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getS2sOpportunity()).map(S2sOpportunityContract::getS2sRevisionType).map(Coded::getCode).filter(code -> this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_REVISION").contains(proposal.getProposalType().getCode()));
    }

    private Optional<String> getRevisionCodeOtherExplanation(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getS2sOpportunity()).map(S2sOpportunityContract::getRevisionOtherDescription).filter(desc -> this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_REVISION").contains(proposal.getProposalType().getCode()));
    }

    private Optional<String> getStateReviewTypeCode(Collection<AnswerHeader> answerHeaders) {
        return this.getAnswerAsBoolean(answerHeaders, 129).map(isSubjectToStateReview -> {
            if (isSubjectToStateReview.booleanValue()) {
                return MappingConstants.StateReviewCode.Yes.getS2sDescription();
            }
            return this.getQuestionAnswer(answerHeaders, 131).map(MappingConstants.StateReviewCode::fromAnswer).map(MappingConstants.StateReviewCode::getS2sDescription).get();
        });
    }

    private Optional<Boolean> getAnswerAsBoolean(Collection<AnswerHeader> answerHeaders, int questionId) {
        return this.getQuestionAnswer(answerHeaders, questionId).map("Y"::equals);
    }

    private Optional<String> getQuestionAnswer(Collection<AnswerHeader> answerHeaders, int questionId) {
        return this.findQuestionAnswer(answerHeaders, questionId).map(Answer::getAnswer);
    }

    private Optional<String> getQuestionAnswerDescription(Collection<AnswerHeader> answerHeaders, int questionId) {
        return this.findQuestionAnswer(answerHeaders, questionId).map(answer -> this.questionAnswerService.getAnswerDescription(answer.getId()));
    }

    private Optional<Answer> findQuestionAnswer(Collection<AnswerHeader> answerHeaders, int questionId) {
        return answerHeaders.stream().flatMap(header -> header.getAnswers().stream()).filter(answer -> answer.getQuestionSeqId().equals(questionId)).filter(answer -> "Y".equals(answer.getMatchedChild())).filter(answer -> StringUtils.isNotBlank((CharSequence)answer.getAnswer())).findFirst();
    }

    private Optional<List<String>> getQuestionAnswers(Collection<AnswerHeader> answerHeaders, int questionId) {
        List answers = answerHeaders.stream().flatMap(header -> header.getAnswers().stream()).filter(answer -> answer.getQuestionSeqId().equals(questionId)).filter(answer -> "Y".equals(answer.getMatchedChild())).map(Answer::getAnswer).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        return answers.isEmpty() ? Optional.empty() : Optional.of(answers);
    }

    private Optional<String> getAbstract(DevelopmentProposalContract proposal, String abstractTypeCode) {
        return proposal.getProposalAbstracts().stream().filter(proposalAbstract -> proposalAbstract.getAbstractType().getCode().equals(abstractTypeCode)).findFirst().map(ProposalAbstractContract::getAbstractDetails);
    }

    private Date parseAnswerDate(String dateString) {
        try {
            return questionnaireDateFormatter.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public PersonMappingService getPersonMappingService() {
        return this.personMappingService;
    }

    public void setPersonMappingService(PersonMappingService personMappingService) {
        this.personMappingService = personMappingService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public AttachmentMappingService getAttachmentMappingService() {
        return this.attachmentMappingService;
    }

    public void setAttachmentMappingService(AttachmentMappingService attachmentMappingService) {
        this.attachmentMappingService = attachmentMappingService;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    public QuestionAnswerService getQuestionAnswerService() {
        return this.questionAnswerService;
    }

    public void setQuestionAnswerService(QuestionAnswerService questionAnswerService) {
        this.questionAnswerService = questionAnswerService;
    }

    public S2SBudgetInfoService getS2SBudgetInfoService() {
        return this.s2SBudgetInfoService;
    }

    public void setS2SBudgetInfoService(S2SBudgetInfoService s2SBudgetInfoService) {
        this.s2SBudgetInfoService = s2SBudgetInfoService;
    }
}

