/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.helpers;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncException;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncableProperty;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncHelper;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncServiceImpl;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncUtilityService;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public abstract class AwardSyncHelperBase
implements AwardSyncHelper {
    protected final Logger LOG = LogManager.getLogger(AwardSyncServiceImpl.class);
    protected final String DELIMITER = " : ";
    private AwardSyncUtilityService awardSyncUtilityService;

    @Override
    public AwardSyncChange createAwardSyncChange(AwardSyncType syncType, PersistableBusinessObject syncableObject, String awardAttrName, String boAttrName) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        AwardSyncChange syncChange = new AwardSyncChange();
        syncChange.setClassName(syncableObject.getClass().getCanonicalName());
        syncChange.setAttrName(awardAttrName);
        syncChange.setSyncType(syncType.getSyncValue());
        syncChange.setObjectDesc(this.getObjectDesc(syncableObject, boAttrName));
        syncChange.setDataDesc(this.getDataDesc(syncableObject, boAttrName));
        syncChange.setXmlExport(this.buildXmlExport(syncableObject, boAttrName));
        return syncChange;
    }

    protected abstract String getObjectDesc(PersistableBusinessObject var1, String var2);

    protected abstract String getDataDesc(PersistableBusinessObject var1, String var2);

    @Override
    public AwardSyncXmlExport buildXmlExport(PersistableBusinessObject syncable, String attrName) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        return this.buildXmlExport(syncable, attrName, null, null, true);
    }

    protected AwardSyncXmlExport buildXmlExport(PersistableBusinessObject syncable, String attrName, String childAttr, AwardSyncXmlExport childExport, boolean walkParents) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = syncable.getClass();
        AwardSyncXmlExport parentExport = null;
        AwardSyncXmlExport xmlExport = new AwardSyncXmlExport();
        xmlExport.setClassName(syncable.getClass().getName());
        xmlExport.setKeys(new HashMap<String, Object>());
        xmlExport.setValues(new HashMap<String, Object>());
        if (childExport != null) {
            xmlExport.getValues().put(childAttr, childExport);
        }
        if (walkParents) {
            xmlExport.setPartOfObjectKey(true);
        }
        for (PropertyDescriptor propDescriptor : PropertyUtils.getPropertyDescriptors(clazz)) {
            AwardSyncableProperty annotation;
            Field propertyField = this.findField(clazz, propDescriptor.getName());
            if (propertyField == null || (annotation = propertyField.getAnnotation(AwardSyncableProperty.class)) == null) continue;
            Object propertyValue = propDescriptor.getReadMethod().invoke((Object)syncable, new Object[0]);
            if (walkParents && annotation.parent()) {
                parentExport = this.buildXmlExport((PersistableBusinessObject)propertyValue, null, annotation.parentProperty(), xmlExport, true);
                parentExport.setAddIfNotFound(false);
                continue;
            }
            if (annotation.parent()) continue;
            Object mapValue = this.getValueForExport(propertyValue);
            if (annotation.key()) {
                xmlExport.getKeys().put(propDescriptor.getName(), mapValue);
                continue;
            }
            if (attrName != null && !StringUtils.equals((CharSequence)attrName, (CharSequence)propDescriptor.getName()) || childAttr != null) continue;
            xmlExport.getValues().put(propDescriptor.getName(), mapValue);
        }
        if (parentExport != null) {
            return parentExport;
        }
        return xmlExport;
    }

    protected Object getValueForExport(Object propertyValue) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Object mapValue = null;
        mapValue = propertyValue instanceof Collection ? this.buildXmlExport((Collection)propertyValue) : (propertyValue instanceof PersistableBusinessObject ? this.buildXmlExport((PersistableBusinessObject)propertyValue, null, null, null, false) : propertyValue);
        return mapValue;
    }

    protected List<AwardSyncXmlExport> buildXmlExport(Collection syncables) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        ArrayList<AwardSyncXmlExport> xmls = new ArrayList<AwardSyncXmlExport>();
        for (Object object : syncables) {
            if (!(object instanceof PersistableBusinessObject)) continue;
            xmls.add(this.buildXmlExport((PersistableBusinessObject)object, null, null, null, false));
        }
        return xmls;
    }

    protected Field findField(Class clazz, String propertyName) {
        if (clazz != null) {
            Field retVal = null;
            try {
                retVal = clazz.getDeclaredField(propertyName);
            }
            catch (SecurityException e) {
                this.LOG.info("Security exception when trying to find " + propertyName + " for class" + clazz.getSimpleName(), (Throwable)e);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (retVal != null) {
                return retVal;
            }
            return this.findField(clazz.getSuperclass(), propertyName);
        }
        return null;
    }

    @Override
    public void applySyncChange(Award award, AwardSyncChange change) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, InstantiationException, AwardSyncException {
        this.applySyncChange((PersistableBusinessObject)award, change, change.getAttrName(), change.getXmlExport());
    }

    protected void applySyncChange(PersistableBusinessObject object, AwardSyncChange change, String attrName, AwardSyncXmlExport xmlExport) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, InstantiationException {
        Object propertyValue = this.getPropertyValue(object, attrName);
        if (propertyValue instanceof Collection) {
            Collection items = (Collection)propertyValue;
            PersistableBusinessObject matchedBo = this.getAwardSyncUtilityService().findMatchingBo(items, xmlExport.getKeys());
            Map<String, Object> values = xmlExport.getValues();
            if (StringUtils.equals((CharSequence)change.getSyncType(), (CharSequence)AwardSyncType.ADD_SYNC.getSyncValue())) {
                if (matchedBo == null) {
                    if (xmlExport.isAddIfNotFound()) {
                        matchedBo = this.createNewItem(change, xmlExport);
                        items.add(matchedBo);
                    }
                } else {
                    this.setValuesOnSyncable(matchedBo, values, change);
                }
            } else if (StringUtils.equals((CharSequence)change.getSyncType(), (CharSequence)AwardSyncType.DELETE_SYNC.getSyncValue())) {
                items.remove(matchedBo);
            }
        } else if (StringUtils.equals((CharSequence)change.getSyncType(), (CharSequence)AwardSyncType.ADD_SYNC.getSyncValue())) {
            if (propertyValue != null && !this.getAwardSyncUtilityService().doKeyValuesMatch((PersistableBusinessObject)propertyValue, xmlExport.getKeys())) {
                if (xmlExport.isAddIfNotFound()) {
                    PersistableBusinessObject newObject = this.createNewItem(change, xmlExport);
                    Method setter = this.getPropertyDescriptor(object, attrName).getWriteMethod();
                    setter.invoke((Object)object, newObject);
                }
            } else {
                this.setValuesOnSyncable((PersistableBusinessObject)propertyValue, xmlExport.getValues(), change);
            }
        } else if (propertyValue != null && this.getAwardSyncUtilityService().doKeyValuesMatch((PersistableBusinessObject)propertyValue, xmlExport.getKeys())) {
            Method setter = this.getPropertyDescriptor(object, attrName).getWriteMethod();
            setter.invoke((Object)object, (Object[])null);
        }
    }

    protected void applySyncChange(PersistableBusinessObject object, AwardSyncChange change, String attrName, Collection<AwardSyncXmlExport> xmlExports) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        ArrayList<PersistableBusinessObject> newCollection = new ArrayList<PersistableBusinessObject>();
        for (AwardSyncXmlExport xmlExport : xmlExports) {
            if (!xmlExport.isAddIfNotFound()) continue;
            PersistableBusinessObject newObject = this.createNewItem(change, xmlExport);
            newCollection.add(newObject);
        }
        Method setter = this.getPropertyDescriptor(object, attrName).getWriteMethod();
        setter.invoke((Object)object, newCollection);
    }

    protected PersistableBusinessObject createNewItem(AwardSyncChange change, AwardSyncXmlExport xmlExport) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        String className = xmlExport.getClassName();
        Map<String, Object> keyValues = xmlExport.getKeys();
        Map<String, Object> values = xmlExport.getValues();
        Class<?> subClazz = Class.forName(className);
        Constructor<?> constructor = subClazz.getConstructor(null);
        PersistableBusinessObject newObject = (PersistableBusinessObject)constructor.newInstance(null);
        this.setValuesOnSyncable(newObject, keyValues, change);
        this.setValuesOnSyncable(newObject, values, change);
        return newObject;
    }

    protected void setValuesOnSyncable(PersistableBusinessObject syncable, Map<String, Object> values, AwardSyncChange change) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, InstantiationException {
        Class<?> clazz = syncable.getClass();
        boolean setEntry = false;
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            setEntry = false;
            for (PropertyDescriptor propDescriptor : PropertyUtils.getPropertyDescriptors(clazz)) {
                if (!StringUtils.equals((CharSequence)propDescriptor.getName(), (CharSequence)entry.getKey())) continue;
                if (entry.getValue() instanceof AwardSyncXmlExport) {
                    AwardSyncXmlExport xmlExport = (AwardSyncXmlExport)entry.getValue();
                    this.applySyncChange(syncable, change, entry.getKey(), xmlExport);
                    setEntry = true;
                    continue;
                }
                if (Collection.class.isAssignableFrom(propDescriptor.getPropertyType()) && entry.getValue() instanceof List) {
                    this.applySyncChange(syncable, change, entry.getKey(), (Collection)entry.getValue());
                    setEntry = true;
                    continue;
                }
                Method setter = propDescriptor.getWriteMethod();
                setter.invoke((Object)syncable, entry.getValue());
                setEntry = true;
            }
            if (setEntry) continue;
            throw new NoSuchFieldException();
        }
    }

    protected PropertyDescriptor getPropertyDescriptor(PersistableBusinessObject object, String attributeName) {
        Class<?> clazz = object.getClass();
        for (PropertyDescriptor propDescriptor : PropertyUtils.getPropertyDescriptors(clazz)) {
            if (!StringUtils.equals((CharSequence)propDescriptor.getName(), (CharSequence)attributeName)) continue;
            return propDescriptor;
        }
        return null;
    }

    protected Object getPropertyValue(PersistableBusinessObject object, String attributeName) throws IllegalAccessException, InvocationTargetException {
        for (PropertyDescriptor propDesc : PropertyUtils.getPropertyDescriptors(object.getClass())) {
            if (!StringUtils.equals((CharSequence)propDesc.getName(), (CharSequence)attributeName)) continue;
            Method getter = propDesc.getReadMethod();
            return getter.invoke((Object)object, new Object[0]);
        }
        return null;
    }

    public AwardSyncUtilityService getAwardSyncUtilityService() {
        return this.awardSyncUtilityService;
    }

    public void setAwardSyncUtilityService(AwardSyncUtilityService awardSyncUtilityService) {
        this.awardSyncUtilityService = awardSyncUtilityService;
    }
}

