/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.xmlstream;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.print.stream.xml.XmlStream;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.sponsor.term.SponsorTerm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.home.AwardBasisOfPayment;
import org.kuali.kra.award.home.AwardMethodOfPayment;
import org.kuali.kra.award.home.AwardStatus;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.home.AwardTemplateComment;
import org.kuali.kra.award.home.AwardTemplateContact;
import org.kuali.kra.award.home.AwardTemplateReportTerm;
import org.kuali.kra.award.home.AwardTemplateReportTermRecipient;
import org.kuali.kra.award.home.AwardTemplateTerm;
import org.kuali.kra.award.home.Distribution;
import org.kuali.kra.award.paymentreports.Frequency;
import org.kuali.kra.award.paymentreports.FrequencyBase;
import org.kuali.kra.award.paymentreports.Report;
import org.kuali.kra.award.paymentreports.ReportClass;
import org.kuali.kra.award.printing.AwardPrintType;
import org.kuali.kra.printing.schema.BasisPaymentType;
import org.kuali.kra.printing.schema.CommentType;
import org.kuali.kra.printing.schema.CompetingRenewalType;
import org.kuali.kra.printing.schema.ContactType;
import org.kuali.kra.printing.schema.NonCompetingContType;
import org.kuali.kra.printing.schema.PaymentMethodType;
import org.kuali.kra.printing.schema.ReportTermDetailsType;
import org.kuali.kra.printing.schema.ReportTermType;
import org.kuali.kra.printing.schema.RolodexDetailsType;
import org.kuali.kra.printing.schema.SchoolInfoType;
import org.kuali.kra.printing.schema.SponsorType;
import org.kuali.kra.printing.schema.TemplateDocument;
import org.kuali.kra.printing.schema.TemplateMasterData;
import org.kuali.kra.printing.schema.TemplateStatusType;
import org.kuali.kra.printing.schema.TermDetailsType;
import org.kuali.kra.printing.schema.TermType;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class AwardTemplateXmlStream
implements XmlStream<TemplateDocument> {
    private DateTimeService dateTimeService = null;
    private ParameterService parameterService;
    private static final String SCHOOL_NAME = "SCHOOL_NAME";
    private static final String SCHOOL_ACRONYM = "SCHOOL_ACRONYM";
    private String previousDescription = "";

    @Override
    public Class<TemplateDocument> type() {
        return TemplateDocument.class;
    }

    @Override
    public Map<String, TemplateDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        HashMap<String, TemplateDocument> awardTemplateXmlStream = new HashMap<String, TemplateDocument>();
        AwardTemplate awardTemplate = (AwardTemplate)printableBusinessObject;
        TemplateDocument templateDocument = TemplateDocument.Factory.newInstance();
        if (awardTemplate != null) {
            templateDocument.setTemplate(this.getTemplate(awardTemplate));
        }
        awardTemplateXmlStream.put(AwardPrintType.AWARD_TEMPLATE.getAwardPrintType(), templateDocument);
        return awardTemplateXmlStream;
    }

    private TemplateDocument.Template getTemplate(AwardTemplate awardTemplate) {
        TemplateDocument.Template template = TemplateDocument.Template.Factory.newInstance();
        awardTemplate.refreshNonUpdateableReferences();
        template.setTemplateMaster(this.getTemplateMaster(awardTemplate));
        template.setSchoolInfo(this.getSchoolInfoType());
        template.setCommentArray(this.getCommentType(awardTemplate));
        template.setContactArray(this.getContactType(awardTemplate));
        template.setTermArray(this.getTerms(awardTemplate));
        template.setReportArray(this.getReportTermTypes(awardTemplate));
        return template;
    }

    private TemplateMasterData getTemplateMaster(AwardTemplate awardTemplate) {
        TemplateMasterData templateMasterData = TemplateMasterData.Factory.newInstance();
        templateMasterData.setCurrentDate(this.getDateTimeService().getCurrentCalendar());
        templateMasterData.setDescription(awardTemplate.getDescription());
        templateMasterData.setTemplateCode(awardTemplate.getTemplateCode());
        if (awardTemplate.getBasisOfPaymentCode() != null) {
            BasisPaymentType basisPayment = templateMasterData.addNewBasisPayment();
            AwardBasisOfPayment awardBasisOfPayment = awardTemplate.getAwardBasisOfPayment();
            if (awardBasisOfPayment != null) {
                basisPayment.setBasisPaymentCode(awardBasisOfPayment.getBasisOfPaymentCode());
                basisPayment.setBasisPaymentDesc(awardBasisOfPayment.getDescription());
            }
        }
        if (awardTemplate.getCompetingRenewalPrpslDueCode() != null) {
            CompetingRenewalType competingRenewal = templateMasterData.addNewCompetingRenewal();
            competingRenewal.setCompetingRenewalCode(awardTemplate.getCompetingRenewalPrpslDueCode());
        }
        if (awardTemplate.getNonCompetingContPrpslDueCode() != null) {
            NonCompetingContType nonCompetingCont = templateMasterData.addNewNonCompetingCont();
            nonCompetingCont.setNonCompetingContCode(awardTemplate.getNonCompetingContPrpslDueCode());
        }
        if (awardTemplate.getMethodOfPaymentCode() != null) {
            AwardMethodOfPayment awardMethodOfPayment = awardTemplate.getAwardMethodOfPayment();
            PaymentMethodType paymentMethod = templateMasterData.addNewPaymentMethod();
            paymentMethod.setPaymentMethodCode(awardMethodOfPayment.getMethodOfPaymentCode());
            paymentMethod.setPaymentMethodDesc(awardMethodOfPayment.getDescription());
        }
        if (awardTemplate.getPrimeSponsorCode() != null) {
            SponsorType sponsorType = templateMasterData.addNewPrimeSponsor();
            Sponsor sponsor = awardTemplate.getPrimeSponsor();
            sponsorType.setSponsorCode(sponsor.getSponsorCode());
            sponsorType.setSponsorName(sponsor.getSponsorName());
        }
        if (awardTemplate.getStatusCode() != null) {
            TemplateStatusType templateStatus = templateMasterData.addNewTemplateStatus();
            AwardStatus awardTemplateStatus = awardTemplate.getAwardTemplateStatus();
            templateStatus.setStatusCode(Integer.parseInt(awardTemplateStatus.getStatusCode()));
            templateStatus.setStatusDesc(awardTemplateStatus.getDescription());
        }
        return templateMasterData;
    }

    private TermType[] getTerms(AwardTemplate awardTemplate) {
        ArrayList<TermType> termTypes = new ArrayList<TermType>();
        for (AwardTemplateTerm awardTemplateTerm : awardTemplate.getAwardSponsorTerms()) {
            TermType termType = TermType.Factory.newInstance();
            this.setTermDetails(termType, awardTemplateTerm);
            termTypes.add(termType);
        }
        return termTypes.toArray(new TermType[0]);
    }

    private void setTermDetails(TermType termType, AwardTemplateTerm awardTemplateTerm) {
        awardTemplateTerm.refreshNonUpdateableReferences();
        SponsorTerm sponsorTerm = awardTemplateTerm.getSponsorTerm();
        if (sponsorTerm != null) {
            if (this.previousDescription.equals("") || !this.previousDescription.equals(awardTemplateTerm.getSponsorTerm().getSponsorTermType().getDescription())) {
                termType.setDescription(awardTemplateTerm.getSponsorTerm().getSponsorTermType().getDescription());
                this.previousDescription = awardTemplateTerm.getSponsorTerm().getSponsorTermType().getDescription();
            }
            TermDetailsType termDetails = termType.addNewTermDetails();
            termDetails.setTermCode(Integer.parseInt(sponsorTerm.getSponsorTermCode()));
            termDetails.setTermDescription(sponsorTerm.getDescription());
        }
    }

    private ReportTermType[] getReportTermTypes(AwardTemplate awardTemplate) {
        ArrayList<ReportTermType> reportTermTypes = new ArrayList<ReportTermType>();
        for (AwardTemplateReportTerm awardTemplateReportTerm : awardTemplate.getTemplateReportTerms()) {
            ReportTermType reportTermType = ReportTermType.Factory.newInstance();
            awardTemplateReportTerm.refreshNonUpdateableReferences();
            ReportClass reportClass = awardTemplateReportTerm.getReportClass();
            if (reportClass != null && reportClass.getDescription() != null) {
                reportTermType.setDescription(reportClass.getDescription());
            }
            reportTermType.setReportTermDetailsArray(this.getReportTermDetails(awardTemplateReportTerm));
            reportTermTypes.add(reportTermType);
        }
        return reportTermTypes.toArray(new ReportTermType[0]);
    }

    private ReportTermDetailsType[] getReportTermDetails(AwardTemplateReportTerm awardTemplateReportTerm) {
        ArrayList<ReportTermDetailsType> reportTermDetailsTypes = new ArrayList<ReportTermDetailsType>();
        ReportTermDetailsType reportTermDetailsType = ReportTermDetailsType.Factory.newInstance();
        Date dueDate = awardTemplateReportTerm.getDueDate();
        if (dueDate != null) {
            reportTermDetailsType.setDueDate(this.dateTimeService.getCalendar((java.util.Date)dueDate));
        }
        this.setFrequencyBaseDetails(awardTemplateReportTerm, reportTermDetailsType);
        this.setFrequencyDetails(awardTemplateReportTerm, reportTermDetailsType);
        this.setOspDistributionDetails(awardTemplateReportTerm, reportTermDetailsType);
        this.setReportClassDetails(awardTemplateReportTerm, reportTermDetailsType);
        this.setReportDetails(awardTemplateReportTerm, reportTermDetailsType);
        reportTermDetailsType.setMailCopiesArray(this.getMailCopies(awardTemplateReportTerm));
        reportTermDetailsTypes.add(reportTermDetailsType);
        return reportTermDetailsTypes.toArray(new ReportTermDetailsType[0]);
    }

    private void setReportDetails(AwardTemplateReportTerm awardTemplateReportTerm, ReportTermDetailsType reportTermDetailsType) {
        Report report = awardTemplateReportTerm.getReport();
        String reportCode = report.getReportCode();
        String reportDescription = report.getDescription();
        if (reportCode != null) {
            reportTermDetailsType.setReportCode(Integer.valueOf(reportCode));
        }
        if (reportDescription != null) {
            reportTermDetailsType.setReportCodeDesc(reportDescription);
        }
    }

    private void setReportClassDetails(AwardTemplateReportTerm awardTemplateReportTerm, ReportTermDetailsType reportTermDetailsType) {
        ReportClass reportClass = awardTemplateReportTerm.getReportClass();
        String reportClassCode = reportClass.getReportClassCode();
        String reportClassDescription = reportClass.getDescription();
        if (reportClassCode != null) {
            reportTermDetailsType.setReportClassCode(Integer.valueOf(reportClassCode));
        }
        if (reportClassDescription != null) {
            reportTermDetailsType.setReportCodeDesc(reportClassDescription);
        }
    }

    private void setOspDistributionDetails(AwardTemplateReportTerm awardTemplateReportTerm, ReportTermDetailsType reportTermDetailsType) {
        Distribution distribution;
        String ospDescription;
        String ospDistributionCode = awardTemplateReportTerm.getOspDistributionCode();
        if (ospDistributionCode != null) {
            reportTermDetailsType.setOSPDistributionCode(Integer.valueOf(ospDistributionCode));
        }
        if ((ospDescription = (distribution = awardTemplateReportTerm.getDistribution()).getDescription()) != null) {
            reportTermDetailsType.setOSPDistributionDesc(ospDescription);
        }
    }

    private void setFrequencyDetails(AwardTemplateReportTerm awardTemplateReportTerm, ReportTermDetailsType reportTermDetailsType) {
        Frequency frequency = awardTemplateReportTerm.getFrequency();
        String frequencyCode = frequency.getFrequencyCode();
        String desription = frequency.getDescription();
        if (frequencyCode != null) {
            reportTermDetailsType.setFrequencyCode(Integer.valueOf(frequencyCode));
        }
        if (desription != null) {
            reportTermDetailsType.setFrequencyCodeDesc(desription);
        }
    }

    private void setFrequencyBaseDetails(AwardTemplateReportTerm awardTemplateReportTerm, ReportTermDetailsType reportTermDetailsType) {
        String description;
        String frequencyBaseCode = awardTemplateReportTerm.getFrequencyBaseCode();
        if (frequencyBaseCode != null) {
            reportTermDetailsType.setFrequencyBaseCode(Integer.valueOf(frequencyBaseCode));
        }
        awardTemplateReportTerm.refreshNonUpdateableReferences();
        FrequencyBase frequencyBase = awardTemplateReportTerm.getFrequencyBase();
        if (frequencyBase != null && (description = frequencyBase.getDescription()) != null) {
            reportTermDetailsType.setFrequencyBaseDesc(description);
        }
    }

    private ReportTermDetailsType.MailCopies[] getMailCopies(AwardTemplateReportTerm awardTemplateReportTerm) {
        ArrayList<ReportTermDetailsType.MailCopies> mailCopiesList = new ArrayList<ReportTermDetailsType.MailCopies>();
        for (AwardTemplateReportTermRecipient awardTemplateReportTermRecipient : awardTemplateReportTerm.getAwardTemplateReportTermRecipients()) {
            Integer rolodexid;
            Integer numberofmailCopies;
            ReportTermDetailsType.MailCopies mailCopies = ReportTermDetailsType.MailCopies.Factory.newInstance();
            awardTemplateReportTermRecipient.refreshNonUpdateableReferences();
            org.kuali.kra.award.home.ContactType contactType = awardTemplateReportTermRecipient.getContactType();
            if (contactType != null) {
                String contactTypeCode = contactType.getContactTypeCode();
                String contactTypeDescription = contactType.getDescription();
                if (contactTypeCode != null) {
                    mailCopies.setContactTypeCode(Integer.valueOf(contactTypeCode));
                }
                if (contactTypeDescription != null) {
                    mailCopies.setContactTypeDesc(contactTypeDescription);
                }
            }
            if ((numberofmailCopies = awardTemplateReportTermRecipient.getNumberOfCopies()) != null) {
                mailCopies.setNumberOfCopies(String.valueOf(numberofmailCopies));
            }
            if ((rolodexid = awardTemplateReportTermRecipient.getRolodexId()) != null) {
                mailCopies.setRolodexId(String.valueOf(rolodexid));
            }
            mailCopiesList.add(mailCopies);
        }
        return mailCopiesList.toArray(new ReportTermDetailsType.MailCopies[0]);
    }

    private ContactType[] getContactType(AwardTemplate awardTemplate) {
        ArrayList<ContactType> contactTypes = new ArrayList<ContactType>();
        for (AwardTemplateContact awardTemplateContact : awardTemplate.getTemplateContacts()) {
            ContactType contactType = ContactType.Factory.newInstance();
            awardTemplateContact.refreshNonUpdateableReferences();
            org.kuali.kra.award.home.ContactType type = awardTemplateContact.getContactType();
            String contactTypeCode = null;
            String description = null;
            if (type != null) {
                contactTypeCode = type.getContactTypeCode();
                description = type.getDescription();
            }
            if (contactTypeCode != null) {
                contactType.setContactTypeCode(Integer.valueOf(contactTypeCode));
            }
            if (description != null) {
                contactType.setContactTypeDesc(description);
            }
            this.setRolodexDetails(contactType, awardTemplateContact);
            contactTypes.add(contactType);
        }
        return contactTypes.toArray(new ContactType[0]);
    }

    private void setRolodexDetails(ContactType contactType, AwardTemplateContact awardTemplateContact) {
        Rolodex rolodex;
        if (awardTemplateContact.getRolodexId() != null && (rolodex = awardTemplateContact.getRolodex()) != null) {
            RolodexDetailsType rolodexDetails = contactType.addNewRolodexDetails();
            rolodexDetails.setAddress1(rolodex.getAddressLine1());
            rolodexDetails.setAddress2(rolodex.getAddressLine2());
            rolodexDetails.setAddress3(rolodex.getAddressLine3());
            rolodexDetails.setCity(rolodex.getCity());
            rolodexDetails.setComments(rolodex.getComments());
            rolodexDetails.setCountryCode(rolodex.getCountryCode());
            rolodexDetails.setCountryDescription(rolodex.getCountryCode());
            rolodexDetails.setCounty(rolodex.getCounty());
            rolodexDetails.setEmail(rolodex.getEmailAddress());
            rolodexDetails.setFax(rolodex.getFaxNumber());
            rolodexDetails.setFirstName(rolodex.getFirstName());
            rolodexDetails.setLastName(rolodex.getLastName());
            rolodexDetails.setMiddleName(rolodex.getMiddleName());
            rolodexDetails.setOrganization(rolodex.getOrganization());
            rolodexDetails.setOwnedByUnit(rolodex.getOwnedByUnit());
            if (rolodex.getUnit() != null) {
                rolodexDetails.setOwnedByUnitName(rolodex.getUnit().getUnitName());
            }
            rolodexDetails.setPhoneNumber(rolodex.getPhoneNumber());
            rolodexDetails.setPostalCode(rolodex.getPostalCode());
            rolodexDetails.setPrefix(rolodex.getPrefix());
            rolodexDetails.setRolodexId(rolodex.getRolodexId().toString());
            rolodexDetails.setSponsorCode(rolodex.getSponsorCode());
            if (rolodex.getSponsor() != null) {
                rolodexDetails.setSponsorName(rolodex.getSponsor().getSponsorName());
            }
            rolodexDetails.setStateCode(rolodex.getState());
            rolodexDetails.setStateDescription(rolodex.getSponsorCode());
            rolodexDetails.setSuffix(rolodex.getSuffix());
            rolodexDetails.setTitle(rolodex.getTitle());
        }
    }

    private CommentType[] getCommentType(AwardTemplate awardTemplate) {
        ArrayList<CommentType> commentTypes = new ArrayList<CommentType>();
        List<AwardTemplateComment> templateComments = awardTemplate.getTemplateComments();
        CommentType commentType = null;
        ArrayList<String> templateCommentList = new ArrayList<String>();
        HashMap<String, String> templateCommentHm = new HashMap<String, String>();
        for (AwardTemplateComment awardTemplateComment : templateComments) {
            String comments;
            AwardTemplate template = awardTemplateComment.getTemplate();
            String description = null;
            if (template != null) {
                awardTemplateComment.refreshReferenceObject("commentType");
                description = awardTemplateComment.getCommentType().getDescription();
                templateCommentList.add(description);
            }
            if ((comments = awardTemplateComment.getComments()) == null || description == null) continue;
            templateCommentHm.put(description, comments);
        }
        Collections.sort(templateCommentList);
        for (String aTemplateCommentList : templateCommentList) {
            if (templateCommentHm.containsKey(aTemplateCommentList)) {
                commentType = CommentType.Factory.newInstance();
                String comments = (String)templateCommentHm.get(aTemplateCommentList);
                commentType.setDescription(aTemplateCommentList);
                commentType.setComments(comments);
            }
            commentTypes.add(commentType);
        }
        return commentTypes.toArray(new CommentType[0]);
    }

    private SchoolInfoType getSchoolInfoType() {
        SchoolInfoType schoolInfoType = SchoolInfoType.Factory.newInstance();
        String schoolName = this.getAwardParameterValue(SCHOOL_NAME);
        String schoolAcronym = this.getAwardParameterValue(SCHOOL_ACRONYM);
        if (schoolName != null) {
            schoolInfoType.setSchoolName(schoolName);
        }
        if (schoolAcronym != null) {
            schoolInfoType.setAcronym(schoolAcronym);
        }
        return schoolInfoType;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    private String getAwardParameterValue(String param) {
        return this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, param);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

