/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.api.bus.support;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.ksb.api.bus.support.AbstractServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.SoapServiceDefinition;

@XmlRootElement(name="soapServiceConfiguration")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="SoapServiceConfigurationType", propOrder={"serviceInterface", "jaxWsService"})
public class SoapServiceConfiguration
extends AbstractServiceConfiguration {
    private static final long serialVersionUID = -4226512121638441108L;
    @XmlElement(name="serviceInterface", required=true)
    private final String serviceInterface;
    @XmlElement(name="jaxWsService", required=true)
    private final boolean jaxWsService;

    private SoapServiceConfiguration() {
        this.serviceInterface = null;
        this.jaxWsService = false;
    }

    private SoapServiceConfiguration(Builder builder) {
        super(builder);
        this.serviceInterface = builder.getServiceInterface();
        this.jaxWsService = builder.isJaxWsService();
    }

    public static SoapServiceConfiguration fromServiceDefinition(SoapServiceDefinition soapServiceDefinition) {
        return Builder.create(soapServiceDefinition).build();
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public boolean isJaxWsService() {
        return this.jaxWsService;
    }

    static class Elements {
        protected static final String SERVICE_INTERFACE = "serviceInterface";
        protected static final String JAX_WS_SERVICE = "jaxWsService";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "soapServiceConfiguration";
        static final String TYPE_NAME = "SoapServiceConfigurationType";

        Constants() {
        }
    }

    public static final class Builder
    extends AbstractServiceConfiguration.Builder<SoapServiceConfiguration> {
        private static final long serialVersionUID = 722267174667364588L;
        private String serviceInterface;
        private boolean jaxWsService = false;

        public String getServiceInterface() {
            return this.serviceInterface;
        }

        public void setServiceInterface(String serviceInterface) {
            this.serviceInterface = serviceInterface;
        }

        public boolean isJaxWsService() {
            return this.jaxWsService;
        }

        public void setJaxWsService(boolean jaxWsService) {
            this.jaxWsService = jaxWsService;
        }

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(SoapServiceDefinition soapServiceDefinition) {
            Builder builder = Builder.create();
            builder.copyServiceDefinitionProperties(soapServiceDefinition);
            builder.setServiceInterface(soapServiceDefinition.getServiceInterface());
            builder.setJaxWsService(soapServiceDefinition.isJaxWsService());
            return builder;
        }

        @Override
        public SoapServiceConfiguration build() {
            return new SoapServiceConfiguration(this);
        }
    }
}

