/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.rice.kew.notes.service.impl;

import co.kuali.rice.coreservice.api.attachment.S3FileService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.service.impl.AttachmentServiceImpl;

public class S3AttachmentServiceImpl
extends AttachmentServiceImpl {
    private S3FileService riceS3FileService;
    private ParameterService parameterService;

    @Override
    public void persistAttachedFileAndSetAttachmentBusinessObjectValue(Attachment attachment) throws Exception {
        if (!this.isS3IntegrationEnabled()) {
            super.persistAttachedFileAndSetAttachmentBusinessObjectValue(attachment);
        }
        try {
            Class<?> s3FileClass = Class.forName("co.kuali.coeus.s3.api.S3File");
            Object s3File = s3FileClass.newInstance();
            Method setFileContents = s3FileClass.getMethod("setByteContents", byte[].class);
            setFileContents.invoke(s3File, new Object[]{IOUtils.toByteArray((InputStream)attachment.getAttachedObject())});
            attachment.setFileDataId(this.riceS3FileService.createFile(s3File));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (this.isS3DualSaveEnabled()) {
            super.persistAttachedFileAndSetAttachmentBusinessObjectValue(attachment);
        }
    }

    @Override
    public byte[] findAttachedFile(Attachment attachment) throws Exception {
        if (!this.isS3IntegrationEnabled()) {
            return super.findAttachedFile(attachment);
        }
        try {
            String dbMD5;
            String s3MD5;
            Object s3File = this.riceS3FileService.retrieveFile(attachment.getFileDataId());
            byte[] s3Bytes = null;
            byte[] fsBytes = null;
            if (s3File != null) {
                if (this.LOG.isDebugEnabled()) {
                    Method getFileMetaData = s3File.getClass().getMethod("getFileMetaData", new Class[0]);
                    this.LOG.debug("data found in S3, existing id: " + attachment.getFileDataId() + " metadata: " + getFileMetaData.invoke(s3File, new Object[0]));
                }
                Method getFileContents = s3File.getClass().getMethod("getByteContents", new Class[0]);
                s3Bytes = (byte[])getFileContents.invoke(s3File, new Object[0]);
            }
            if (s3Bytes == null || this.isS3DualRetrieveEnabled()) {
                try {
                    fsBytes = super.findAttachedFile(attachment);
                }
                catch (FileNotFoundException e) {
                    this.LOG.info("file not found at path " + attachment.getFileLoc());
                }
            }
            if (s3Bytes != null && fsBytes != null && !Objects.equals(s3MD5 = DigestUtils.md5Hex((byte[])s3Bytes), dbMD5 = DigestUtils.md5Hex((byte[])fsBytes))) {
                this.LOG.error("S3 data MD5: " + s3MD5 + " does not equal FS data MD5: " + dbMD5 + " for id: " + attachment.getFileDataId());
            }
            return s3Bytes != null ? s3Bytes : fsBytes;
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteAttachedFile(Attachment attachment) throws Exception {
        if (!this.isS3IntegrationEnabled()) {
            super.deleteAttachedFile(attachment);
        }
        this.riceS3FileService.deleteFile(attachment.getFileDataId());
        if (this.isS3DualSaveEnabled()) {
            try {
                super.deleteAttachedFile(attachment);
            }
            catch (FileNotFoundException e) {
                this.LOG.info("file not found at path " + attachment.getFileLoc());
            }
        }
    }

    protected boolean isS3IntegrationEnabled() {
        if (this.parameterService.parameterExists("KR-SYS", "All", "S3_INTEGRATION_ENABLED").booleanValue()) {
            return this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", "S3_INTEGRATION_ENABLED");
        }
        return false;
    }

    protected boolean isS3DualSaveEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", "S3_DUAL_SAVE_ENABLED");
    }

    protected boolean isS3DualRetrieveEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", "S3_DUAL_RETRIEVE_ENABLED");
    }

    public S3FileService getRiceS3FileService() {
        return this.riceS3FileService;
    }

    public void setRiceS3FileService(S3FileService riceS3FileService) {
        this.riceS3FileService = riceS3FileService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

