/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.element.StepProgressBar;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTags(value={@BeanTag(name="progressBar-bean", parent="Uif-ProgressBar"), @BeanTag(name="progressBarVertical-bean", parent="Uif-ProgressBar-Vertical")})
public class ProgressBar
extends ContentElementBase {
    private static final long serialVersionUID = -2643777398164666573L;
    private Integer percentComplete;
    private List<Integer> segmentPercentages;
    private List<String> segmentSizes = new ArrayList<String>();
    private List<String> segmentClasses = new ArrayList<String>();
    private boolean vertical;

    public ProgressBar() {
        this.setRole("progressbar");
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        boolean explicitlySetSizes;
        super.performFinalize(model, parent);
        String cssDimension = "width: ";
        if (this.vertical) {
            cssDimension = "height: ";
        }
        boolean bl = explicitlySetSizes = this.segmentPercentages != null && !this.getSegmentPercentages().isEmpty();
        if (!explicitlySetSizes && this.percentComplete != null) {
            this.segmentClasses = new ArrayList<String>();
            this.segmentSizes.add(cssDimension + this.percentComplete + "%");
            this.segmentClasses.add("progress-bar progress-bar-success");
            this.setTitle(this.percentComplete.toString() + "%");
            this.addAriaAttribute("valuemin", "0");
            this.addAriaAttribute("valuemax", "100");
            this.addAriaAttribute("valuenow", this.percentComplete.toString());
        } else if (explicitlySetSizes && !(this instanceof StepProgressBar)) {
            if (this.segmentClasses == null || this.segmentClasses.size() != this.segmentPercentages.size()) {
                throw new RuntimeException("If segmentPercentages are set on a base ProgressBar type, segmentClasses must also be explicitly set and contain the same number of items");
            }
            this.percentComplete = 0;
            for (int index = 0; index < this.segmentPercentages.size(); ++index) {
                this.segmentSizes.add(cssDimension + this.segmentPercentages.get(index) + "%");
                this.percentComplete = this.percentComplete + this.segmentPercentages.get(index);
            }
            this.addAriaAttribute("valuemin", "0");
            this.addAriaAttribute("valuemax", "100");
            this.addAriaAttribute("valuenow", this.percentComplete.toString());
        }
    }

    @BeanTagAttribute(name="percentComplete")
    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    public void setPercentComplete(Integer percentComplete) {
        this.percentComplete = percentComplete;
    }

    @BeanTagAttribute(name="segmentClasses", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getSegmentClasses() {
        return this.segmentClasses;
    }

    public void setSegmentClasses(List<String> segmentClasses) {
        this.segmentClasses = segmentClasses;
    }

    @BeanTagAttribute(name="segmentPercentages", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<Integer> getSegmentPercentages() {
        return this.segmentPercentages;
    }

    public void setSegmentPercentages(List<String> segmentPercentages) {
        if (this.segmentPercentages == null) {
            this.segmentPercentages = new ArrayList<Integer>();
        }
        for (String percentage : segmentPercentages) {
            this.segmentPercentages.add(new Integer(percentage));
        }
    }

    public List<String> getSegmentSizes() {
        return this.segmentSizes;
    }

    @BeanTagAttribute(name="vertical")
    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }
}

