/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.file.FileMeta;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.DialogResponse;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.CollectionControllerService;
import org.kuali.rice.krad.web.service.FileControllerService;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

public class FileControllerServiceImpl
implements FileControllerService {
    protected static final String DELETE_FILE_UPLOAD_LINE_DIALOG = "DialogGroup-DeleteFileUploadLine";
    private CollectionControllerService collectionControllerService;
    private ModelAndViewService modelAndViewService;

    @Override
    public ModelAndView addFileUploadLine(final UifFormBase form) {
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        form.setAjaxRequest(true);
        MultipartHttpServletRequest request = (MultipartHttpServletRequest)form.getRequest();
        final String collectionId = request.getParameter("updateComponentId");
        final String bindingPath = request.getParameter("bindingPath");
        Class collectionObjectClass = (Class)form.getViewPostMetadata().getComponentPostData(collectionId, "collectionObjectClass");
        Iterator fileNamesItr = request.getFileNames();
        while (fileNamesItr.hasNext()) {
            String propertyPath = (String)fileNamesItr.next();
            MultipartFile uploadedFile = request.getFile(propertyPath);
            final FileMeta fileObject = (FileMeta)KRADUtils.createNewObjectFromClass(collectionObjectClass);
            try {
                fileObject.init(uploadedFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to initialize new file object", e);
            }
            String id = UUID.randomUUID().toString() + "_" + uploadedFile.getName();
            fileObject.setId(id);
            fileObject.setDateUploaded(new Date());
            fileObject.setUrl("?methodToCall=getFileFromLine&formKey=" + form.getFormKey() + "&fileName=" + fileObject.getName() + "&propertyPath=" + propertyPath);
            ViewLifecycle.encapsulateLifecycle(form.getView(), form, form.getViewPostMetadata(), null, (HttpServletRequest)request, new Runnable(){

                @Override
                public void run() {
                    ViewLifecycle.getHelper().processAndAddLineObject(form, fileObject, collectionId, bindingPath);
                }
            });
        }
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView deleteFileUploadLine(UifFormBase form) {
        DialogResponse deleteFileUploadLineDialogResponse = form.getDialogResponse(DELETE_FILE_UPLOAD_LINE_DIALOG);
        if (deleteFileUploadLineDialogResponse == null) {
            return this.getModelAndViewService().showDialog(DELETE_FILE_UPLOAD_LINE_DIALOG, true, form);
        }
        return this.getCollectionControllerService().deleteLine(form);
    }

    @Override
    public void getFileFromLine(UifFormBase form, HttpServletResponse response) {
        HttpServletRequest request = form.getRequest();
        String selectedCollectionPath = request.getParameter("propertyPath");
        if (StringUtils.isBlank((String)selectedCollectionPath)) {
            throw new RuntimeException("Selected collection was not set for delete line action, cannot delete line");
        }
        String selectedLine = request.getParameter("selectedLineIndex");
        int selectedLineIndex = StringUtils.isNotBlank((String)selectedLine) ? Integer.parseInt(selectedLine) : -1;
        if (selectedLineIndex == -1) {
            throw new RuntimeException("Selected line index was not set for delete line action, cannot delete line");
        }
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue(form, selectedCollectionPath);
        if (collection instanceof List) {
            FileMeta fileLine = (FileMeta)((List)collection).get(selectedLineIndex);
            this.sendFileFromLineResponse(form, response, (List)collection, fileLine);
        }
    }

    protected void sendFileFromLineResponse(UifFormBase form, HttpServletResponse response, List<FileMeta> collection, FileMeta fileLine) {
    }

    protected CollectionControllerService getCollectionControllerService() {
        return this.collectionControllerService;
    }

    public void setCollectionControllerService(CollectionControllerService collectionControllerService) {
        this.collectionControllerService = collectionControllerService;
    }

    protected ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }
}

