/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministratorDerivedRoleTypeService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalAllUnitAdministratorDerivedRoleTypeService")
public class ProposalAllUnitAdministratorDerivedRoleTypeServiceImpl
extends AbstractUnitAdministratorDerivedRoleTypeService
implements RoleTypeService {
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    protected UnitService getUnitService() {
        return this.unitService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    @Override
    public List<? extends AbstractUnitAdministrator> getUnitAdministrators(Map<String, String> qualifiers) {
        String proposalNumber = qualifiers.get("proposal");
        String unitNumber = qualifiers.get("unitNumber");
        ArrayList<UnitAdministrator> result = new ArrayList<UnitAdministrator>();
        if (proposalNumber != null) {
            DevelopmentProposal proposal = (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)proposalNumber);
            Set<String> units = this.getApplicableUnits(proposal);
            for (String unit : units) {
                if (!StringUtils.isNotBlank((CharSequence)unit)) continue;
                result.addAll(this.unitService.retrieveUnitAdministratorsByUnitNumber(unit));
            }
        } else if (unitNumber != null) {
            result.addAll(this.unitService.retrieveUnitAdministratorsByUnitNumber(this.getUnitNumberForPersonUnit(this.unitService.getUnit(unitNumber))));
        }
        return result;
    }

    public Set<String> getApplicableUnits(DevelopmentProposal proposal) {
        return proposal.getProposalPersons().stream().flatMap(person -> person.getUnits().stream()).map(unit -> this.getUnitNumberForPersonUnit(unit.getUnit())).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected String getUnitNumberForPersonUnit(Unit unit) {
        return unit.getUnitNumber();
    }
}

