/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person.masschange;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.kuali.coeus.common.framework.person.editable.PersonEditableService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.propdev.impl.person.masschange.ProposalDevelopmentPersonMassChangeService;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.kra.personmasschange.service.impl.MassPersonChangeServiceBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalDevelopmentPersonMassChangeService")
public class ProposalDevelopmentPersonMassChangeServiceImpl
extends MassPersonChangeServiceBase
implements ProposalDevelopmentPersonMassChangeService {
    private static final String DEVELOPMENT_PROPOSAL = "development proposal";
    private static final String DEVPROP_WARNINGS = "devPropWarnings";
    @Autowired
    @Qualifier(value="personEditableService")
    private PersonEditableService personEditableService;

    @Override
    public List<DevelopmentProposal> getProposalDevelopmentChangeCandidates(PersonMassChange personMassChange) {
        ArrayList<DevelopmentProposal> proposalDevelopmentChangeCandidates = new ArrayList<DevelopmentProposal>();
        ArrayList<DevelopmentProposal> developmentProposals = new ArrayList<DevelopmentProposal>();
        if (personMassChange.getProposalDevelopmentPersonMassChange().requiresChange()) {
            developmentProposals.addAll(this.getDevelopmentProposals());
        }
        for (DevelopmentProposal developmentProposal : developmentProposals) {
            if (!this.isProposalDevelopmentChangeCandidate(personMassChange, developmentProposal)) continue;
            proposalDevelopmentChangeCandidates.add(developmentProposal);
        }
        for (DevelopmentProposal proposalDevelopmentChangeCandidate : proposalDevelopmentChangeCandidates) {
            if (proposalDevelopmentChangeCandidate.getProposalDocument().getPessimisticLocks().isEmpty()) continue;
            this.reportSoftError(proposalDevelopmentChangeCandidate);
        }
        return proposalDevelopmentChangeCandidates;
    }

    private List<DevelopmentProposal> getDevelopmentProposals() {
        return new ArrayList<DevelopmentProposal>(this.getDataObjectService().findAll(DevelopmentProposal.class).getResults());
    }

    private boolean isProposalDevelopmentChangeCandidate(PersonMassChange personMassChange, DevelopmentProposal developmentProposal) {
        boolean isProposalDevelopmentChangeCandidate = false;
        boolean hasErrors = false;
        List<ProposalPerson> persons = developmentProposal.getProposalPersons();
        Integer mailingInformationId = developmentProposal.getMailingAddressId();
        String[] investigatorRoles = new String[]{"PI", "COI"};
        String[] keyStudyPersonRoles = new String[]{"KP"};
        if (personMassChange.getProposalDevelopmentPersonMassChange().isInvestigator()) {
            isProposalDevelopmentChangeCandidate |= this.isPersonChangeCandidate(personMassChange, persons, investigatorRoles);
        }
        if (personMassChange.getProposalDevelopmentPersonMassChange().isKeyStudyPerson()) {
            isProposalDevelopmentChangeCandidate |= this.isPersonChangeCandidate(personMassChange, persons, keyStudyPersonRoles);
        }
        if (isProposalDevelopmentChangeCandidate) {
            hasErrors |= !this.isReplacerValidPersonChangeCandidate(personMassChange, persons);
        }
        if (personMassChange.getProposalDevelopmentPersonMassChange().isMailingInformation()) {
            isProposalDevelopmentChangeCandidate |= this.isMailingInformationChangeCandidate(personMassChange, mailingInformationId);
        }
        return isProposalDevelopmentChangeCandidate && !hasErrors;
    }

    private boolean isMailingInformationChangeCandidate(PersonMassChange personMassChange, Integer mailingInformationId) {
        return this.isRolodexIdMassChange(personMassChange, mailingInformationId);
    }

    @Override
    public void performPersonMassChange(PersonMassChange personMassChange, List<DevelopmentProposal> proposalDevelopmentChangeCandidates) {
        for (DevelopmentProposal proposalDevelopmentChangeCandidate : proposalDevelopmentChangeCandidates) {
            if (!proposalDevelopmentChangeCandidate.getProposalDocument().getPessimisticLocks().isEmpty()) continue;
            this.performProposalInvestigatorPersonMassChange(personMassChange, proposalDevelopmentChangeCandidate);
            this.performProposalMailingInfoPersonMassChange(personMassChange, proposalDevelopmentChangeCandidate);
        }
    }

    private void performProposalInvestigatorPersonMassChange(PersonMassChange personMassChange, DevelopmentProposal developmentProposal) {
        if (personMassChange.getProposalDevelopmentPersonMassChange().isInvestigator()) {
            String[] personRoles = new String[]{"PI", "COI"};
            this.performPersonPersonMassChange(personMassChange, developmentProposal, personRoles);
        }
    }

    private void performProposalMailingInfoPersonMassChange(PersonMassChange personMassChange, DevelopmentProposal developmentProposal) {
        if (personMassChange.getProposalDevelopmentPersonMassChange().isMailingInformation()) {
            developmentProposal.setMailingAddressId(personMassChange.getReplacerRolodexId());
            this.getBusinessObjectService().save((PersistableBusinessObject)developmentProposal);
        }
    }

    private void performPersonPersonMassChange(PersonMassChange personMassChange, DevelopmentProposal developmentProposal, String ... personRoles) {
        for (ProposalPerson person : developmentProposal.getProposalPersons()) {
            if (!this.isPersonInRole(person, personRoles) || !this.isPersonIdMassChange(personMassChange, person.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, person.getRolodexId())) continue;
            if (personMassChange.getReplacerPersonId() != null) {
                person.setPersonId(personMassChange.getReplacerPersonId());
                person.setRolodexId(null);
                this.getPersonEditableService().populateContactFieldsFromPersonId(person);
                for (ProposalPersonBiography biography : developmentProposal.getPropPersonBios()) {
                    if (!Objects.equals(biography.getProposalPersonNumber(), person.getProposalPersonNumber())) continue;
                    biography.setPersonId(personMassChange.getReplacerPersonId());
                    biography.setRolodexId(null);
                    this.getBusinessObjectService().save((PersistableBusinessObject)biography);
                }
            } else if (personMassChange.getReplacerRolodexId() != null) {
                person.setPersonId(null);
                person.setRolodexId(personMassChange.getReplacerRolodexId());
                this.getPersonEditableService().populateContactFieldsFromRolodexId(person);
                for (ProposalPersonBiography biography : developmentProposal.getPropPersonBios()) {
                    if (!Objects.equals(biography.getProposalPersonNumber(), person.getProposalPersonNumber())) continue;
                    biography.setPersonId(null);
                    biography.setRolodexId(personMassChange.getReplacerRolodexId());
                    this.getBusinessObjectService().save((PersistableBusinessObject)biography);
                }
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)person);
        }
    }

    private void reportSoftError(DevelopmentProposal developmentProposalChangeCandidate) {
        String proposalNumber = developmentProposalChangeCandidate.getProposalNumber();
        this.errorReporter.reportSoftError("personMassChangeDocumentLocked", "error.personMassChange.document.locked", DEVELOPMENT_PROPOSAL, proposalNumber);
    }

    public PersonEditableService getPersonEditableService() {
        return this.personEditableService;
    }

    public void setPersonEditableService(PersonEditableService personEditableService) {
        this.personEditableService = personEditableService;
    }

    @Override
    protected String getDocumentId(PersistableBusinessObject parent) {
        return ((DevelopmentProposal)parent).getProposalNumber();
    }

    @Override
    protected String getDocumentName() {
        return DEVELOPMENT_PROPOSAL;
    }

    @Override
    protected String getWarningKey() {
        return DEVPROP_WARNINGS;
    }
}

