/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteWorkgroup;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.TransactionalDocument;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.rules.TransactionalDocumentRuleBase;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.event.AddAdHocRoutePersonEvent;
import org.kuali.rice.krad.rules.rule.event.AddAdHocRouteWorkgroupEvent;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.RuleEvent;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class KualiRuleServiceImpl
implements KualiRuleService {
    private static final Logger LOG = LogManager.getLogger(KualiRuleServiceImpl.class);
    private DocumentDictionaryService documentDictionaryService;
    private DataDictionaryService dataDictionaryService;

    public boolean applyRules(DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("invalid (null) event");
        }
        event.validate();
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling applyRules for event " + event);
        }
        BusinessRule rule = this.getBusinessRulesInstance(event.getDocument(), event.getRuleInterfaceClass());
        boolean success = true;
        if (rule != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("processing " + event.getName() + " with rule " + rule.getClass().getName());
            }
            this.increaseErrorPath(event.getErrorPathPrefix());
            List events = event.generateEvents();
            for (RuleEvent generatedEvent : events) {
                success &= this.applyRules((DocumentEvent)generatedEvent);
            }
            success = StringUtils.isNotBlank((String)event.getRuleMethodName()) ? (success &= this.invokeBusinessRuleMethod(rule, event)) : (success &= event.invokeRuleMethod(rule));
            this.decreaseErrorPath(event.getErrorPathPrefix());
            if (!success) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(event.getName() + " businessRule " + rule.getClass().getName() + " failed");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("processed " + event.getName() + " for rule " + rule.getClass().getName());
            }
        }
        return success;
    }

    public boolean invokeBusinessRuleMethod(BusinessRule rule, DocumentEvent event) {
        boolean success = true;
        String methodName = event.getRuleMethodName();
        MethodInvokerConfig methodInvoker = new MethodInvokerConfig();
        methodInvoker.setTargetClass(rule.getClass());
        methodInvoker.setTargetMethod(methodName);
        Object[] arguments = new Object[]{event};
        methodInvoker.setArguments(arguments);
        try {
            LOG.debug("Invoking rule method: " + methodInvoker.getTargetMethod() + " for class: " + rule.getClass().getName());
            methodInvoker.prepare();
            Class<?> methodReturnType = methodInvoker.getPreparedMethod().getReturnType();
            if (StringUtils.equals((String)"void", (String)methodReturnType.getName())) {
                methodInvoker.invoke();
            } else {
                success &= ((Boolean)methodInvoker.invoke()).booleanValue();
            }
        }
        catch (Exception e) {
            LOG.error("Error invoking rule method for class: " + rule.getClass().getName(), (Throwable)e);
            throw new RuntimeException("Error invoking rule method for class: " + rule.getClass().getName(), e);
        }
        return success;
    }

    public List<AddAdHocRoutePersonEvent> generateAdHocRoutePersonEvents(Document document) {
        List adHocRoutePersons = document.getAdHocRoutePersons();
        ArrayList<AddAdHocRoutePersonEvent> events = new ArrayList<AddAdHocRoutePersonEvent>();
        for (int i = 0; i < adHocRoutePersons.size(); ++i) {
            events.add(new AddAdHocRoutePersonEvent("adHocRoutePerson[" + i + "]", document, (AdHocRoutePerson)adHocRoutePersons.get(i)));
        }
        return events;
    }

    public List<AddAdHocRouteWorkgroupEvent> generateAdHocRouteWorkgroupEvents(Document document) {
        List adHocRouteWorkgroups = document.getAdHocRouteWorkgroups();
        ArrayList<AddAdHocRouteWorkgroupEvent> events = new ArrayList<AddAdHocRouteWorkgroupEvent>();
        for (int i = 0; i < adHocRouteWorkgroups.size(); ++i) {
            events.add(new AddAdHocRouteWorkgroupEvent("adHocRouteWorkgroup[" + i + "]", document, (AdHocRouteWorkgroup)adHocRouteWorkgroups.get(i)));
        }
        return events;
    }

    public BusinessRule getBusinessRulesInstance(Document document, Class<? extends BusinessRule> ruleInterface) {
        Class businessRulesClass = null;
        if (document instanceof TransactionalDocument) {
            TransactionalDocument transactionalDocument = (TransactionalDocument)document;
            businessRulesClass = this.getDocumentDictionaryService().getBusinessRulesClass((Document)transactionalDocument);
            if (businessRulesClass == null) {
                return new TransactionalDocumentRuleBase();
            }
        } else if (document instanceof MaintenanceDocument) {
            MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
            businessRulesClass = this.getDocumentDictionaryService().getBusinessRulesClass((Document)maintenanceDocument);
            if (businessRulesClass == null) {
                return new MaintenanceDocumentRuleBase();
            }
        } else {
            LOG.error("unable to get businessRulesClass for unknown document type '" + document.getClass().getName() + "'");
        }
        BusinessRule rule = null;
        if (businessRulesClass != null) {
            try {
                if (ruleInterface.isAssignableFrom(businessRulesClass)) {
                    rule = (BusinessRule)businessRulesClass.newInstance();
                }
            }
            catch (IllegalAccessException e) {
                throw new RiceRuntimeException("error processing business rules", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new RiceRuntimeException("error processing business rules", (Throwable)e);
            }
        }
        return rule;
    }

    private void increaseErrorPath(String errorPathPrefix) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (!StringUtils.isBlank((String)errorPathPrefix)) {
            errorMap.addToErrorPath(errorPathPrefix);
        }
    }

    private void decreaseErrorPath(String errorPathPrefix) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (!StringUtils.isBlank((String)errorPathPrefix)) {
            errorMap.removeFromErrorPath(errorPathPrefix);
        }
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

