/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class ModuleLockingHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger LOG = LogManager.getLogger(ModuleLockingHandlerInterceptor.class);
    private KualiModuleService kualiModuleService;
    private String moduleLockedMapping;

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndview) throws Exception {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.isModuleLocked(request)) {
            response.sendRedirect(this.getModuleLockedMapping() + "?moduleNamespace=" + this.getModuleService(request).getModuleConfiguration().getNamespaceCode());
            return false;
        }
        return true;
    }

    protected boolean isModuleLocked(HttpServletRequest request) {
        ModuleService moduleService = this.getModuleService(request);
        if (moduleService != null && moduleService.isLocked()) {
            String principalId = GlobalVariables.getUserSession().getPrincipalId();
            String namespaceCode = "KR-SYS";
            String permissionName = "Access Locked Module";
            HashMap permissionDetails = new HashMap();
            HashMap qualification = new HashMap();
            if (!KimApiServiceLocator.getPermissionService().isAuthorized(principalId, namespaceCode, permissionName, qualification)) {
                return true;
            }
        }
        return false;
    }

    protected ModuleService getModuleService(HttpServletRequest request) {
        String boClass = request.getParameter("businessObjectClassName");
        if (StringUtils.isBlank((String)boClass)) {
            boClass = request.getParameter("dataObjectClassName");
        }
        ModuleService moduleService = null;
        if (StringUtils.isNotBlank((String)boClass)) {
            try {
                moduleService = this.getKualiModuleService().getResponsibleModuleService(Class.forName(boClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.warn("BO class not found: " + boClass, (Throwable)classNotFoundException);
            }
        } else {
            moduleService = this.getKualiModuleService().getResponsibleModuleService(this.getClass());
        }
        return moduleService;
    }

    public String getModuleLockedMapping() {
        return this.moduleLockedMapping;
    }

    public void setModuleLockedMapping(String moduleLockedMapping) {
        this.moduleLockedMapping = moduleLockedMapping;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    protected KualiModuleService getKualiModuleService() {
        if (this.kualiModuleService == null) {
            this.kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return this.kualiModuleService;
    }
}

