/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.component;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ReflectionUtils;

@BeanTag(name="methodConfig", parent="Uif-MethodInvokerConfig")
public class MethodInvokerConfig
extends MethodInvoker
implements Serializable,
Copyable {
    private static final long serialVersionUID = 6626790175367500081L;
    private String staticMethod;
    private Class[] argumentTypes;

    public void prepare() throws ClassNotFoundException, NoSuchMethodException {
        if (this.getTargetObject() == null && this.getTargetClass() != null) {
            try {
                this.setTargetObject(this.getTargetClass().newInstance());
            }
            catch (Exception e) {
                throw new RiceRuntimeException("Unable to create new intance of target class", (Throwable)e);
            }
        }
        super.prepare();
    }

    @BeanTagAttribute
    public String getStaticMethod() {
        return this.staticMethod;
    }

    public void setStaticMethod(String staticMethod) {
        super.setStaticMethod(staticMethod);
        this.staticMethod = staticMethod;
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.LISTVALUE)
    public Class[] getArgumentTypes() {
        if (this.argumentTypes == null) {
            return this.getMethodArgumentTypes();
        }
        return this.argumentTypes;
    }

    public void setArgumentTypes(Class[] argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    @BeanTagAttribute
    public Class getTargetClass() {
        return super.getTargetClass();
    }

    @BeanTagAttribute
    public Object getTargetObject() {
        return super.getTargetObject();
    }

    @BeanTagAttribute
    public String getTargetMethod() {
        return super.getTargetMethod();
    }

    @BeanTagAttribute
    public Object[] getArguments() {
        return super.getArguments();
    }

    protected Class[] getMethodArgumentTypes() {
        Method[] candidates;
        Method matchingCandidate;
        if (StringUtils.isNotBlank((String)this.staticMethod)) {
            int lastDotIndex = this.staticMethod.lastIndexOf(46);
            if (lastDotIndex == -1 || lastDotIndex == this.staticMethod.length()) {
                throw new IllegalArgumentException("staticMethod must be a fully qualified class plus method name: e.g. 'example.MyExampleClass.myExampleMethod'");
            }
            String className = this.staticMethod.substring(0, lastDotIndex);
            String methodName = this.staticMethod.substring(lastDotIndex + 1);
            try {
                this.setTargetClass(this.resolveClassName(className));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to get class for name: " + className, e);
            }
            this.setTargetMethod(methodName);
        }
        if ((matchingCandidate = this.findMatchingMethod()) != null) {
            return matchingCandidate.getParameterTypes();
        }
        for (Method candidate : candidates = ReflectionUtils.getAllDeclaredMethods((Class)this.getTargetClass())) {
            if (!candidate.getName().equals(this.getTargetMethod())) continue;
            return candidate.getParameterTypes();
        }
        return null;
    }

    @Override
    public MethodInvokerConfig clone() throws CloneNotSupportedException {
        return (MethodInvokerConfig)super.clone();
    }
}

