/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.action;

import javax.xml.namespace.QName;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.document.DocumentOrchestrationQueue;
import org.kuali.rice.kew.api.document.DocumentProcessingOptions;
import org.kuali.rice.kew.api.document.OrchestrationConfig;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

final class DocumentOrchestrationQueueAsyncCapableImpl
implements DocumentOrchestrationQueue {
    private final AsyncCapableService asyncCapableService;
    private final DocumentOrchestrationQueue documentOrchestrationQueue;
    private final QName qname;
    private final String applicationId;

    DocumentOrchestrationQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, DocumentOrchestrationQueue documentOrchestrationQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }
        if (documentOrchestrationQueue == null) {
            throw new IllegalArgumentException("documentOrchestrationQueue is null");
        }
        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }
        this.asyncCapableService = asyncCapableService;
        this.documentOrchestrationQueue = documentOrchestrationQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    public void orchestrateDocument(String documentId, String principalId, OrchestrationConfig orchestrationConfig, DocumentProcessingOptions documentProcessingOptions) throws RiceIllegalArgumentException {
        this.asyncCapableService.executeCall(this.qname, this.applicationId, documentId + "/" + principalId, (orchestrationConfig != null ? orchestrationConfig.toString() : "null") + "/" + (documentProcessingOptions != null ? documentProcessingOptions.toString() : "null"), new CallMetadata("orchestrateDocument", new Class[]{String.class, String.class, OrchestrationConfig.class, DocumentProcessingOptions.class}, new Object[]{documentId, principalId, orchestrationConfig, documentProcessingOptions}), () -> this.documentOrchestrationQueue.orchestrateDocument(documentId, principalId, orchestrationConfig, documentProcessingOptions));
    }
}

