/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.xml.sax.Locator;

public class Wrapper
extends FObjMixed
implements CommonAccessibilityHolder {
    private boolean blockOrInlineItemFound;
    private CommonAccessibility commonAccessibility;

    public Wrapper(FONode parent) {
        super(parent);
    }

    @Override
    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.commonAccessibility = CommonAccessibility.getInstance(pList);
    }

    @Override
    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startWrapper(this);
    }

    @Override
    public void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endWrapper(this);
    }

    @Override
    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            if ("marker".equals(localName)) {
                if (this.blockOrInlineItemFound) {
                    this.nodesOutOfOrderError(loc, "fo:marker", "(#PCDATA|%inline;|%block;)");
                }
            } else if (this.isBlockOrInlineItem(nsURI, localName)) {
                try {
                    FONode.validateChildNode(this.parent, loc, nsURI, localName);
                }
                catch (ValidationException vex) {
                    this.invalidChildError(loc, this.getName(), "http://www.w3.org/1999/XSL/Format", localName, "rule.wrapperInvalidChildForParent");
                }
                this.blockOrInlineItemFound = true;
            } else {
                this.invalidChildError(loc, nsURI, localName);
            }
        }
    }

    @Override
    protected void addChildNode(FONode child) throws FOPException {
        super.addChildNode(child);
        if (child instanceof FOText && ((FOText)child).willCreateArea()) {
            FONode ancestor = this.parent;
            while (ancestor.getNameId() == 81) {
                ancestor = ancestor.getParent();
            }
            if (!(ancestor instanceof FObjMixed)) {
                this.invalidChildError(this.getLocator(), this.getLocalName(), "http://www.w3.org/1999/XSL/Format", "#PCDATA", "rule.wrapperInvalidChildForParent");
            }
        }
    }

    @Override
    public String getLocalName() {
        return "wrapper";
    }

    @Override
    public int getNameId() {
        return 81;
    }

    @Override
    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    @Override
    public boolean isDelimitedTextRangeBoundary(int boundary) {
        return false;
    }
}

