Import DDL into database
------------------------

`V1811_003__Initial_DBO_for_HR_API.sql`


Authentication
--------------

Authentication uses a Bearer token as a header value.

```Authorization: Bearer {api-key}```

CURL Testing
------------

1. Import:

  ```
  curl -H "Authorization: Bearer {api-key} --form file=@[local file name] https://[host]/kc-dev/hr-import/hrimport/import

  response:
    OK:
      status: 200
      content:
    {
      "importId":"331197E0-216A-4777-8184-18C544048E72",
      "status":"PROCESSING",
      "message":"Import is processing",
      "startTime":"1395247538",
      "recordTotal":"50",
      "processedRecords":"0",
      "errorCount":"0"
     }
  ```

2. Abort import:

  ```
  curl -H "Authorization: Bearer {api-key} -X DELETE https://[host]/kc-dev/hr-import/hrimport/import/[importId]

  response:
    OK:
      status: 200
  ```

3. Import status:

  ```
  curl -H "Authorization: Bearer {api-key} https://[host]/kc-dev/hr-import/hr-import/hrimport/import/[importId]

    OK:
      status: 200
      content:
    still processing:
    {
      "importId":"331197E0-216A-4777-8184-18C544048E72",
      "status":"PROCESSING",
      "message":"Import is processing",
      "startTime":"1395247538",
      "recordTotal":"50",
      "processedRecords":"15",
      "errorCount":"1",
      "errors": [
          {
            "recordNumber":"3",
            "exception":
              {
                "message":"Unit number 10000000 does not exist"
              }
          }
       ]
     }
     complete:
     {
       "importId":"331197E0-216A-4777-8184-18C544048E72",
       "status":"COMPLETE",
       "message":"Import completed normally",
       "startTime":"1395247538",
       "endTime":"1395248156",
       "recordTotal":"50",
       "processedRecords":"50",
       "errorCount":"1",
       "errors": [
         {
           "recordNumber":"3",
           "exception":
             {
               "message":"Unit number 10000000 does not exist"
             }
         }
       ]
     }
     aborted:
     {
       "importId":"331197E0-216A-4777-8184-18C544048E72",
       "status":"ABORTED",
       "message":"Import aborted",
       "startTime":"1395247538",
       "endTime":"1395247553",
       "recordTotal":"50",
       "processedRecords":"22",
       "errorCount":"0"
     }
     abnormal termination:
     {
       "importId":"331197E0-216A-4777-8184-18C544048E72",
       "status":"ABNORMAL_TERMINATION",
       "message":"Import terminated abnormally",
       "startTime":"1395247538",
       "endTime":"1395247553",
       "recordTotal":"50",
       "processedRecords":"22",
       "errorCount":"0"
     }
  ```
