--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2016 Kuali, Inc.
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
create sequence SEQ_PERSON_TRAINING_CITI INCREMENT BY 1 START WITH 1 NOCACHE;

-- minimal constraints and loose types on this table since this is a staging table and invalid records should still persist
create table PERSON_TRAINING_CITI (
  ID NUMBER(22,0),
  FIRST_NAME varchar2(40),
  LAST_NAME varchar2(80),
  EMAIL varchar2(200),
  EMPLOYEE_NUMBER varchar2(100),
  CURRICULUM_NUMBER varchar2(100),
  CURRICULUM varchar2(200),
  GROUP_ID varchar2(100),
  GRP varchar2(200),
  SCORE varchar2(5),
  PASSING_SCORE varchar2(5),
  STAGE_NUMBER varchar2(100),
  STAGE varchar2(200),
  LEARNER_ID varchar2(100),
  DATE_COMPLETED DATE,
  EXPIRATION_DATE DATE,
  REGISTRATION_DATE DATE,
  NAME varchar2(200),
  USERNAME varchar2(100),
  INSTITUTIONAL_USERNAME varchar2(100),
  INSTITUTIONAL_LANGUAGE varchar2(100),
  INSTITUTIONAL_EMAIL varchar2(200),
  GENDER VARCHAR2(20),
  HIGHEST_DEGREE VARCHAR2(200),
  DEPARTMENT VARCHAR2(200),
  ADDRESS_FIELD1 VARCHAR2(128),
  ADDRESS_FIELD2 VARCHAR2(128),
  ADDRESS_FIELD3 VARCHAR2(128),
  CITY VARCHAR2(30),
  STATE varchar2(100),
  ZIP_CODE VARCHAR2(20),
  COUNTRY varchar2(100),
  PHONE VARCHAR2(20),
  CUSTOM_FIELD1 varchar2(200),
  CUSTOM_FIELD2 varchar2(200),
  CUSTOM_FIELD3 varchar2(200),
  CUSTOM_FIELD4 varchar2(200),
  CUSTOM_FIELD5 varchar2(200),
  MODULE varchar2(200),
  EXAM_ID varchar2(100),
  EXAM_SCORE varchar2(5),
  MODULE_COMPLETION_DATE DATE,
  RAW_RECORD CLOB,
  STATUS_CODE varchar2(1) DEFAULT 'S' NOT NULL ,
  UPDATE_USER VARCHAR2(60) NOT NULL,
  UPDATE_TIMESTAMP DATE NOT NULL,
  VER_NBR NUMBER (8,0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL);

ALTER TABLE PERSON_TRAINING_CITI
  ADD CONSTRAINT PK_PERSON_TRAINING_CITI
PRIMARY KEY (ID);

ALTER TABLE PERSON_TRAINING_CITI
  ADD CONSTRAINT UQ_PERSON_TRAINING_CITI
UNIQUE (OBJ_ID);

create index PERSON_TRAINING_CITI_IDX on PERSON_TRAINING_CITI (STATUS_CODE);

create sequence SEQ_PERSON_TRAINING_CITI_ERR INCREMENT BY 1 START WITH 1 NOCACHE;

create table PERSON_TRAINING_CITI_ERR (
  ID number(22,0),
  CITI_RECORD_ID number(22,0) not null,
  MESSAGE varchar2(2000) not null,
  UPDATE_USER VARCHAR2(60) NOT NULL,
  UPDATE_TIMESTAMP DATE NOT NULL,
  VER_NBR NUMBER (8,0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL);

ALTER TABLE PERSON_TRAINING_CITI_ERR
  ADD CONSTRAINT PK_PERSON_TRAINING_CITI_ERR
PRIMARY KEY (ID);

ALTER TABLE PERSON_TRAINING_CITI_ERR
  ADD CONSTRAINT UQ_PERSON_TRAINING_CITI_ERR
UNIQUE (OBJ_ID);

ALTER TABLE PERSON_TRAINING_CITI_ERR
  ADD CONSTRAINT FK_PERSON_TRAINING_CITI_ERR
FOREIGN KEY (CITI_RECORD_ID)
REFERENCES PERSON_TRAINING_CITI (ID);

create sequence SEQ_PERSON_TRAINING_CITI_MAP INCREMENT BY 1 START WITH 1 NOCACHE;

create table PERSON_TRAINING_CITI_MAP (
  ID number(22,0),
  CURRICULUM_NUMBER varchar2(100) not null,
  GROUP_ID varchar2(100) not null,
  STAGE_NUMBER varchar2(100) not null,
  TRAINING_CODE number(4,0),
  UPDATE_USER VARCHAR2(60) NOT NULL,
  UPDATE_TIMESTAMP DATE NOT NULL,
  VER_NBR NUMBER (8,0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL);

create index PERSON_TRAINING_CITI_ERR_IDX on PERSON_TRAINING_CITI_ERR (CITI_RECORD_ID);

ALTER TABLE PERSON_TRAINING_CITI_MAP
  ADD CONSTRAINT PK_PERSON_TRAINING_CITI_MAP
PRIMARY KEY (ID);

ALTER TABLE PERSON_TRAINING_CITI_MAP
  ADD CONSTRAINT UQ_PERSON_TRAINING_CITI_MAP
UNIQUE (OBJ_ID);

ALTER TABLE PERSON_TRAINING_CITI_MAP
  ADD CONSTRAINT UQ2_PERSON_TRAINING_CITI_MAP
UNIQUE (CURRICULUM_NUMBER, GROUP_ID, STAGE_NUMBER);

ALTER TABLE PERSON_TRAINING_CITI_MAP
  ADD CONSTRAINT UQ3_PERSON_TRAINING_CITI_MAP
UNIQUE (TRAINING_CODE);

ALTER TABLE PERSON_TRAINING_CITI_MAP
  ADD CONSTRAINT FK_PERSON_TRAIN_CITI_MAP_CODE
FOREIGN KEY (TRAINING_CODE)
REFERENCES TRAINING (TRAINING_CODE);
