/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.document;

import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.MaterializeOption;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentControllerServiceImpl;
import org.kuali.rice.krad.document.TransactionalDocumentControllerService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.form.DialogResponse;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.TransactionalDocumentFormBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.web.servlet.ModelAndView;

public class TransactionalDocumentControllerServiceImpl
extends DocumentControllerServiceImpl
implements TransactionalDocumentControllerService {
    private PessimisticLockService pessimisticLockService;

    @Override
    public ModelAndView copy(TransactionalDocumentFormBase form) {
        try {
            KradDataServiceLocator.getDataObjectService().wrap((Object)form.getDocument()).materializeReferencedObjectsToDepth(3, new MaterializeOption[]{MaterializeOption.UPDATE_UPDATABLE_REFS});
            form.setDocument((Document)KradDataServiceLocator.getDataObjectService().copyInstance((Object)form.getDocument(), new CopyOption[0]));
            ((Copyable)((Object)form.getDocument())).toCopy();
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Unable to copy transactional document", e);
        }
        form.setEvaluateFlagsAndModes(true);
        form.setCanEditView(null);
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView cancel(UifFormBase form) {
        ModelAndView modelAndView = super.cancel(form);
        this.releasePessimisticLocks((DocumentFormBase)form);
        return modelAndView;
    }

    @Override
    public ModelAndView route(DocumentFormBase form) {
        ModelAndView modelAndView = super.route(form);
        this.releasePessimisticLocks(form);
        return modelAndView;
    }

    @Override
    public ModelAndView approve(DocumentFormBase form) {
        ModelAndView modelAndView = super.approve(form);
        this.releasePessimisticLocks(form);
        return modelAndView;
    }

    @Override
    public ModelAndView disapprove(DocumentFormBase form) {
        ModelAndView modelAndView = super.disapprove(form);
        this.releasePessimisticLocks(form);
        return modelAndView;
    }

    @Override
    public ModelAndView acknowledge(DocumentFormBase form) {
        ModelAndView modelAndView = super.acknowledge(form);
        this.releasePessimisticLocks(form);
        return modelAndView;
    }

    @Override
    public ModelAndView close(DocumentFormBase form) {
        Document document = form.getDocument();
        if (document.getDocumentHeader().getWorkflowDocument().isValidAction(ActionType.SAVE)) {
            DialogResponse dialogResponse = form.getDialogResponse("ConfirmSaveOnCloseDialog");
            if (dialogResponse == null) {
                return this.getModelAndViewService().showDialog("ConfirmSaveOnCloseDialog", false, form);
            }
            if (dialogResponse.getResponseAsBoolean()) {
                String explanation = document.getDocumentHeader().getExplanation();
                ModelAndView sensitiveDataDialogModelAndView = this.checkSensitiveDataAndWarningDialog(explanation, form);
                if (sensitiveDataDialogModelAndView != null) {
                    return sensitiveDataDialogModelAndView;
                }
                this.performWorkflowAction(form, UifConstants.WorkflowAction.SAVE);
            }
        }
        this.releasePessimisticLocks(form);
        return super.close(form);
    }

    protected void releasePessimisticLocks(DocumentFormBase form) {
        Document document = form.getDocument();
        if (!document.getPessimisticLocks().isEmpty()) {
            Person user = GlobalVariables.getUserSession().getPerson();
            this.getPessimisticLockService().releaseAllLocksForUser(document.getPessimisticLocks(), user);
            document.refreshPessimisticLocks();
        }
    }

    protected PessimisticLockService getPessimisticLockService() {
        if (this.pessimisticLockService == null) {
            this.pessimisticLockService = KRADServiceLocatorWeb.getPessimisticLockService();
        }
        return this.pessimisticLockService;
    }

    protected void setPessimisticLockService(PessimisticLockService pessimisticLockService) {
        this.pessimisticLockService = pessimisticLockService;
    }
}

