/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository.language;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.tools.generic.ComparisonDateTool;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.SortTool;

public class VelocityTemplateEngine {
    private final VelocityEngine velocityEngine = new VelocityEngine();
    private VelocityContext defaultContext;
    private Map<String, Object> configMap = new HashMap<String, Object>();

    public VelocityTemplateEngine() {
        this.init();
    }

    public VelocityTemplateEngine(Map<String, Object> config) {
        this.configMap = config;
        this.init();
    }

    private void init() {
        this.velocityEngine.setProperty("resource.loader", (Object)"class");
        this.velocityEngine.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.setLogFile();
        DateTool dateTool = new DateTool();
        dateTool.configure(this.configMap);
        MathTool mathTool = new MathTool();
        NumberTool numberTool = new NumberTool();
        numberTool.configure(this.configMap);
        SortTool sortTool = new SortTool();
        this.defaultContext = new VelocityContext();
        this.defaultContext.put("dateTool", (Object)dateTool);
        this.defaultContext.put("dateComparisonTool", (Object)new ComparisonDateTool());
        this.defaultContext.put("mathTool", (Object)mathTool);
        this.defaultContext.put("numberTool", (Object)numberTool);
        this.defaultContext.put("sortTool", (Object)sortTool);
        try {
            this.velocityEngine.init();
        }
        catch (Exception e) {
            throw new VelocityException((Throwable)e);
        }
    }

    public void setLogging(boolean enableLogging) {
        if (!enableLogging) {
            this.velocityEngine.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        } else {
            this.velocityEngine.setProperty("runtime.log.logsystem.class", null);
            this.setLogFile();
        }
    }

    public void setLogFile() {
        if (System.getProperty("catalina.base") != null) {
            this.setLogFile(System.getProperty("catalina.base") + "/logs/velocity.log");
        } else {
            this.setLogFile("target/velocity.log");
        }
    }

    public void setLogFile(String logfile) {
        this.velocityEngine.setProperty("runtime.log", (Object)logfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String evaluate(Map<String, Object> contextMap, String template) throws VelocityException {
        Reader readerOut = null;
        try {
            readerOut = new BufferedReader(new StringReader(template));
            String string = this.evaluate(contextMap, readerOut);
            return string;
        }
        finally {
            if (readerOut != null) {
                try {
                    readerOut.close();
                }
                catch (IOException e) {
                    throw new VelocityException((Throwable)e);
                }
            }
        }
    }

    public String evaluate(Map<String, Object> mapContext, Reader template) throws VelocityException {
        VelocityContext context = new VelocityContext(mapContext, (Context)this.defaultContext);
        StringWriter writerOut = new StringWriter();
        try {
            this.velocityEngine.evaluate((Context)context, (Writer)writerOut, "VelocityEngine", template);
            return writerOut.toString();
        }
        catch (Exception e) {
            throw new VelocityException((Throwable)e);
        }
    }
}

