/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.ack.CreateIndexClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataIndexTemplateService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.threadpool.ThreadPool;

public class MetaDataCreateIndexService {
    private static final Logger logger = LogManager.getLogger(MetaDataCreateIndexService.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(logger);
    public static final int MAX_INDEX_NAME_BYTES = 255;
    private final Settings settings;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final AliasValidator aliasValidator;
    private final Environment env;
    private final IndexScopedSettings indexScopedSettings;
    private final ActiveShardsObserver activeShardsObserver;
    private final NamedXContentRegistry xContentRegistry;
    private final boolean forbidPrivateIndexSettings;

    public MetaDataCreateIndexService(Settings settings, ClusterService clusterService, IndicesService indicesService, AllocationService allocationService, AliasValidator aliasValidator, Environment env, IndexScopedSettings indexScopedSettings, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, boolean forbidPrivateIndexSettings) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.aliasValidator = aliasValidator;
        this.env = env;
        this.indexScopedSettings = indexScopedSettings;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.xContentRegistry = xContentRegistry;
        this.forbidPrivateIndexSettings = forbidPrivateIndexSettings;
    }

    public static void validateIndexName(String index, ClusterState state) {
        MetaDataCreateIndexService.validateIndexOrAliasName(index, InvalidIndexNameException::new);
        if (!index.toLowerCase(Locale.ROOT).equals(index)) {
            throw new InvalidIndexNameException(index, "must be lowercase");
        }
        if (state.routingTable().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.routingTable().index(index).getIndex());
        }
        if (state.metaData().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.metaData().index(index).getIndex());
        }
        if (state.metaData().hasAlias(index)) {
            throw new InvalidIndexNameException(index, "already exists as alias");
        }
    }

    public static void validateIndexOrAliasName(String index, BiFunction<String, String, ? extends RuntimeException> exceptionCtor) {
        if (!Strings.validFileName(index)) {
            throw exceptionCtor.apply(index, "must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (index.contains("#")) {
            throw exceptionCtor.apply(index, "must not contain '#'");
        }
        if (index.contains(":")) {
            throw exceptionCtor.apply(index, "must not contain ':'");
        }
        if (index.charAt(0) == '_' || index.charAt(0) == '-' || index.charAt(0) == '+') {
            throw exceptionCtor.apply(index, "must not start with '_', '-', or '+'");
        }
        int byteCount = 0;
        try {
            byteCount = index.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new ElasticsearchException("Unable to determine length of index name", (Throwable)e, new Object[0]);
        }
        if (byteCount > 255) {
            throw exceptionCtor.apply(index, "index name is too long, (" + byteCount + " > " + 255 + ")");
        }
        if (index.equals(".") || index.equals("..")) {
            throw exceptionCtor.apply(index, "must not be '.' or '..'");
        }
    }

    public void createIndex(CreateIndexClusterStateUpdateRequest request, ActionListener<CreateIndexClusterStateUpdateResponse> listener) {
        this.onlyCreateIndex(request, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.activeShardsObserver.waitForActiveShards(new String[]{request.index()}, request.waitForActiveShards(), request.ackTimeout(), shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        logger.debug("[{}] index created, but the operation timed out while waiting for enough shards to be started.", (Object)request.index());
                    }
                    listener.onResponse(new CreateIndexClusterStateUpdateResponse(response.isAcknowledged(), (boolean)shardsAcknowledged));
                }, listener::onFailure);
            } else {
                listener.onResponse(new CreateIndexClusterStateUpdateResponse(false, false));
            }
        }, listener::onFailure));
    }

    private void onlyCreateIndex(final CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        Settings.Builder updatedSettingsBuilder = Settings.builder();
        Settings build = updatedSettingsBuilder.put(request.settings()).normalizePrefix("index.").build();
        this.indexScopedSettings.validate(build, true);
        request.settings(build);
        this.clusterService.submitStateUpdateTask("create-index [" + request.index() + "], cause [" + request.cause() + "]", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return MetaDataCreateIndexService.this.applyCreateIndexRequest(currentState, request);
            }

            @Override
            public void onFailure(String source, Exception e) {
                if (e instanceof ResourceAlreadyExistsException) {
                    logger.trace(() -> new ParameterizedMessage("[{}] failed to create", (Object)request.index()), (Throwable)e);
                } else {
                    logger.debug(() -> new ParameterizedMessage("[{}] failed to create", (Object)request.index()), (Throwable)e);
                }
                super.onFailure(source, e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState applyCreateIndexRequest(ClusterState currentState, CreateIndexClusterStateUpdateRequest request) throws Exception {
        logger.trace("executing IndexCreationTask for [{}] against cluster state version [{}]", (Object)request, (Object)currentState.version());
        Index createdIndex = null;
        String removalExtraInfo = null;
        IndicesClusterStateService.AllocatedIndices.IndexRemovalReason removalReason = IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.FAILURE;
        this.validate(request, currentState);
        Index recoverFromIndex = request.recoverFrom();
        IndexMetaData sourceMetaData = recoverFromIndex == null ? null : currentState.metaData().getIndexSafe(recoverFromIndex);
        List<IndexTemplateMetaData> templates = sourceMetaData == null ? Collections.unmodifiableList(MetaDataIndexTemplateService.findTemplates(currentState.metaData(), request.index())) : Collections.emptyList();
        Map<String, Map<String, Object>> mappings = Collections.unmodifiableMap(MetaDataCreateIndexService.parseMappings(request.mappings(), templates, this.xContentRegistry));
        Settings aggregatedIndexSettings = MetaDataCreateIndexService.aggregateIndexSettings(currentState, request, templates, mappings, sourceMetaData, this.settings, this.indexScopedSettings);
        int routingNumShards = MetaDataCreateIndexService.getIndexNumberOfRoutingShards(aggregatedIndexSettings, sourceMetaData);
        Settings.Builder settingsBuilder = Settings.builder().put(aggregatedIndexSettings);
        settingsBuilder.remove(IndexMetaData.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.getKey());
        Settings indexSettings = settingsBuilder.build();
        try {
            IndexMetaData indexMetaData;
            IndexService indexService = MetaDataCreateIndexService.validateActiveShardCountAndCreateIndexService(request.index(), request.waitForActiveShards(), indexSettings, routingNumShards, this.indicesService);
            createdIndex = indexService.index();
            try {
                MetaDataCreateIndexService.updateIndexMappingsAndBuildSortOrder(indexService, mappings, sourceMetaData);
            }
            catch (Exception e) {
                removalExtraInfo = "failed on parsing mappings on index creation";
                throw e;
            }
            List<AliasMetaData> aliases = Collections.unmodifiableList(MetaDataCreateIndexService.resolveAndValidateAliases(request.index(), request.aliases(), templates, currentState.metaData(), this.aliasValidator, this.xContentRegistry, indexService.newQueryShardContext(0, null, () -> 0L, null)));
            try {
                MapperService mapperService = indexService.mapperService();
                indexMetaData = MetaDataCreateIndexService.buildIndexMetaData(request.index(), aliases, mapperService::documentMapper, () -> mapperService.documentMapper("_default_"), indexSettings, routingNumShards, sourceMetaData);
            }
            catch (Exception e) {
                removalExtraInfo = "failed to build index metadata";
                throw e;
            }
            logger.info("[{}] creating index, cause [{}], templates {}, shards [{}]/[{}], mappings {}", (Object)request.index(), (Object)request.cause(), templates.stream().map(IndexTemplateMetaData::getName).collect(Collectors.toList()), (Object)indexMetaData.getNumberOfShards(), (Object)indexMetaData.getNumberOfReplicas(), mappings.keySet());
            indexService.getIndexEventListener().beforeIndexAddedToCluster(indexMetaData.getIndex(), indexMetaData.getSettings());
            ClusterState updatedState = MetaDataCreateIndexService.clusterStateCreateIndex(currentState, request.blocks(), indexMetaData, this.allocationService::reroute);
            removalExtraInfo = "cleaning up after validating index on master";
            removalReason = IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED;
            ClusterState clusterState = updatedState;
            if (createdIndex != null) {
                this.indicesService.removeIndex(createdIndex, removalReason, removalExtraInfo);
            }
            return clusterState;
        }
        catch (Throwable throwable) {
            if (createdIndex != null) {
                this.indicesService.removeIndex(createdIndex, removalReason, removalExtraInfo);
            }
            throw throwable;
        }
    }

    static Map<String, Map<String, Object>> parseMappings(Map<String, String> requestMappings, List<IndexTemplateMetaData> templates, NamedXContentRegistry xContentRegistry) throws Exception {
        HashMap<String, Map<String, Object>> mappings = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, String> entry : requestMappings.entrySet()) {
            Map<String, Object> mapping = MapperService.parseMapping(xContentRegistry, entry.getValue());
            assert (mapping.size() == 1) : mapping;
            assert (entry.getKey().equals(mapping.keySet().iterator().next())) : entry.getKey() + " != " + mapping;
            mappings.put(entry.getKey(), mapping);
        }
        for (IndexTemplateMetaData template : templates) {
            for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : template.mappings()) {
                Map<String, Object> templateMapping;
                String mappingString = ((CompressedXContent)objectObjectCursor.value).string();
                if (mappings.containsKey(objectObjectCursor.key)) {
                    XContentHelper.mergeDefaults((Map)mappings.get(objectObjectCursor.key), MapperService.parseMapping(xContentRegistry, mappingString));
                    continue;
                }
                if (mappings.size() == 1 && ((String)objectObjectCursor.key).equals("_doc")) {
                    templateMapping = MapperService.parseMapping(xContentRegistry, mappingString);
                    assert (templateMapping.size() == 1) : templateMapping;
                    assert (((String)objectObjectCursor.key).equals(templateMapping.keySet().iterator().next())) : (String)objectObjectCursor.key + " != " + templateMapping;
                    Map.Entry mappingEntry = mappings.entrySet().iterator().next();
                    templateMapping = Collections.singletonMap((String)mappingEntry.getKey(), templateMapping.values().iterator().next());
                    XContentHelper.mergeDefaults((Map)mappingEntry.getValue(), templateMapping);
                    continue;
                }
                if (template.mappings().size() == 1 && mappings.containsKey("_doc")) {
                    templateMapping = MapperService.parseMapping(xContentRegistry, mappingString);
                    assert (templateMapping.size() == 1) : templateMapping;
                    assert (((String)objectObjectCursor.key).equals(templateMapping.keySet().iterator().next())) : (String)objectObjectCursor.key + " != " + templateMapping;
                    Map mapping = (Map)mappings.get("_doc");
                    templateMapping = Collections.singletonMap("_doc", templateMapping.values().iterator().next());
                    XContentHelper.mergeDefaults(mapping, templateMapping);
                    continue;
                }
                mappings.put((String)objectObjectCursor.key, MapperService.parseMapping(xContentRegistry, mappingString));
            }
        }
        return mappings;
    }

    static Settings aggregateIndexSettings(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, List<IndexTemplateMetaData> templates, Map<String, Map<String, Object>> mappings, @Nullable IndexMetaData sourceMetaData, Settings settings, IndexScopedSettings indexScopedSettings) {
        Settings.Builder indexSettingsBuilder = Settings.builder();
        if (sourceMetaData == null) {
            for (int i = templates.size() - 1; i >= 0; --i) {
                indexSettingsBuilder.put(templates.get(i).settings());
            }
        }
        indexSettingsBuilder.put(request.settings());
        if (indexSettingsBuilder.get(IndexMetaData.SETTING_INDEX_VERSION_CREATED.getKey()) == null) {
            DiscoveryNodes nodes = currentState.nodes();
            Version createdVersion = Version.min(Version.CURRENT, nodes.getSmallestNonClientNodeVersion());
            indexSettingsBuilder.put(IndexMetaData.SETTING_INDEX_VERSION_CREATED.getKey(), createdVersion);
        }
        if (indexSettingsBuilder.get("index.number_of_shards") == null) {
            int numberOfShards = MetaDataCreateIndexService.getNumberOfShards(indexSettingsBuilder);
            indexSettingsBuilder.put("index.number_of_shards", settings.getAsInt("index.number_of_shards", numberOfShards));
        }
        if (indexSettingsBuilder.get("index.number_of_replicas") == null) {
            indexSettingsBuilder.put("index.number_of_replicas", settings.getAsInt("index.number_of_replicas", 1));
        }
        if (settings.get("index.auto_expand_replicas") != null && indexSettingsBuilder.get("index.auto_expand_replicas") == null) {
            indexSettingsBuilder.put("index.auto_expand_replicas", settings.get("index.auto_expand_replicas"));
        }
        if (indexSettingsBuilder.get("index.creation_date") == null) {
            indexSettingsBuilder.put("index.creation_date", Instant.now().toEpochMilli());
        }
        indexSettingsBuilder.put("index.provided_name", request.getProvidedName());
        indexSettingsBuilder.put("index.uuid", UUIDs.randomBase64UUID());
        if (sourceMetaData != null) {
            assert (request.resizeType() != null);
            MetaDataCreateIndexService.prepareResizeIndexSettings(currentState, mappings.keySet(), indexSettingsBuilder, request.recoverFrom(), request.index(), request.resizeType(), request.copySettings(), indexScopedSettings);
        }
        Settings indexSettings = indexSettingsBuilder.build();
        MetaDataCreateIndexService.checkShardLimit(indexSettings, currentState);
        if (!indexSettings.getAsBoolean(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), true).booleanValue()) {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog("soft_deletes_disabled", "Creating indices with soft-deletes disabled is deprecated and will be removed in future Elasticsearch versions. Please do not specify value for setting [index.soft_deletes.enabled] of index [" + request.index() + "].", new Object[0]);
        }
        return indexSettings;
    }

    static int getNumberOfShards(Settings.Builder indexSettingsBuilder) {
        assert (Version.CURRENT.major == 7);
        Version indexVersionCreated = Version.fromId(Integer.parseInt(indexSettingsBuilder.get(IndexMetaData.SETTING_INDEX_VERSION_CREATED.getKey())));
        int numberOfShards = indexVersionCreated.before(Version.V_7_0_0) ? 5 : 1;
        return numberOfShards;
    }

    static int getIndexNumberOfRoutingShards(Settings indexSettings, @Nullable IndexMetaData sourceMetaData) {
        int routingNumShards;
        int numTargetShards = IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(indexSettings);
        Version indexVersionCreated = IndexMetaData.SETTING_INDEX_VERSION_CREATED.get(indexSettings);
        if (sourceMetaData == null || sourceMetaData.getNumberOfShards() == 1) {
            routingNumShards = IndexMetaData.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(indexSettings) ? IndexMetaData.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.get(indexSettings) : MetaDataCreateIndexService.calculateNumRoutingShards(numTargetShards, indexVersionCreated);
        } else {
            assert (!IndexMetaData.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(indexSettings)) : "index.number_of_routing_shards should not be present on the target index on resize";
            routingNumShards = sourceMetaData.getRoutingNumShards();
        }
        return routingNumShards;
    }

    static List<AliasMetaData> resolveAndValidateAliases(String index, Set<Alias> aliases, List<IndexTemplateMetaData> templates, MetaData metaData, AliasValidator aliasValidator, NamedXContentRegistry xContentRegistry, QueryShardContext queryShardContext) {
        ArrayList<AliasMetaData> resolvedAliases = new ArrayList<AliasMetaData>();
        for (Alias alias : aliases) {
            aliasValidator.validateAlias(alias, index, metaData);
            if (Strings.hasLength(alias.filter())) {
                aliasValidator.validateAliasFilter(alias.name(), alias.filter(), queryShardContext, xContentRegistry);
            }
            AliasMetaData aliasMetaData = AliasMetaData.builder(alias.name()).filter(alias.filter()).indexRouting(alias.indexRouting()).searchRouting(alias.searchRouting()).writeIndex(alias.writeIndex()).build();
            resolvedAliases.add(aliasMetaData);
        }
        HashMap<String, AliasMetaData> templatesAliases = new HashMap<String, AliasMetaData>();
        for (IndexTemplateMetaData template : templates) {
            for (ObjectObjectCursor<String, AliasMetaData> objectObjectCursor : template.aliases()) {
                AliasMetaData aliasMetaData = (AliasMetaData)objectObjectCursor.value;
                if (aliases.contains(new Alias(aliasMetaData.alias())) || templatesAliases.containsKey(objectObjectCursor.key)) continue;
                if (aliasMetaData.alias().contains("{index}")) {
                    String templatedAlias = aliasMetaData.alias().replace("{index}", index);
                    aliasMetaData = AliasMetaData.newAliasMetaData(aliasMetaData, templatedAlias);
                }
                aliasValidator.validateAliasMetaData(aliasMetaData, index, metaData);
                if (aliasMetaData.filter() != null) {
                    aliasValidator.validateAliasFilter(aliasMetaData.alias(), aliasMetaData.filter().uncompressed(), queryShardContext, xContentRegistry);
                }
                templatesAliases.put(aliasMetaData.alias(), aliasMetaData);
                resolvedAliases.add(aliasMetaData);
            }
        }
        return resolvedAliases;
    }

    static ClusterState clusterStateCreateIndex(ClusterState currentState, Set<ClusterBlock> clusterBlocks, IndexMetaData indexMetaData, BiFunction<ClusterState, String, ClusterState> rerouteRoutingTable) {
        MetaData newMetaData = MetaData.builder(currentState.metaData()).put(indexMetaData, false).build();
        String indexName = indexMetaData.getIndex().getName();
        ClusterBlocks.Builder blocks = MetaDataCreateIndexService.createClusterBlocksBuilder(currentState, indexName, clusterBlocks);
        blocks.updateBlocks(indexMetaData);
        ClusterState updatedState = ClusterState.builder(currentState).blocks(blocks).metaData(newMetaData).build();
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable()).addAsNew(updatedState.metaData().index(indexName));
        updatedState = ClusterState.builder(updatedState).routingTable(routingTableBuilder.build()).build();
        return rerouteRoutingTable.apply(updatedState, "index [" + indexName + "] created");
    }

    static IndexMetaData buildIndexMetaData(String indexName, List<AliasMetaData> aliases, Supplier<DocumentMapper> documentMapperSupplier, Supplier<DocumentMapper> defaultDocumentMapperSupplier, Settings indexSettings, int routingNumShards, @Nullable IndexMetaData sourceMetaData) {
        IndexMetaData.Builder indexMetaDataBuilder = MetaDataCreateIndexService.createIndexMetadataBuilder(indexName, sourceMetaData, indexSettings, routingNumShards);
        HashMap<String, MappingMetaData> mappingsMetaData = new HashMap<String, MappingMetaData>();
        for (DocumentMapper mapper : Arrays.asList(documentMapperSupplier.get(), defaultDocumentMapperSupplier.get())) {
            if (mapper == null) continue;
            MappingMetaData mappingMd = new MappingMetaData(mapper);
            mappingsMetaData.put(mapper.type(), mappingMd);
        }
        for (MappingMetaData mappingMd : mappingsMetaData.values()) {
            indexMetaDataBuilder.putMapping(mappingMd);
        }
        for (int i = aliases.size() - 1; i >= 0; --i) {
            indexMetaDataBuilder.putAlias(aliases.get(i));
        }
        indexMetaDataBuilder.state(IndexMetaData.State.OPEN);
        return indexMetaDataBuilder.build();
    }

    private static IndexMetaData.Builder createIndexMetadataBuilder(String indexName, @Nullable IndexMetaData sourceMetaData, Settings indexSettings, int routingNumShards) {
        IndexMetaData.Builder builder = IndexMetaData.builder(indexName);
        builder.setRoutingNumShards(routingNumShards);
        builder.settings(indexSettings);
        if (sourceMetaData != null) {
            long primaryTerm = IntStream.range(0, sourceMetaData.getNumberOfShards()).mapToLong(sourceMetaData::primaryTerm).max().getAsLong();
            for (int shardId = 0; shardId < builder.numberOfShards(); ++shardId) {
                builder.primaryTerm(shardId, primaryTerm);
            }
        }
        return builder;
    }

    private static ClusterBlocks.Builder createClusterBlocksBuilder(ClusterState currentState, String index, Set<ClusterBlock> blocks) {
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        if (!blocks.isEmpty()) {
            for (ClusterBlock block : blocks) {
                blocksBuilder.addIndexBlock(index, block);
            }
        }
        return blocksBuilder;
    }

    private static void updateIndexMappingsAndBuildSortOrder(IndexService indexService, Map<String, Map<String, Object>> mappings, @Nullable IndexMetaData sourceMetaData) throws IOException {
        MapperService mapperService = indexService.mapperService();
        if (!mappings.isEmpty()) {
            assert (mappings.size() == 1) : mappings;
            CompressedXContent content = new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(mappings)));
            mapperService.merge(mappings, MapperService.MergeReason.MAPPING_UPDATE);
        }
        if (sourceMetaData == null) {
            indexService.getIndexSortSupplier().get();
        }
    }

    private static IndexService validateActiveShardCountAndCreateIndexService(String indexName, ActiveShardCount waitForActiveShards, Settings indexSettings, int routingNumShards, IndicesService indicesService) throws IOException {
        IndexMetaData.Builder tmpImdBuilder = IndexMetaData.builder(indexName);
        tmpImdBuilder.setRoutingNumShards(routingNumShards);
        tmpImdBuilder.settings(indexSettings);
        IndexMetaData tmpImd = tmpImdBuilder.build();
        if (waitForActiveShards == ActiveShardCount.DEFAULT) {
            waitForActiveShards = tmpImd.getWaitForActiveShards();
        }
        if (!waitForActiveShards.validate(tmpImd.getNumberOfReplicas())) {
            throw new IllegalArgumentException("invalid wait_for_active_shards[" + waitForActiveShards + "]: cannot be greater than number of shard copies [" + (tmpImd.getNumberOfReplicas() + 1) + "]");
        }
        return indicesService.createIndex(tmpImd, Collections.emptyList(), false);
    }

    private void validate(CreateIndexClusterStateUpdateRequest request, ClusterState state) {
        MetaDataCreateIndexService.validateIndexName(request.index(), state);
        this.validateIndexSettings(request.index(), request.settings(), this.forbidPrivateIndexSettings);
    }

    public void validateIndexSettings(String indexName, Settings settings, boolean forbidPrivateIndexSettings) throws IndexCreationException {
        List<String> validationErrors = this.getIndexSettingsValidationErrors(settings, forbidPrivateIndexSettings);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new IndexCreationException(indexName, validationException);
        }
    }

    public static void checkShardLimit(Settings settings, ClusterState clusterState) {
        int numberOfReplicas;
        int numberOfShards = IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(settings);
        int shardsToCreate = numberOfShards * (1 + (numberOfReplicas = IndexMetaData.INDEX_NUMBER_OF_REPLICAS_SETTING.get(settings).intValue()));
        Optional<String> shardLimit = IndicesService.checkShardLimit(shardsToCreate, clusterState);
        if (shardLimit.isPresent()) {
            ValidationException e = new ValidationException();
            e.addValidationError(shardLimit.get());
            throw e;
        }
    }

    List<String> getIndexSettingsValidationErrors(Settings settings, boolean forbidPrivateIndexSettings) {
        List<String> validationErrors = MetaDataCreateIndexService.validateIndexCustomPath(settings, this.env.sharedDataFile());
        if (forbidPrivateIndexSettings) {
            validationErrors.addAll(MetaDataCreateIndexService.validatePrivateSettingsNotExplicitlySet(settings, this.indexScopedSettings));
        }
        return validationErrors;
    }

    private static List<String> validatePrivateSettingsNotExplicitlySet(Settings settings, IndexScopedSettings indexScopedSettings) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (String key : settings.keySet()) {
            Setting<?> setting = indexScopedSettings.get(key);
            if (setting == null) {
                assert (indexScopedSettings.isPrivateSetting(key));
                continue;
            }
            if (!setting.isPrivateIndex()) continue;
            validationErrors.add("private index setting [" + key + "] can not be set explicitly");
        }
        return validationErrors;
    }

    private static List<String> validateIndexCustomPath(Settings settings, @Nullable Path sharedDataPath) {
        String customPath = IndexMetaData.INDEX_DATA_PATH_SETTING.get(settings);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!Strings.isEmpty(customPath)) {
            if (sharedDataPath == null) {
                validationErrors.add("path.shared_data must be set in order to use custom data paths");
            } else {
                Path resolvedPath = PathUtils.get((Path[])new Path[]{sharedDataPath}, (String)customPath);
                if (resolvedPath == null) {
                    validationErrors.add("custom path [" + customPath + "] is not a sub-path of path.shared_data [" + sharedDataPath + "]");
                }
            }
        }
        return validationErrors;
    }

    static List<String> validateShrinkIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetaData sourceMetaData = MetaDataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        assert (IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings));
        IndexMetaData.selectShrinkShards(0, sourceMetaData, IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        if (sourceMetaData.getNumberOfShards() == 1) {
            throw new IllegalArgumentException("can't shrink an index with only one shard");
        }
        IndexRoutingTable table = state.routingTable().index(sourceIndex);
        HashMap<String, AtomicInteger> nodesToNumRouting = new HashMap<String, AtomicInteger>();
        int numShards = sourceMetaData.getNumberOfShards();
        for (ShardRouting routing : table.shardsWithState(ShardRoutingState.STARTED)) {
            nodesToNumRouting.computeIfAbsent(routing.currentNodeId(), s -> new AtomicInteger(0)).incrementAndGet();
        }
        ArrayList<String> nodesToAllocateOn = new ArrayList<String>();
        for (Map.Entry entries : nodesToNumRouting.entrySet()) {
            int numAllocations = ((AtomicInteger)entries.getValue()).get();
            assert (numAllocations <= numShards) : "wait what? " + numAllocations + " is > than num shards " + numShards;
            if (numAllocations != numShards) continue;
            nodesToAllocateOn.add((String)entries.getKey());
        }
        if (nodesToAllocateOn.isEmpty()) {
            throw new IllegalStateException("index " + sourceIndex + " must have all shards allocated on the same node to shrink index");
        }
        return nodesToAllocateOn;
    }

    static void validateSplitIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetaData sourceMetaData = MetaDataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        IndexMetaData.selectSplitShard(0, sourceMetaData, IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        if (sourceMetaData.getCreationVersion().before(Version.V_6_0_0_alpha1)) {
            throw new IllegalStateException("source index created version is too old to apply a split operation");
        }
    }

    static void validateCloneIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetaData sourceMetaData = MetaDataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        IndexMetaData.selectCloneShard(0, sourceMetaData, IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
    }

    static IndexMetaData validateResize(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        if (state.metaData().hasIndex(targetIndexName)) {
            throw new ResourceAlreadyExistsException(state.metaData().index(targetIndexName).getIndex());
        }
        IndexMetaData sourceMetaData = state.metaData().index(sourceIndex);
        if (sourceMetaData == null) {
            throw new IndexNotFoundException(sourceIndex);
        }
        if (!state.blocks().indexBlocked(ClusterBlockLevel.WRITE, sourceIndex)) {
            throw new IllegalStateException("index " + sourceIndex + " must be read-only to resize index. use \"index.blocks.write=true\"");
        }
        if (targetIndexMappingsTypes.size() > 1 || !(targetIndexMappingsTypes.isEmpty() || targetIndexMappingsTypes.contains("_default_"))) {
            throw new IllegalArgumentException("mappings are not allowed when resizing indices, all mappings are copied from the source index");
        }
        if (IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            IndexMetaData.getRoutingFactor(sourceMetaData.getNumberOfShards(), IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        }
        return sourceMetaData;
    }

    static void prepareResizeIndexSettings(ClusterState currentState, Set<String> mappingKeys, Settings.Builder indexSettingsBuilder, Index resizeSourceIndex, String resizeIntoName, ResizeType type, boolean copySettings, IndexScopedSettings indexScopedSettings) {
        String initialRecoveryIdFilter = IndexMetaData.INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getKey() + "_id";
        IndexMetaData sourceMetaData = currentState.metaData().index(resizeSourceIndex.getName());
        if (type == ResizeType.SHRINK) {
            List<String> nodesToAllocateOn = MetaDataCreateIndexService.validateShrinkIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.put(initialRecoveryIdFilter, Strings.arrayToCommaDelimitedString(nodesToAllocateOn.toArray()));
        } else if (type == ResizeType.SPLIT) {
            MetaDataCreateIndexService.validateSplitIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.putNull(initialRecoveryIdFilter);
        } else if (type == ResizeType.CLONE) {
            MetaDataCreateIndexService.validateCloneIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.putNull(initialRecoveryIdFilter);
        } else {
            throw new IllegalStateException("unknown resize type is " + (Object)((Object)type));
        }
        Settings.Builder builder = Settings.builder();
        if (copySettings) {
            for (String key : sourceMetaData.getSettings().keySet()) {
                Setting<?> setting = indexScopedSettings.get(key);
                if (setting == null) {
                    assert (indexScopedSettings.isPrivateSetting(key)) : key;
                } else if (setting.getProperties().contains((Object)Setting.Property.NotCopyableOnResize)) continue;
                if (indexSettingsBuilder.keys().contains(key)) continue;
                builder.copy(key, sourceMetaData.getSettings());
            }
        } else {
            Predicate<String> sourceSettingsPredicate = s -> (s.startsWith("index.similarity.") || s.startsWith("index.analysis.") || s.startsWith("index.sort.") || s.equals("index.soft_deletes.enabled")) && !indexSettingsBuilder.keys().contains(s);
            builder.put(sourceMetaData.getSettings().filter(sourceSettingsPredicate));
        }
        indexSettingsBuilder.put(IndexMetaData.SETTING_INDEX_VERSION_CREATED.getKey(), sourceMetaData.getCreationVersion()).put("index.version.upgraded", sourceMetaData.getUpgradedVersion()).put(builder.build()).put("index.routing_partition_size", sourceMetaData.getRoutingPartitionSize()).put(IndexMetaData.INDEX_RESIZE_SOURCE_NAME.getKey(), resizeSourceIndex.getName()).put(IndexMetaData.INDEX_RESIZE_SOURCE_UUID.getKey(), resizeSourceIndex.getUUID());
    }

    public static int calculateNumRoutingShards(int numShards, Version indexVersionCreated) {
        if (indexVersionCreated.onOrAfter(Version.V_7_0_0)) {
            int log2MaxNumShards = 10;
            int log2NumShards = 32 - Integer.numberOfLeadingZeros(numShards - 1);
            int numSplits = log2MaxNumShards - log2NumShards;
            numSplits = Math.max(1, numSplits);
            return numShards * 1 << numSplits;
        }
        return numShards;
    }
}

