/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.MaxAggregator;
import org.elasticsearch.search.aggregations.metrics.MinMaxAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

class MaxAggregatorFactory
extends ValuesSourceAggregatorFactory {
    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("max", Arrays.asList(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), (AggregatorSupplier)new MinMaxAggregatorSupplier(){

            @Override
            public Aggregator build(String name, ValuesSourceConfig config, ValuesSource valuesSource, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
                return new MaxAggregator(name, config, (ValuesSource.Numeric)valuesSource, context, parent, metadata);
            }
        });
    }

    MaxAggregatorFactory(String name, ValuesSourceConfig config, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new MaxAggregator(this.name, this.config, null, searchContext, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "max");
        if (!(aggregatorSupplier instanceof MinMaxAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected MinMaxAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((MinMaxAggregatorSupplier)aggregatorSupplier).build(this.name, this.config, valuesSource, searchContext, parent, metadata);
    }
}

