/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.abstrct;

import java.io.Serializable;
import java.sql.Timestamp;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.propdev.api.abstrct.ProposalAbstractContract;
import org.kuali.coeus.propdev.impl.abstrct.AbstractType;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.util.GlobalVariables;

@Entity
@Table(name="EPS_PROP_ABSTRACT")
@IdClass(value=ProposalAbstractId.class)
public class ProposalAbstract
extends KcPersistableBusinessObjectBase
implements ProposalAbstractContract {
    @Id
    @Column(name="PROPOSAL_NUMBER")
    private String proposalNumber = null;
    @Id
    @Column(name="ABSTRACT_TYPE_CODE")
    private String abstractTypeCode;
    @Column(name="ABSTRACT_DETAILS")
    @Lob
    private String abstractDetails;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="ABSTRACT_TYPE_CODE", referencedColumnName="ABSTRACT_TYPE_CODE", insertable=false, updatable=false)
    private AbstractType abstractType;
    @Column(name="TIMESTAMP_DISPLAY")
    private Timestamp timestampDisplay;
    @Column(name="USER_DISPLAY")
    private String uploadUserDisplay;
    @Transient
    private String uploadUserFullName;
    @Transient
    private transient boolean isUpdated = false;

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public void setUpdated(boolean isUpdated) {
        this.isUpdated = isUpdated;
    }

    public ProposalAbstract() {
        this.setAbstractTypeCode("");
        this.setAbstractDetails("");
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getAbstractTypeCode() {
        return this.abstractTypeCode;
    }

    public void setAbstractTypeCode(String abstractTypeCode) {
        this.abstractTypeCode = abstractTypeCode;
    }

    public String getAbstractDetails() {
        return this.abstractDetails;
    }

    public void setAbstractDetails(String abstractDetails) {
        if (!StringUtils.equals((CharSequence)this.abstractDetails, (CharSequence)abstractDetails)) {
            this.timestampDisplay = null;
            this.uploadUserDisplay = null;
        }
        this.abstractDetails = abstractDetails == null ? "" : abstractDetails;
        this.setUpdateDisplayFields();
    }

    public AbstractType getAbstractType() {
        return this.abstractType;
    }

    public void setAbstractType(AbstractType abstractType) {
        this.abstractType = abstractType;
        this.abstractTypeCode = abstractType != null ? abstractType.getCode() : null;
    }

    public Timestamp getTimestampDisplay() {
        return this.timestampDisplay;
    }

    public void setTimestampDisplay(Timestamp timestampDisplay) {
        this.timestampDisplay = timestampDisplay;
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        this.setUpdateDisplayFields();
    }

    @Override
    protected void preUpdate() {
        super.preUpdate();
        this.setUpdateDisplayFields();
    }

    public void setUpdateDisplayFields() {
        if ((this.uploadUserDisplay == null || this.timestampDisplay == null) && GlobalVariables.getUserSession() != null) {
            String updateUser = GlobalVariables.getUserSession().getPrincipalName();
            if (updateUser.length() > 60) {
                updateUser = updateUser.substring(0, 60);
            }
            this.setUploadUserDisplay(updateUser);
            this.setTimestampDisplay(((DateTimeService)KcServiceLocator.getService("dateTimeService")).getCurrentTimestamp());
        }
    }

    public String getUploadUserDisplay() {
        return this.uploadUserDisplay;
    }

    public void setUploadUserDisplay(String uploadUserDisplay) {
        this.uploadUserDisplay = uploadUserDisplay;
    }

    public String getUploadUserFullName() {
        return this.uploadUserFullName;
    }

    public void setUploadUserFullName(String uploadUserFullName) {
        this.uploadUserFullName = uploadUserFullName;
    }

    public static final class ProposalAbstractId
    implements Serializable,
    Comparable<ProposalAbstractId> {
        private String abstractTypeCode;
        private String proposalNumber;

        public String getAbstractTypeCode() {
            return this.abstractTypeCode;
        }

        public void setAbstractTypeCode(String abstractTypeCode) {
            this.abstractTypeCode = abstractTypeCode;
        }

        public String getProposalNumber() {
            return this.proposalNumber;
        }

        public void setProposalNumber(String proposalNumber) {
            this.proposalNumber = proposalNumber;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("abstractTypeCode", (Object)this.abstractTypeCode).append("proposalNumber", (Object)this.proposalNumber).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            ProposalAbstractId rhs = (ProposalAbstractId)other;
            return new EqualsBuilder().append((Object)this.abstractTypeCode, (Object)rhs.abstractTypeCode).append((Object)this.proposalNumber, (Object)rhs.proposalNumber).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.abstractTypeCode).append((Object)this.proposalNumber).toHashCode();
        }

        @Override
        public int compareTo(ProposalAbstractId other) {
            return new CompareToBuilder().append((Object)this.abstractTypeCode, (Object)other.abstractTypeCode).append((Object)this.proposalNumber, (Object)other.proposalNumber).toComparison();
        }
    }
}

