/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.service;

import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;
import org.kuali.rice.krad.bo.AdHocRouteWorkgroup;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.impl.DocumentAdHocServiceImpl;

public class KcDocumentAdHocServiceImpl
extends DocumentAdHocServiceImpl {
    public void replaceAdHocsForDocument(Document document) {
        boolean remove;
        if (document == null || StringUtils.isBlank((CharSequence)document.getDocumentNumber())) {
            return;
        }
        QueryResults dbAdHocRoutePersons = this.dataObjectService.findMatching(AdHocRoutePerson.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"documentNumber", (Object)document.getDocumentNumber()), PredicateFactory.equal((String)"type", (Object)AdHocRoutePerson.PERSON_TYPE)}));
        QueryResults dbAdHocRouteWorkgroups = this.dataObjectService.findMatching(AdHocRouteWorkgroup.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"documentNumber", (Object)document.getDocumentNumber()), PredicateFactory.equal((String)"type", (Object)AdHocRoutePerson.WORKGROUP_TYPE)}));
        for (AdHocRoutePerson dbAdHocRoutePerson : dbAdHocRoutePersons.getResults()) {
            remove = true;
            if (document.getAdHocRoutePersons() != null) {
                for (AdHocRouteRecipient adHocRouteRecipient : document.getAdHocRoutePersons()) {
                    if (!adHocRouteRecipient.getId().equals(dbAdHocRoutePerson.getId())) continue;
                    remove = false;
                }
            }
            if (!remove) continue;
            this.dataObjectService.delete((Object)dbAdHocRoutePerson);
        }
        for (AdHocRouteWorkgroup dbAdHocRouteWorkgroup : dbAdHocRouteWorkgroups.getResults()) {
            remove = true;
            if (document.getAdHocRouteWorkgroups() != null) {
                for (AdHocRouteRecipient adHocRouteRecipient : document.getAdHocRouteWorkgroups()) {
                    if (!adHocRouteRecipient.getId().equals(dbAdHocRouteWorkgroup.getId())) continue;
                    remove = false;
                }
            }
            if (!remove) continue;
            this.dataObjectService.delete((Object)dbAdHocRouteWorkgroup);
        }
        document.setAdHocRoutePersons(this.saveAdHocRouteRecipients(document.getDocumentNumber(), document.getAdHocRoutePersons()));
        document.getAdHocRoutePersons().forEach(AdHocRoutePerson::getPerson);
        document.setAdHocRouteWorkgroups(this.saveAdHocRouteRecipients(document.getDocumentNumber(), document.getAdHocRouteWorkgroups()));
        document.getAdHocRouteWorkgroups().forEach(adHocRouteWorkgroup -> adHocRouteWorkgroup.setId(adHocRouteWorkgroup.getId()));
    }
}

