/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.scheduling;

import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.coeus.sys.framework.scheduling.ScheduleService;
import org.kuali.coeus.sys.framework.scheduling.expr.CronExpression;
import org.kuali.coeus.sys.framework.scheduling.expr.MonthDayOrLastDayMultipleYearsCronExpression;
import org.kuali.coeus.sys.framework.scheduling.expr.NeverCronExpression;
import org.kuali.coeus.sys.framework.scheduling.seq.DefaultScheduleSequence;
import org.kuali.coeus.sys.framework.scheduling.seq.ScheduleSequence;
import org.kuali.coeus.sys.framework.scheduling.seq.TrimDatesScheduleSequenceDecorator;
import org.kuali.coeus.sys.framework.scheduling.util.Time24HrFmt;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="scheduleService")
@Transactional
public class ScheduleServiceImpl
implements ScheduleService {
    @Override
    public List<Date> getScheduledDates(Date startDate, Date endDate, Time24HrFmt time, ScheduleSequence scheduleSequence) throws ParseException {
        NeverCronExpression expr = new NeverCronExpression(startDate, time);
        return this.getScheduledDates(expr, startDate, endDate, time, scheduleSequence);
    }

    @Override
    public List<Date> getScheduledDates(Date startDate, Date endDate, Time24HrFmt time, ScheduleSequence scheduleSequence, Integer dayOfMonth) throws ParseException {
        MonthDayOrLastDayMultipleYearsCronExpression expr = new MonthDayOrLastDayMultipleYearsCronExpression(startDate, time, dayOfMonth);
        return this.getScheduledDates(expr, startDate, endDate, time, scheduleSequence);
    }

    protected List<Date> getScheduledDates(CronExpression expression, Date startDate, Date endDate, Time24HrFmt time, ScheduleSequence scheduleSequence) throws ParseException {
        scheduleSequence = this.getScheduleSequence(scheduleSequence);
        startDate = this.wrapTime(startDate, null);
        endDate = this.wrapTime(endDate, time);
        return scheduleSequence.executeScheduleSequence(expression.getExpression(), startDate, endDate);
    }

    protected Date wrapTime(Date date, Time24HrFmt time) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int hour = calendar.get(10);
        int min = calendar.get(12);
        int am_pm = calendar.get(9);
        if (am_pm == 0) {
            date = DateUtils.addHours((Date)date, (int)(-hour));
            date = DateUtils.addMinutes((Date)date, (int)(-min));
        } else {
            date = DateUtils.addHours((Date)date, (int)(-hour - 12));
            date = DateUtils.addMinutes((Date)date, (int)(-min));
        }
        if (null != time) {
            date = DateUtils.addHours((Date)date, (int)new Integer(time.getHours()));
            date = DateUtils.addMinutes((Date)date, (int)new Integer(time.getMinutes()));
        }
        return date;
    }

    protected ScheduleSequence getScheduleSequence(ScheduleSequence scheduleSequence) {
        if (null == scheduleSequence) {
            scheduleSequence = new TrimDatesScheduleSequenceDecorator(new DefaultScheduleSequence());
        }
        return scheduleSequence;
    }
}

