/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.subaward;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetControllerBase;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardPeriodDetail;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardsEvent;
import org.kuali.coeus.propdev.impl.budget.subaward.PropDevBudgetSubAwardService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.impl.CollectionControllerServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="proposalBudgetSubAwardController")
@RequestMapping(value={"/proposalBudget"})
public class ProposalBudgetSubAwardController
extends ProposalBudgetControllerBase {
    private static final Logger LOG = LogManager.getLogger(ProposalBudgetSubAwardController.class);
    @Autowired
    @Qualifier(value="propDevBudgetSubAwardService")
    private PropDevBudgetSubAwardService propDevBudgetSubAwardService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="kcAttachmentService")
    private KcAttachmentService kcAttachmentService;

    @Transactional
    @RequestMapping(params={"methodToCall=retrieveEditLineDialog", "actionParameters[selectedCollectionPath]=budget.budgetSubAwards"})
    public ModelAndView showSubawardEditLineDialog(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        BudgetSubAwards budgetSubAward = form.getBudget().getBudgetSubAwards().get(Integer.parseInt(form.getActionParamaterValue("selectedLineIndex")));
        budgetSubAward.getBudgetSubAwardPeriodDetails().iterator();
        budgetSubAward.getBudgetSubAwardFiles().iterator();
        return this.getCollectionControllerService().retrieveEditLineDialog((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=viewSubAwardPdf"})
    public void viewPdf(@RequestParam(value="subAwardNumber") Integer subAwardNumber, @ModelAttribute(value="KualiForm") ProposalBudgetForm form, HttpServletResponse response) {
        BudgetSubAwards subAward = this.getSubAwardByNumber(subAwardNumber, form);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(subAward.getSubAwardXfdFileData());
            KRADUtils.addAttachmentToResponse((HttpServletResponse)response, (InputStream)inputStream, (String)"application/pdf", (String)subAward.getSubAwardXfdFileName(), (long)subAward.getSubAwardXfdFileData().length);
            response.flushBuffer();
        }
        catch (Exception e) {
            LOG.error("Error while downloading attachment");
            throw new RuntimeException("IOException occurred while downloading attachment", e);
        }
    }

    @Transactional
    @RequestMapping(params={"methodToCall=viewSubAwardXml"})
    public void viewXml(@RequestParam(value="subAwardNumber") Integer subAwardNumber, @ModelAttribute(value="KualiForm") ProposalBudgetForm form, HttpServletResponse response) {
        BudgetSubAwards subAward = this.getSubAwardByNumber(subAwardNumber, form);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(subAward.getSubAwardXmlFileData().getBytes());
            KRADUtils.addAttachmentToResponse((HttpServletResponse)response, (InputStream)inputStream, (String)"text/xml", (String)this.createXMLFileName(subAward), (long)subAward.getSubAwardXmlFileData().length());
            response.flushBuffer();
        }
        catch (Exception e) {
            LOG.error("Error while downloading attachment");
            throw new RuntimeException("IOException occurred while downloading attachment", e);
        }
    }

    @Transactional
    @RequestMapping(params={"methodToCall=syncFromPdf"})
    public ModelAndView syncFromPdf(@RequestParam(value="subAwardNumber") Integer subAwardNumber, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        BudgetSubAwards subAward = this.getSubAwardByNumber(subAwardNumber, form);
        this.updateSubAwardBudgetDetails(form.getBudget(), subAward, "PropBudget-SubawardsPage-CollectionGroup");
        form.setDialogDataObject(null);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=removeAttachment"})
    public ModelAndView removeAttachment(@RequestParam(value="subAwardNumber") Integer subAwardNumber, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        BudgetSubAwards subAward = this.getSubAwardByNumber(subAwardNumber, form);
        this.getPropDevBudgetSubAwardService().removeSubAwardAttachment(subAward);
        form.setDialogDataObject(subAward);
        return super.save(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=replaceAttachment"})
    public ModelAndView replaceAttachment(@RequestParam(value="subAwardNumber") Integer subAwardNumber, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        BudgetSubAwards subAward = this.getSubAwardByNumber(subAwardNumber, form);
        BudgetSubAwards dialogSubAward = (BudgetSubAwards)form.getDialogDataObject();
        subAward.setNewSubAwardFile(dialogSubAward.getNewSubAwardFile());
        boolean success = this.getKcBusinessRulesEngine().applyRules(new BudgetSubAwardsEvent(subAward, form.getBudget(), "dialogDataObject"));
        if (success && subAward.getNewSubAwardFile() != null) {
            String fileName = subAward.getNewSubAwardFile().getOriginalFilename();
            try {
                if (!this.getPropDevBudgetSubAwardService().validateSubAwardFileVersion(form.getBudget(), subAward.getNewSubAwardFile().getBytes())) {
                    this.globalVariableService.getMessageMap().putWarning("dialogDataObject.newSubAwardFile", "subAwardFile.s2sVersionMismatch", new String[]{fileName});
                }
                byte[] fileData = subAward.getNewSubAwardFile().getBytes();
                this.updateBudgetAttachment(form.getBudget(), subAward, fileName, fileData, "dialogDataObject");
            }
            catch (Exception e) {
                LOG.warn("Error adding subaward", (Throwable)e);
                this.globalVariableService.getMessageMap().putError("dialogDataObject.newSubAwardFile", "newSubAward.subAwardFile.required", new String[0]);
            }
        }
        form.setDialogDataObject(subAward);
        return super.save(form);
    }

    private String createXMLFileName(BudgetSubAwards subAward) {
        return subAward.getSubAwardXfdFileName().substring(0, subAward.getSubAwardXfdFileName().lastIndexOf(".") + 1) + "xml";
    }

    private BudgetSubAwards getSubAwardByNumber(Integer subAwardNumber, ProposalBudgetForm form) {
        for (BudgetSubAwards subAward : form.getBudget().getBudgetSubAwards()) {
            if (!Objects.equals(subAward.getSubAwardNumber(), subAwardNumber)) continue;
            return subAward;
        }
        return null;
    }

    @Transactional
    @RequestMapping(params={"methodToCall=editLine", "actionParameters[selectedCollectionPath]=budget.budgetSubAwards"})
    public ModelAndView editLine(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        this.getCollectionControllerService().editLine((UifFormBase)form);
        return super.save(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=addLine", "actionParameters[selectedCollectionPath]=budget.budgetSubAwards"})
    public ModelAndView addSubAward(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        CollectionControllerServiceImpl.CollectionActionParameters parameters = new CollectionControllerServiceImpl.CollectionActionParameters((UifFormBase)form, false);
        BindingInfo addLineBindingInfo = (BindingInfo)form.getViewPostMetadata().getComponentPostData(parameters.getSelectedCollectionId(), "addLineBindingInfo");
        BudgetSubAwards newBudgetSubAward = (BudgetSubAwards)ObjectPropertyUtils.getPropertyValue((Object)form, (String)addLineBindingInfo.getBindingPath());
        newBudgetSubAward.setBudget(form.getBudget());
        newBudgetSubAward.setBudgetId(form.getBudget().getBudgetId());
        newBudgetSubAward.setSubAwardNumber(form.getBudget().getNextValue("subAwardNumber"));
        newBudgetSubAward.setBudgetVersionNumber(form.getBudget().getBudgetVersionNumber());
        newBudgetSubAward.setSubAwardStatusCode(1);
        newBudgetSubAward.getBudgetSubAwardPeriodDetails().clear();
        newBudgetSubAward.setOrganization((Organization)this.getDataObjectService().findUnique(Organization.class, QueryByCriteria.Builder.forAttribute((String)"organizationId", (Object)newBudgetSubAward.getOrganizationId()).build()));
        for (BudgetPeriod period : form.getBudget().getBudgetPeriods()) {
            newBudgetSubAward.getBudgetSubAwardPeriodDetails().add(new BudgetSubAwardPeriodDetail(newBudgetSubAward, period));
        }
        boolean success = this.getKcBusinessRulesEngine().applyRules(new BudgetSubAwardsEvent(newBudgetSubAward, form.getBudget(), addLineBindingInfo.getBindingPath()));
        if (success && newBudgetSubAward.getNewSubAwardFile() != null) {
            String fileName = newBudgetSubAward.getNewSubAwardFile().getOriginalFilename();
            if (!this.getPropDevBudgetSubAwardService().validateSubAwardFileVersion(form.getBudget(), newBudgetSubAward.getNewSubAwardFile().getBytes())) {
                this.globalVariableService.getMessageMap().putWarning("PropBudget-SubawardsPage-CollectionGroup", "subAwardFile.s2sVersionMismatch", new String[]{fileName});
            }
            try {
                byte[] fileData = newBudgetSubAward.getNewSubAwardFile().getBytes();
                this.updateBudgetAttachment(form.getBudget(), newBudgetSubAward, fileName, fileData, addLineBindingInfo.getBindingPath());
            }
            catch (Exception e) {
                LOG.warn("Error adding subaward", (Throwable)e);
                success = false;
                this.globalVariableService.getMessageMap().putError(addLineBindingInfo.getBindingPath() + ".newSubAwardFile", "newSubAward.subAwardFile.required", new String[0]);
            }
        }
        if (success) {
            form.getBudget().getBudgetSubAwards().add(newBudgetSubAward);
            ObjectPropertyUtils.setPropertyValue((Object)form, (String)addLineBindingInfo.getBindingPath(), (Object)new BudgetSubAwards());
            return super.save(form);
        }
        form.setUpdateComponentId("PropBudget-SubawardsPage-CollectionGroup-AddDialog");
        BudgetSubAwards newBlankSubAward = new BudgetSubAwards();
        newBlankSubAward.setOrganizationId(newBudgetSubAward.getOrganizationId());
        newBlankSubAward.setOrganization(newBudgetSubAward.getOrganization());
        newBlankSubAward.setComments(newBudgetSubAward.getComments());
        ObjectPropertyUtils.setPropertyValue((Object)form, (String)addLineBindingInfo.getBindingPath(), (Object)newBlankSubAward);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=deleteLine", "actionParameters[selectedCollectionPath]=budget.budgetSubAwards"})
    public ModelAndView deleteLine(@RequestParam(value="actionParameters[lineIndex]") Integer subAwardIndex, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        BudgetSubAwards subAwardToDelete = form.getBudget().getBudgetSubAwards().get(subAwardIndex);
        form.getBudget().getBudgetPeriods().stream().forEach(period -> period.setBudgetLineItems(period.getBudgetLineItems().stream().filter(lineItem -> !subAwardToDelete.getSubAwardNumber().equals(lineItem.getSubAwardNumber())).collect(Collectors.toList())));
        form.setBudget((ProposalDevelopmentBudgetExt)this.getDataObjectService().save((Object)form.getBudget(), new PersistenceOption[0]));
        this.getCollectionControllerService().deleteLine((UifFormBase)form);
        return super.save(form);
    }

    protected void updateBudgetAttachment(Budget budget, BudgetSubAwards subAward, String fileName, byte[] fileData, String errorPath) throws Exception {
        subAward.setSubAwardXmlFileData(null);
        subAward.setFormName(null);
        subAward.setNamespace(null);
        this.getPropDevBudgetSubAwardService().populateBudgetSubAwardFiles(budget, subAward, fileName, fileData);
        if (subAward.getNewSubAwardFile().getContentType().equalsIgnoreCase("application/pdf")) {
            this.updateSubAwardBudgetDetails(budget, subAward, errorPath);
        }
        if (subAward.getSubAwardXmlFileData() != null && this.kcAttachmentService.getSpecialCharacter(subAward.getSubAwardXmlFileData())) {
            this.globalVariableService.getMessageMap().putWarning("PropBudget-SubawardsPage-CollectionGroup", "newSubAward.subAwardFile.special.character", new String[0]);
            subAward.getBudgetSubAwardFiles().get(0).setSubAwardXmlFileData(this.kcAttachmentService.checkAndReplaceSpecialCharacters(subAward.getBudgetSubAwardFiles().get(0).getSubAwardXmlFileData()));
            subAward.setSubAwardXmlFileData(subAward.getBudgetSubAwardFiles().get(0).getSubAwardXmlFileData());
        }
    }

    protected void updateSubAwardBudgetDetails(Budget budget, BudgetSubAwards subAward, String errorPath) throws Exception {
        ArrayList<String[]> errorMessages = new ArrayList<String[]>();
        this.getPropDevBudgetSubAwardService().updateSubAwardBudgetDetails(budget, subAward, errorMessages);
        if (!errorMessages.isEmpty()) {
            for (String[] message : errorMessages) {
                String[] messageParameters = null;
                if (message.length > 1) {
                    messageParameters = Arrays.copyOfRange(message, 1, message.length);
                }
                this.globalVariableService.getMessageMap().putWarning("PropBudget-SubawardsPage-CollectionGroup", message[0], messageParameters);
            }
        }
        if (errorMessages.isEmpty()) {
            this.globalVariableService.getMessageMap().putInfo(errorPath + "newSubAwardFile", "newSubAward.subAwardFile.detailsUpdated", new String[0]);
        }
    }

    public PropDevBudgetSubAwardService getPropDevBudgetSubAwardService() {
        return this.propDevBudgetSubAwardService;
    }

    public void setPropDevBudgetSubAwardService(PropDevBudgetSubAwardService propDevBudgetSubAwardService) {
        this.propDevBudgetSubAwardService = propDevBudgetSubAwardService;
    }

    @Override
    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    @Override
    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public KcAttachmentService getKcAttachmentService() {
        return this.kcAttachmentService;
    }

    public void setKcAttachmentService(KcAttachmentService kcAttachmentService) {
        this.kcAttachmentService = kcAttachmentService;
    }
}

