/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import com.visualcompliance.eim.wcf.rpsmanifoldservice._2010._12.Search;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.common.service.RPSRetrievalService;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectRPSEntitiesBean;
import org.kuali.kra.excon.project.ExconProjectRPSResult;
import org.kuali.kra.excon.project.document.ExconProjectDocument;
import org.kuali.kra.excon.project.web.struts.form.ExconProjectForm;

public class ExconProjectRPSResultsBean
implements Serializable {
    private static final long serialVersionUID = 237567568457L;
    protected ExconProjectRPSResult newRPSResult;
    protected ExconProjectForm exconProjectForm;
    protected int currentResult = 0;
    private transient RPSRetrievalService rpsRetrievalService;

    public ExconProjectRPSResultsBean(ExconProjectForm exconProjectForm) {
        this.exconProjectForm = exconProjectForm;
        this.init();
    }

    public void addExconProjectRPSResult() {
        boolean success = true;
        if (success) {
            this.getExconProject().add(this.getExconProjectRPSResult());
            this.init();
        }
    }

    public void deleteExconProjectRPSResult(int lineToDelete) {
        this.deleteExconProjectRPSResult(this.getExconProjectRPSResults(), lineToDelete);
    }

    public ExconProjectRPSResult getNewRPSResult() {
        return this.newRPSResult;
    }

    public ExconProjectRPSResult getExconProjectRPSResult() {
        return this.newRPSResult;
    }

    public List<ExconProjectRPSResult> getExconProjectRPSResults() {
        return this.getExconProject().getExconProjectRPSResults();
    }

    public int getExconProjectRPSResultsCount() {
        return this.getExconProjectRPSResults().size();
    }

    protected void deleteExconProjectRPSResult(List<ExconProjectRPSResult> results, int lineToDelete) {
        if (results.size() > lineToDelete) {
            ExconProjectRPSResult foundRPSResult = results.get(lineToDelete);
            this.getExconProjectRPSResults().remove(foundRPSResult);
        }
    }

    public Search getRpsResultContentObject() {
        List<ExconProjectRPSResult> results = this.getExconProjectRPSResults();
        if (this.currentResult >= 0 && this.currentResult < results.size()) {
            ExconProjectRPSResult rpsResult = results.get(this.currentResult);
            return this.getRPSRetrievalService().getRpsResults(rpsResult.getRpsResultContent());
        }
        return null;
    }

    public void performRPS(ExconProjectRPSEntitiesBean exconProjectRPSEntitiesBean) {
        String rpsResultXML = this.getRPSRetrievalService().retrieveRpsResults(exconProjectRPSEntitiesBean.getRpsEntity());
        if (!StringUtils.isEmpty((CharSequence)rpsResultXML)) {
            this.newRPSResult.setRpsResultContent(rpsResultXML);
            this.addExconProjectRPSResult();
        }
    }

    public void setCurrentResult(int currentResult) {
        this.currentResult = currentResult;
    }

    public int getCurrentResult() {
        return this.currentResult;
    }

    protected void init() {
        this.newRPSResult = new ExconProjectRPSResult();
    }

    protected ExconProject getExconProject() {
        return this.getDocument().getExconProject();
    }

    protected ExconProjectDocument getDocument() {
        return this.exconProjectForm.getExconProjectDocument();
    }

    protected RPSRetrievalService getRPSRetrievalService() {
        if (this.rpsRetrievalService == null) {
            this.rpsRetrievalService = KcServiceLocator.getServicesOfType(RPSRetrievalService.class).get(0);
        }
        return this.rpsRetrievalService;
    }

    public void setRpsRetrievalService(RPSRetrievalService rpsRetrievalService) {
        this.rpsRetrievalService = rpsRetrievalService;
    }
}

