/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.krms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.krms.KrmsRulesExecutionService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentKRMSAuditRule
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private KrmsRulesExecutionService krmsRulesExecutionService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
        List<Map<String, String>> krmsErrors = this.getKrmsRulesExecutionService().processUnitKcValidations(pdDocument.getDevelopmentProposal().getAllUnitNumbers(), pdDocument);
        for (Map<String, String> error : krmsErrors) {
            valid = false;
            String areaName = error.get("actionArea");
            String sectionName = error.get("actionSection");
            String errorParam = error.get("actionMessage");
            String severity = error.get("actionTypeCode").equals("E") ? "Error" : "Warnings";
            String pageID = error.get("actionNavigateToPageId");
            String sectionId = error.get("actionNavigateToSectionId");
            this.getAuditErrors(areaName, sectionName, severity).add(new AuditError(pageID, "error.generic", pageID + "." + sectionId, new String[]{errorParam}));
        }
        return valid;
    }

    private List<AuditError> getAuditErrors(String areaName, String sectionName, String severity) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String clusterKey = areaName + "." + sectionName;
        if (!GlobalVariables.getAuditErrorMap().containsKey(clusterKey + "." + severity)) {
            GlobalVariables.getAuditErrorMap().put(clusterKey + severity, new AuditCluster(clusterKey, auditErrors, severity));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(clusterKey + "." + severity)).getAuditErrorList();
        }
        return auditErrors;
    }

    public KrmsRulesExecutionService getKrmsRulesExecutionService() {
        if (this.krmsRulesExecutionService == null) {
            this.krmsRulesExecutionService = KcServiceLocator.getService(KrmsRulesExecutionService.class);
        }
        return this.krmsRulesExecutionService;
    }

    public void setKrmsRulesExecutionService(KrmsRulesExecutionService krmsRulesExecutionService) {
        this.krmsRulesExecutionService = krmsRulesExecutionService;
    }
}

