/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.mail.EmailAttachment;
import org.kuali.coeus.common.framework.mail.KcEmailService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectDestination;
import org.kuali.kra.excon.project.ExconProjectEmailContent;
import org.kuali.kra.excon.project.ExconProjectEvent;
import org.kuali.kra.excon.project.ExconProjectPerson;
import org.kuali.kra.excon.project.ExconProjectTravelerCommunication;
import org.kuali.kra.excon.project.document.ExconProjectDocument;
import org.kuali.kra.excon.project.web.struts.form.ExconProjectForm;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExconProjectEmailBean
implements Serializable {
    private static final long serialVersionUID = 238453457L;
    protected ExconProjectEmailContent newBody;
    protected ExconProjectEmailContent newAttachment;
    protected ExconProjectEmailContent newAgenda;
    protected ExconProjectForm exconProjectForm;
    private transient BusinessObjectService businessObjectService;
    private transient KcEmailService kcEmailService;
    private transient RoleService roleService;
    private transient KcPersonService kcPersonService;
    private static final String EXCON_PROJECT_EMAIL_BEAN_NEW_BODY = "exconProjectEmailBean.newBody";
    private static final String ERROR_EXCON_PROJECT_TRAVELER_EMAIL_NO_EMAIL = "error.exconProjectTravelerEmail.noEmail";
    private static final String ERROR_EXCON_PROJECT_TRAVELER_EMAIL_NO_PERSON_EMAIL = "error.exconProjectTravelerEmail.noPersonEmail";
    private static final String PROVIDED_ADVICE = "TVA";

    public ExconProjectEmailBean(ExconProjectForm exconProjectForm) {
        this.exconProjectForm = exconProjectForm;
        this.init();
    }

    public ExconProjectEmailContent getNewBody() {
        return this.newBody;
    }

    public ExconProjectEmailContent getNewAttachment() {
        return this.newAttachment;
    }

    public ExconProjectEmailContent getNewAgenda() {
        return this.newAgenda;
    }

    public ExconProjectEmailContent getBodyObj() {
        HashMap<String, String> criteriaMap = new HashMap<String, String>();
        criteriaMap.put("contentCode", this.newBody.getContentCode());
        return (ExconProjectEmailContent)this.getBusinessObjectService().findByPrimaryKey(ExconProjectEmailContent.class, criteriaMap);
    }

    public ExconProjectEmailContent getAttachmentObj() {
        HashMap<String, String> criteriaMap = new HashMap<String, String>();
        criteriaMap.put("contentCode", this.newAttachment.getContentCode());
        return (ExconProjectEmailContent)this.getBusinessObjectService().findByPrimaryKey(ExconProjectEmailContent.class, criteriaMap);
    }

    public ExconProjectEmailContent getAgendaObj() {
        HashMap<String, String> criteriaMap = new HashMap<String, String>();
        criteriaMap.put("contentCode", this.newAgenda.getContentCode());
        return (ExconProjectEmailContent)this.getBusinessObjectService().findByPrimaryKey(ExconProjectEmailContent.class, criteriaMap);
    }

    public void sendEmail() {
        ExconProject exconProject = this.getExconProject();
        ArrayList<EmailAttachment> attachments = new ArrayList<EmailAttachment>();
        String senderEmail = this.getKcPersonService().getKcPersonByUserName(GlobalVariables.getUserSession().getPrincipalName()).getEmailAddress();
        Optional<ExconProjectPerson> person = exconProject.getPerson();
        if (!person.isPresent()) {
            GlobalVariables.getMessageMap().putError(EXCON_PROJECT_EMAIL_BEAN_NEW_BODY, ERROR_EXCON_PROJECT_TRAVELER_EMAIL_NO_EMAIL, new String[0]);
            return;
        }
        String recipEmail = person.get().getPerson().getEmailAddress();
        if (StringUtils.isBlank((CharSequence)recipEmail)) {
            GlobalVariables.getMessageMap().putError(EXCON_PROJECT_EMAIL_BEAN_NEW_BODY, ERROR_EXCON_PROJECT_TRAVELER_EMAIL_NO_PERSON_EMAIL, new String[0]);
            return;
        }
        HashSet<String> recipSet = new HashSet<String>();
        recipSet.add(recipEmail);
        HashSet<String> bccSet = new HashSet<String>();
        bccSet.add(senderEmail);
        Collection memberIds = this.getRoleService().getRoleMemberPrincipalIds("KC-EXCON", "Export Control Project Coordinator", new HashMap());
        for (String memberId : memberIds) {
            KcPerson memberPerson = this.getKcPersonService().getKcPersonByPersonId(memberId);
            if (!memberPerson.isActive()) continue;
            bccSet.add(memberPerson.getEmailAddress());
        }
        ExconProjectEmailContent bodyContent = this.getBodyObj();
        ExconProjectEmailContent attachmentContent = this.getAttachmentObj();
        if (attachmentContent != null) {
            EmailAttachment attachment = new EmailAttachment();
            attachment.setContents(attachmentContent.getAttachmentContent());
            attachment.setFileName(attachmentContent.getFileName());
            attachment.setMimeType(attachmentContent.getContentType());
            attachments.add(attachment);
        }
        String bodyStr = this.getStringWithReplacement(new String(bodyContent.getAttachmentContent()));
        this.getKcEmailService().sendEmailWithAttachments(senderEmail, recipSet, this.getStringWithReplacement(bodyContent.getSubject()), null, bccSet, bodyStr, true, attachments);
        ExconProjectEvent newEvent = new ExconProjectEvent();
        newEvent.setProjectEventTypeCode(PROVIDED_ADVICE);
        newEvent.setEventComment(bodyContent.getDescription());
        newEvent.setEventDate(new Date(System.currentTimeMillis()));
        exconProject.add(newEvent);
        if (person.isPresent()) {
            ExconProjectTravelerCommunication newCommunication = new ExconProjectTravelerCommunication();
            newCommunication.setEmailBodyContent(bodyContent);
            newCommunication.setEmailBodyContentCode(bodyContent.getContentCodeBody());
            if (attachmentContent != null) {
                newCommunication.setEmailAttachmentContent(attachmentContent);
                newCommunication.setEmailAttachmentContentCode(attachmentContent.getContentCodeAttachment());
            }
            newCommunication.setProjectPersonId(person.get().getProjectPersonId());
            newCommunication.setCommunicationDate(new Date(System.currentTimeMillis()));
            exconProject.getTravelerCommunications().add(newCommunication);
        }
        KNSGlobalVariables.getMessageList().add("info.exconProjectTravelerEmail.sent", new String[]{recipEmail});
    }

    private String getStringWithReplacement(String text) {
        Optional<ExconProjectPerson> person = this.getExconProject().getPerson();
        if (person.isPresent()) {
            ExconProjectPerson exconProjectPerson = person.get();
            text = text.replace("{FIRST_NAME}", exconProjectPerson.getPerson().getFirstName());
            text = text.replace("{LAST_NAME}", exconProjectPerson.getPerson().getLastName());
        }
        text = text.replace("{PROJECT_TYPE}", this.getExconProject().getProjectType().getDescription());
        text = text.replace("{DESTINATION_COUNTRIES}", this.getExconProject().getExconProjectDestinations().stream().map(ExconProjectDestination::getDestinationCountryName).filter(country -> StringUtils.isNotEmpty((CharSequence)country)).collect(Collectors.joining(", ")));
        return text;
    }

    protected void init() {
        this.newBody = new ExconProjectEmailContent();
        this.newAttachment = new ExconProjectEmailContent();
        this.newAgenda = new ExconProjectEmailContent();
    }

    protected ExconProject getExconProject() {
        return this.getDocument().getExconProject();
    }

    protected ExconProjectDocument getDocument() {
        return this.exconProjectForm.getExconProjectDocument();
    }

    public void addMeetingAgenda() {
        ExconProject exconProject = this.getExconProject();
        ExconProjectEmailContent agendaContent = this.getAgendaObj();
        ExconProjectEvent newEvent = new ExconProjectEvent();
        newEvent.setProjectEventTypeCode(PROVIDED_ADVICE);
        newEvent.setEventComment(agendaContent.getDescription());
        newEvent.setEventDate(new Date(System.currentTimeMillis()));
        exconProject.add(newEvent);
        exconProject.getPerson().ifPresent(person -> {
            ExconProjectTravelerCommunication newCommunication = new ExconProjectTravelerCommunication();
            newCommunication.setAgendaContent(agendaContent);
            newCommunication.setAgendaContentCode(agendaContent.getContentCodeBody());
            newCommunication.setProjectPersonId(person.getProjectPersonId());
            newCommunication.setCommunicationDate(new Date(System.currentTimeMillis()));
            exconProject.getTravelerCommunications().add(newCommunication);
        });
        KNSGlobalVariables.getMessageList().add("info.exconProjectTravelerAgenda.added", new String[0]);
    }

    private KcEmailService getKcEmailService() {
        if (this.kcEmailService == null) {
            this.kcEmailService = KcServiceLocator.getService(KcEmailService.class);
        }
        return this.kcEmailService;
    }

    public void setKcEmailService(KcEmailService kcEmailService) {
        this.kcEmailService = kcEmailService;
    }

    private RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = KcServiceLocator.getService(RoleService.class);
        }
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

