/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.lifecycle.RenderComponentPhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhaseBase;
import org.kuali.rice.krad.uif.util.RecycleUtils;

public class FinalizeComponentPhase
extends ViewLifecyclePhaseBase {
    private RenderComponentPhase renderPhase;

    @Override
    public void recycle() {
        super.recycle();
        this.renderPhase = null;
    }

    @Override
    public String getViewPhase() {
        return "FINALIZE";
    }

    @Override
    public String getStartViewStatus() {
        return "M";
    }

    @Override
    public String getEndViewStatus() {
        return "F";
    }

    @Override
    public ViewLifecycle.LifecycleEvent getEventToNotify() {
        return ViewLifecycle.LifecycleEvent.LIFECYCLE_COMPLETE;
    }

    @Override
    protected void verifyCompleted() {
        super.verifyCompleted();
        if (this.renderPhase != null) {
            this.renderPhase.verifyCompleted();
        }
    }

    @Override
    protected void initializeSuccessors(Queue<ViewLifecyclePhase> successors) {
        super.initializeSuccessors(successors);
        if (ViewLifecycle.isRenderInLifecycle()) {
            RenderComponentPhase parentRenderPhase = null;
            ViewLifecyclePhase predecessor = this.getPredecessor();
            if (predecessor instanceof FinalizeComponentPhase) {
                parentRenderPhase = ((FinalizeComponentPhase)predecessor).renderPhase;
            }
            Set pendingChildren = RecycleUtils.getInstance(LinkedHashSet.class);
            for (ViewLifecyclePhase successor : successors) {
                boolean skipSuccessor = successor instanceof ViewLifecyclePhaseBase ? ((ViewLifecyclePhaseBase)successor).shouldSkipLifecycle() : successor.getElement().skipLifecycle();
                if (skipSuccessor || pendingChildren.add(successor.getParentPath())) continue;
                ViewLifecycle.reportIllegalState("Successor is already pending " + pendingChildren + "\n" + successor + "\n" + this);
            }
            this.renderPhase = (RenderComponentPhase)KRADServiceLocatorWeb.getViewLifecyclePhaseBuilder().buildPhase("RENDER", this.getElement(), this.getParent(), this.getParentPath(), this.getRefreshPaths());
            this.renderPhase.prepareRenderPhase(parentRenderPhase, pendingChildren);
            this.trace("create-render " + this.getElement().getId() + " " + pendingChildren);
        }
        if (successors.isEmpty() && this.renderPhase != null) {
            successors.add(this.renderPhase);
        }
    }
}

