/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit;

import java.util.Collections;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.impl.unit.UnitAgenda;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableAttributeLookupSettings;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.krad.lookup.LookupUtils;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.framework.engine.Agenda;
import org.kuali.rice.krms.framework.engine.AgendaTree;
import org.kuali.rice.krms.impl.provider.repository.LazyAgendaTree;
import org.kuali.rice.krms.impl.provider.repository.RepositoryToEngineTranslator;
import org.kuali.rice.krms.impl.type.AgendaTypeServiceBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="unitAgendaTypeService")
public class UnitAgendaTypeServiceImpl
extends AgendaTypeServiceBase {
    public static final String UNIT_NUMBER_CAMEL = "unitNumber";
    public static final String UNIT_NUMBER_LOWER = "unit number";
    @Autowired
    @Qualifier(value="repositoryToEngineTranslator")
    private RepositoryToEngineTranslator repositoryToEngineTranslator;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;

    public RemotableAttributeField translateTypeAttribute(KrmsTypeAttribute inputAttribute, KrmsAttributeDefinition attributeDefinition) {
        if ("Unit Number".equals(attributeDefinition.getName())) {
            return this.createUnitField();
        }
        return super.translateTypeAttribute(inputAttribute, attributeDefinition);
    }

    private RemotableAttributeField createUnitField() {
        String unitClassName = Unit.class.getName();
        String baseLookupUrl = LookupUtils.getBaseLookupUrl();
        RemotableQuickFinder.Builder quickFinderBuilder = RemotableQuickFinder.Builder.create((String)baseLookupUrl, (String)unitClassName);
        quickFinderBuilder.setLookupParameters(Collections.singletonMap("Unit Number", UNIT_NUMBER_CAMEL));
        quickFinderBuilder.setFieldConversions(Collections.singletonMap(UNIT_NUMBER_CAMEL, "Unit Number"));
        RemotableTextInput.Builder controlBuilder = RemotableTextInput.Builder.create();
        controlBuilder.setSize(Integer.valueOf(30));
        controlBuilder = RemotableTextInput.Builder.create();
        controlBuilder.setSize(Integer.valueOf(40));
        controlBuilder.setWatermark(UNIT_NUMBER_LOWER);
        RemotableAttributeLookupSettings.Builder lookupSettingsBuilder = RemotableAttributeLookupSettings.Builder.create();
        lookupSettingsBuilder.setCaseSensitive(Boolean.TRUE);
        lookupSettingsBuilder.setInCriteria(true);
        lookupSettingsBuilder.setInResults(true);
        lookupSettingsBuilder.setRanged(false);
        RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)"Unit Number");
        builder.setAttributeLookupSettings(lookupSettingsBuilder);
        builder.setName("Unit Number");
        builder.setRequired(true);
        builder.setDataType(DataType.STRING);
        builder.setControl((RemotableAbstractControl.Builder)controlBuilder);
        builder.setLongLabel("Unit Number");
        builder.setShortLabel("Unit Number");
        builder.setMinLength(Integer.valueOf(1));
        builder.setMaxLength(Integer.valueOf(40));
        builder.setWidgets(Collections.singletonList(quickFinderBuilder));
        return builder.build();
    }

    public Agenda loadAgenda(AgendaDefinition agendaDefinition) {
        if (agendaDefinition == null) {
            throw new RiceIllegalArgumentException("agendaDefinition must not be null");
        }
        if (this.repositoryToEngineTranslator == null) {
            return null;
        }
        UnitAgenda unitAgenda = new UnitAgenda(agendaDefinition.getAttributes(), (AgendaTree)new LazyAgendaTree(agendaDefinition, this.repositoryToEngineTranslator), agendaDefinition.getTypeId(), agendaDefinition.isActive());
        unitAgenda.setUnitService(this.getUnitService());
        return unitAgenda;
    }

    public RepositoryToEngineTranslator getRepositoryToEngineTranslator() {
        return this.repositoryToEngineTranslator;
    }

    public void setRepositoryToEngineTranslator(RepositoryToEngineTranslator repositoryToEngineTranslator) {
        this.repositoryToEngineTranslator = repositoryToEngineTranslator;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }
}

