/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jws.WebParam;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.document.DocumentLink;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.DocumentStatusTransition;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.dto.DTOConverter;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValueContent;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class WorkflowDocumentServiceImpl
implements WorkflowDocumentService {
    private static final Logger LOG = LogManager.getLogger(WorkflowDocumentServiceImpl.class);

    public Document getDocument(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        DocumentRouteHeaderValue documentBo = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        return DocumentRouteHeaderValue.to(documentBo);
    }

    public boolean doesDocumentExist(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        DocumentRouteHeaderValue documentBo = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        return documentBo != null;
    }

    public String getDocumentTypeName(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByDocumentId(documentId);
        if (documentType == null) {
            throw new RiceIllegalArgumentException("Failed to determine document type name for document with id " + documentId + ". Perhaps document does not exist?");
        }
        return documentType.getName();
    }

    public DocumentDetail getDocumentDetailByAppId(String documentTypeName, String appId) {
        if (StringUtils.isEmpty((String)documentTypeName)) {
            throw new RiceIllegalArgumentException("documentTypeName was blank or null");
        }
        if (StringUtils.isEmpty((String)appId)) {
            throw new RiceIllegalArgumentException("appId was blank or null");
        }
        Collection documentIds = KEWServiceLocator.getRouteHeaderService().findByDocTypeAndAppId(documentTypeName, appId);
        if (documentIds == null || documentIds.isEmpty()) {
            throw new RiceIllegalStateException("No RouteHeader Ids found for documentTypName: " + documentTypeName + ", appId: " + appId);
        }
        if (documentIds.size() > 1) {
            throw new RiceIllegalStateException("Multiple RouteHeader Ids found for documentTypName: " + documentTypeName + ", appId: " + appId);
        }
        return this.getDocumentDetail((String)documentIds.iterator().next());
    }

    public RouteNodeInstance getRouteNodeInstance(String nodeInstanceId) {
        if (StringUtils.isEmpty((String)nodeInstanceId)) {
            throw new RiceIllegalArgumentException("nodeInstanceId was blank or null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching RouteNodeInstanceVO [id=" + nodeInstanceId + "]");
        }
        org.kuali.rice.kew.engine.node.RouteNodeInstance nodeInstance = KEWServiceLocator.getRouteNodeService().findRouteNodeInstanceById(nodeInstanceId);
        return org.kuali.rice.kew.engine.node.RouteNodeInstance.to(nodeInstance);
    }

    public DocumentStatus getDocumentStatus(String documentId) {
        if (StringUtils.isEmpty((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        String documentStatus = KEWServiceLocator.getRouteHeaderService().getDocumentStatus(documentId);
        if (StringUtils.isEmpty((String)documentStatus)) {
            throw new RiceIllegalStateException("DocumentStatus not found for documentId: " + documentId);
        }
        return DocumentStatus.fromCode((String)documentStatus);
    }

    public String getApplicationDocumentId(String documentId) {
        if (StringUtils.isEmpty((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        return KEWServiceLocator.getRouteHeaderService().getAppDocId(documentId);
    }

    public String getApplicationDocumentStatus(String documentId) throws RiceIllegalArgumentException {
        if (StringUtils.isEmpty((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        return KEWServiceLocator.getRouteHeaderService().getAppDocStatus(documentId);
    }

    public DocumentSearchResults documentSearch(String principalId, DocumentSearchCriteria criteria) {
        if (criteria == null) {
            throw new RiceIllegalArgumentException("criteria was null");
        }
        return KEWServiceLocator.getDocumentSearchService().lookupDocuments(principalId, criteria);
    }

    public DocumentSearchResults documentSearchSaveable(String principalId, DocumentSearchCriteria criteria, boolean saveSearch) {
        if (criteria == null) {
            throw new RiceIllegalArgumentException("criteria was null");
        }
        return KEWServiceLocator.getDocumentSearchService().lookupDocuments(principalId, criteria, saveSearch);
    }

    public List<String> getSearchableAttributeStringValuesByKey(String documentId, String key) {
        if (StringUtils.isEmpty((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new RiceIllegalArgumentException("key was blank or null");
        }
        return KEWServiceLocator.getRouteHeaderService().getSearchableAttributeStringValuesByKey(documentId, key);
    }

    public List<DateTime> getSearchableAttributeDateTimeValuesByKey(String documentId, String key) {
        if (StringUtils.isEmpty((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new RiceIllegalArgumentException("key was blank or null");
        }
        List<Timestamp> results = KEWServiceLocator.getRouteHeaderService().getSearchableAttributeDateTimeValuesByKey(documentId, key);
        if (results == null) {
            return null;
        }
        ArrayList<DateTime> dateTimes = new ArrayList<DateTime>();
        for (Timestamp time : results) {
            dateTimes.add(new DateTime(time.getTime()));
        }
        return dateTimes;
    }

    public List<BigDecimal> getSearchableAttributeFloatValuesByKey(String documentId, String key) {
        if (StringUtils.isEmpty((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new RiceIllegalArgumentException("key was blank or null");
        }
        return KEWServiceLocator.getRouteHeaderService().getSearchableAttributeFloatValuesByKey(documentId, key);
    }

    public List<Long> getSearchableAttributeLongValuesByKey(String documentId, String key) {
        if (StringUtils.isEmpty((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new RiceIllegalArgumentException("key was blank or null");
        }
        return KEWServiceLocator.getRouteHeaderService().getSearchableAttributeLongValuesByKey(documentId, key);
    }

    public DocumentContent getDocumentContent(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        DocumentRouteHeaderValueContent content = KEWServiceLocator.getRouteHeaderService().getContent(documentId);
        return DocumentRouteHeaderValueContent.to(content);
    }

    public List<ActionRequest> getRootActionRequests(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        ArrayList<ActionRequest> actionRequests = new ArrayList<ActionRequest>();
        List<ActionRequestValue> actionRequestBos = KEWServiceLocator.getActionRequestService().findAllRootActionRequestsByDocumentId(documentId);
        for (ActionRequestValue actionRequestBo : actionRequestBos) {
            actionRequests.add(ActionRequestValue.to(actionRequestBo));
        }
        return Collections.unmodifiableList(actionRequests);
    }

    public List<ActionRequest> getPendingActionRequests(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        ArrayList<ActionRequest> actionRequests = new ArrayList<ActionRequest>();
        List<ActionRequestValue> actionRequestBos = KEWServiceLocator.getActionRequestService().findAllPendingRequests(documentId);
        for (ActionRequestValue actionRequestBo : actionRequestBos) {
            actionRequests.add(ActionRequestValue.to(actionRequestBo));
        }
        return Collections.unmodifiableList(actionRequests);
    }

    public List<ActionRequest> getActionRequestsForPrincipalAtNode(String documentId, String nodeName, String principalId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching ActionRequests [docId=" + documentId + ", nodeName=" + nodeName + ", principalId=" + principalId + "]");
        }
        List<ActionRequestValue> actionRequestBos = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(documentId);
        ArrayList<ActionRequestValue> matchingActionRequests = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue actionRequestValue : actionRequestBos) {
            if (!this.actionRequestMatches(actionRequestValue, nodeName, principalId)) continue;
            matchingActionRequests.add(actionRequestValue);
        }
        ArrayList<ActionRequest> actionRequests = new ArrayList<ActionRequest>(matchingActionRequests.size());
        for (ActionRequestValue matchingActionRequest : matchingActionRequests) {
            actionRequests.add(ActionRequestValue.to(matchingActionRequest));
        }
        return actionRequests;
    }

    protected boolean actionRequestMatches(ActionRequestValue actionRequest, String nodeName, String principalId) {
        boolean matchesUserId = true;
        boolean matchesNodeName = true;
        if (StringUtils.isNotBlank((String)nodeName)) {
            matchesNodeName = nodeName.equals(actionRequest.getPotentialNodeName());
        }
        if (principalId != null) {
            matchesUserId = actionRequest.isRecipientRoutedRequest(principalId);
        }
        return matchesNodeName && matchesUserId;
    }

    public List<ActionTaken> getActionsTaken(String documentId) {
        if (StringUtils.isEmpty((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId is null or empty.");
        }
        ArrayList<ActionTaken> actionTakens = new ArrayList<ActionTaken>();
        Collection<ActionTakenValue> actionTakenBos = KEWServiceLocator.getActionTakenService().findByDocumentId(documentId);
        for (ActionTakenValue actionTakenBo : actionTakenBos) {
            actionTakens.add(ActionTakenValue.to(actionTakenBo));
        }
        return actionTakens;
    }

    public List<ActionTaken> _getActionsTaken(String documentId) {
        return this.getActionsTaken(documentId);
    }

    public List<ActionTaken> getAllActionsTaken(String documentId) {
        if (StringUtils.isEmpty((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId is null or empty.");
        }
        ArrayList<ActionTaken> actionsTaken = new ArrayList<ActionTaken>();
        List<ActionTakenValue> actionTakenBos = KEWServiceLocator.getActionTakenService().findByDocumentIdIgnoreCurrentInd(documentId);
        for (ActionTakenValue actionTakenBo : actionTakenBos) {
            actionsTaken.add(ActionTakenValue.to(actionTakenBo));
        }
        return actionsTaken;
    }

    public DocumentDetail getDocumentDetail(@WebParam(name="documentId") String documentId) {
        DocumentRouteHeaderValue document;
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching DocumentDetail [id=" + documentId + "]");
        }
        if ((document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId)) == null) {
            return null;
        }
        DocumentDetail documentDetailVO = DTOConverter.convertDocumentDetailNew(document);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning DocumentDetailVO [id=" + documentId + "]");
        }
        return documentDetailVO;
    }

    public List<DocumentStatusTransition> getDocumentStatusTransitionHistory(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching document status transition history [id=" + documentId + "]");
        }
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        List<org.kuali.rice.kew.routeheader.DocumentStatusTransition> list = document.getAppDocStatusHistory();
        ArrayList<DocumentStatusTransition> transitionHistory = new ArrayList<DocumentStatusTransition>(list.size());
        for (org.kuali.rice.kew.routeheader.DocumentStatusTransition transition : list) {
            transitionHistory.add(org.kuali.rice.kew.routeheader.DocumentStatusTransition.to(transition));
        }
        return transitionHistory;
    }

    public List<RouteNodeInstance> getRouteNodeInstances(String documentId) {
        DocumentRouteHeaderValue documentBo;
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching RouteNodeInstances [documentId=" + documentId + "]");
        }
        if ((documentBo = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId)) == null) {
            return Collections.emptyList();
        }
        return this.convertRouteNodeInstances(KEWServiceLocator.getRouteNodeService().getFlattenedNodeInstances(documentBo, true));
    }

    public List<RouteNodeInstance> getActiveRouteNodeInstances(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching active RouteNodeInstances [documentId=" + documentId + "]");
        }
        return this.convertRouteNodeInstances(KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(documentId));
    }

    public List<RouteNodeInstance> getTerminalRouteNodeInstances(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching terminal RouteNodeInstanceVOs [docId=" + documentId + "]");
        }
        return this.convertRouteNodeInstances(KEWServiceLocator.getRouteNodeService().getTerminalNodeInstances(documentId));
    }

    public List<RouteNodeInstance> getCurrentRouteNodeInstances(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching current RouteNodeInstanceVOs [docId=" + documentId + "]");
        }
        return this.convertRouteNodeInstances(KEWServiceLocator.getRouteNodeService().getCurrentNodeInstances(documentId));
    }

    public List<String> getActiveRouteNodeNames(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        List<String> nodes = KEWServiceLocator.getRouteNodeService().getActiveRouteNodeNames(documentId);
        return nodes != null ? Collections.unmodifiableList(nodes) : Collections.emptyList();
    }

    public List<String> getActiveSimpleRouteNodeNames(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        List<String> nodes = KEWServiceLocator.getRouteNodeService().getActiveSimpleRouteNodeNames(documentId);
        return nodes != null ? Collections.unmodifiableList(nodes) : Collections.emptyList();
    }

    public List<String> getTerminalRouteNodeNames(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        List<String> nodes = KEWServiceLocator.getRouteNodeService().getTerminalRouteNodeNames(documentId);
        return nodes != null ? Collections.unmodifiableList(nodes) : Collections.emptyList();
    }

    public List<String> getCurrentRouteNodeNames(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        List<String> nodes = KEWServiceLocator.getRouteNodeService().getCurrentRouteNodeNames(documentId);
        return nodes != null ? Collections.unmodifiableList(nodes) : Collections.emptyList();
    }

    public List<String> getCurrentSimpleRouteNodeNames(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        List<String> nodes = KEWServiceLocator.getRouteNodeService().getCurrentSimpleRouteNodeNames(documentId);
        return nodes != null ? Collections.unmodifiableList(nodes) : Collections.emptyList();
    }

    private List<RouteNodeInstance> convertRouteNodeInstances(List<org.kuali.rice.kew.engine.node.RouteNodeInstance> routeNodeInstanceBos) {
        ArrayList<RouteNodeInstance> routeNodeInstances = new ArrayList<RouteNodeInstance>();
        for (org.kuali.rice.kew.engine.node.RouteNodeInstance routeNodeInstanceBo : routeNodeInstanceBos) {
            routeNodeInstances.add(org.kuali.rice.kew.engine.node.RouteNodeInstance.to(routeNodeInstanceBo));
        }
        return Collections.unmodifiableList(routeNodeInstances);
    }

    public List<String> getPreviousRouteNodeNames(String documentId) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was null or blank");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching previous node names [documentId=" + documentId + "]");
        }
        return new ArrayList<String>(KEWServiceLocator.getRouteNodeService().findPreviousNodeNames(documentId));
    }

    public List<String> getPrincipalIdsWithPendingActionRequestByActionRequestedAndDocId(String actionRequestedCd, String documentId) {
        if (StringUtils.isEmpty((String)actionRequestedCd)) {
            throw new RiceIllegalArgumentException("actionRequestCd was blank or null");
        }
        if (StringUtils.isEmpty((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        return KEWServiceLocator.getActionRequestService().getPrincipalIdsWithPendingActionRequestByActionRequestedAndDocId(actionRequestedCd, documentId);
    }

    public String getDocumentInitiatorPrincipalId(String documentId) {
        if (StringUtils.isEmpty((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        DocumentRouteHeaderValue header = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId, false);
        if (header == null) {
            return null;
        }
        return header.getInitiatorWorkflowId();
    }

    public String getRoutedByPrincipalIdByDocumentId(String documentId) {
        if (StringUtils.isEmpty((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was blank or null");
        }
        DocumentRouteHeaderValue header = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId, false);
        if (header == null) {
            return null;
        }
        return header.getRoutedByUserWorkflowId();
    }

    public DocumentLink addDocumentLink(DocumentLink documentLink) throws RiceIllegalArgumentException {
        if (documentLink == null) {
            throw new RiceIllegalArgumentException("documentLink was null");
        }
        if (documentLink.getId() != null) {
            throw new RiceIllegalArgumentException("the given documentLink already has an id, cannot add a document link with an existing id");
        }
        org.kuali.rice.kew.documentlink.DocumentLink documentLinkBo = org.kuali.rice.kew.documentlink.DocumentLink.from(documentLink);
        documentLinkBo = KEWServiceLocator.getDocumentLinkService().saveDocumentLink(documentLinkBo);
        return org.kuali.rice.kew.documentlink.DocumentLink.to(documentLinkBo);
    }

    public DocumentLink deleteDocumentLink(String documentLinkId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)documentLinkId)) {
            throw new RiceIllegalArgumentException("documentLinkId was null or blank");
        }
        org.kuali.rice.kew.documentlink.DocumentLink documentLinkBo = KEWServiceLocator.getDocumentLinkService().getDocumentLink(documentLinkId);
        if (documentLinkBo == null) {
            throw new RiceIllegalStateException("Failed to locate document link with the given documentLinkId: " + documentLinkId);
        }
        KEWServiceLocator.getDocumentLinkService().deleteDocumentLink(documentLinkBo);
        return org.kuali.rice.kew.documentlink.DocumentLink.to(documentLinkBo);
    }

    public List<DocumentLink> deleteDocumentLinksByDocumentId(String originatingDocumentId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)originatingDocumentId)) {
            throw new RiceIllegalArgumentException("originatingDocumentId was null or blank");
        }
        List<org.kuali.rice.kew.documentlink.DocumentLink> documentLinkBos = KEWServiceLocator.getDocumentLinkService().getLinkedDocumentsByDocId(originatingDocumentId);
        if (documentLinkBos == null || documentLinkBos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DocumentLink> deletedDocumentLinks = new ArrayList<DocumentLink>();
        for (org.kuali.rice.kew.documentlink.DocumentLink documentLinkBo : documentLinkBos) {
            deletedDocumentLinks.add(org.kuali.rice.kew.documentlink.DocumentLink.to(documentLinkBo));
            KEWServiceLocator.getDocumentLinkService().deleteDocumentLink(documentLinkBo);
        }
        return Collections.unmodifiableList(deletedDocumentLinks);
    }

    public List<DocumentLink> getOutgoingDocumentLinks(String originatingDocumentId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)originatingDocumentId)) {
            throw new RiceIllegalArgumentException("originatingDocumentId was null or blank");
        }
        List<org.kuali.rice.kew.documentlink.DocumentLink> outgoingDocumentLinkBos = KEWServiceLocator.getDocumentLinkService().getLinkedDocumentsByDocId(originatingDocumentId);
        ArrayList<DocumentLink> outgoingDocumentLinks = new ArrayList<DocumentLink>();
        for (org.kuali.rice.kew.documentlink.DocumentLink outgoingDocumentLinkBo : outgoingDocumentLinkBos) {
            outgoingDocumentLinks.add(org.kuali.rice.kew.documentlink.DocumentLink.to(outgoingDocumentLinkBo));
        }
        return Collections.unmodifiableList(outgoingDocumentLinks);
    }

    public List<DocumentLink> getIncomingDocumentLinks(String destinationDocumentId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)destinationDocumentId)) {
            throw new RiceIllegalArgumentException("destinationDocumentId was null or blank");
        }
        List<org.kuali.rice.kew.documentlink.DocumentLink> incomingDocumentLinkBos = KEWServiceLocator.getDocumentLinkService().getOutgoingLinkedDocumentsByDocId(destinationDocumentId);
        ArrayList<DocumentLink> incomingDocumentLinks = new ArrayList<DocumentLink>();
        for (org.kuali.rice.kew.documentlink.DocumentLink incomingDocumentLinkBo : incomingDocumentLinkBos) {
            incomingDocumentLinks.add(org.kuali.rice.kew.documentlink.DocumentLink.to(incomingDocumentLinkBo));
        }
        return Collections.unmodifiableList(incomingDocumentLinks);
    }

    public DocumentLink getDocumentLink(String documentLinkId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)documentLinkId)) {
            throw new RiceIllegalArgumentException("documentLinkId was null or blank");
        }
        org.kuali.rice.kew.documentlink.DocumentLink documentLinkBo = KEWServiceLocator.getDocumentLinkService().getDocumentLink(documentLinkId);
        return org.kuali.rice.kew.documentlink.DocumentLink.to(documentLinkBo);
    }
}

