/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdevrest.impl.s2s.map;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.s2s.map.Project;
import org.kuali.coeus.propdev.impl.s2s.map.S2sMappingService;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api/v1"})
@Controller(value="s2sMappingController")
public class S2sMappingController
extends RestController {
    private static final String PROJECT_NOT_FOUND = "Project with project id %s not found.";
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="globalVariableService")
    protected GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="s2sMappingService")
    private S2sMappingService s2sMappingService;

    @RequestMapping(method={RequestMethod.GET}, value={"/projects/{projectId}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    Project getProject(@PathVariable String projectId) {
        Document document;
        if (StringUtils.isBlank((CharSequence)projectId)) {
            throw new ResourceNotFoundException(String.format(PROJECT_NOT_FOUND, projectId));
        }
        this.assertUserHasReadAccess();
        try {
            document = this.documentService.getByDocumentHeaderId(projectId);
        }
        catch (WorkflowException e) {
            throw new ResourceNotFoundException(String.format(PROJECT_NOT_FOUND, projectId), e);
        }
        if (!(document instanceof ProposalDevelopmentDocument)) {
            throw new ResourceNotFoundException(String.format(PROJECT_NOT_FOUND, projectId));
        }
        return this.s2sMappingService.toProject((ProposalDevelopmentDocument)document);
    }

    protected void assertUserHasReadAccess() {
        if (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", Project.class.getName()))) {
            throw new UnauthorizedAccessException();
        }
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public S2sMappingService getS2sMappingService() {
        return this.s2sMappingService;
    }

    public void setS2sMappingService(S2sMappingService s2sMappingService) {
        this.s2sMappingService = s2sMappingService;
    }
}

