/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.auth;

import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.auth.AuthUser;
import org.kuali.coeus.sys.framework.auth.CoreGroupsService;
import org.kuali.coeus.sys.framework.auth.CoreUserPushService;
import org.kuali.coeus.sys.framework.auth.CoreUsersPushStatus;
import org.kuali.coeus.sys.framework.auth.GroupDto;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.kuali.coeus.sys.impl.core.CoreServicesUtil;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

public abstract class AbstractCoreUserPushService<T>
implements CoreUserPushService {
    private static final String INCLUDE_INACTIVE_PARAM = "includeInactive";
    private static final Logger LOG = LogManager.getLogger(AbstractCoreUserPushService.class);
    private static final String AUTH_USER_PUSH_USE_DEV_PASSWORD = "auth.user.push.use.dev.password";
    private static final String AUTH_USER_PUSH_DEV_PASSWORD = "auth.user.push.dev.password";
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="coreGroupsService")
    private CoreGroupsService coreGroupsService;
    @Autowired
    @Qualifier(value="coreServicesUtil")
    private CoreServicesUtil coreServicesUtil;

    protected abstract List<T> getAllPeople();

    protected abstract AuthUser generateAuthUserFromPerson(T var1, Map<String, String> var2);

    protected abstract boolean validUserToPush(T var1);

    @Override
    public CoreUsersPushStatus pushAllUsers() {
        return this.pushAllUsers(() -> true);
    }

    @Override
    public CoreUsersPushStatus pushAllUsers(Supplier<Boolean> shouldContinueRunning) {
        CoreUsersPushStatus status = new CoreUsersPushStatus();
        Map<String, String> groupIdByUnitNumber = this.coreGroupsService.getAllGroups().stream().filter(g -> StringUtils.isNotBlank((CharSequence)this.coreGroupsService.getUnitNumberForGroup((GroupDto)g))).collect(Collectors.toMap(g -> this.coreGroupsService.getUnitNumberForGroup((GroupDto)g), GroupDto::getId));
        List peopleToSync = this.getAllPeople().stream().filter(this::validUserToPush).map(person -> this.generateAuthUserFromPerson(person, groupIdByUnitNumber)).collect(Collectors.toList());
        status.setNumberOfUsers(peopleToSync.size());
        Map authPersonMap = this.getAllAuthServiceUsers().stream().collect(Collectors.toMap(AuthUser::getSchoolId, Function.identity(), (v1, v2) -> v1));
        for (AuthUser person2 : peopleToSync) {
            String message;
            if (!shouldContinueRunning.get().booleanValue()) break;
            AuthUser authServicePerson = (AuthUser)authPersonMap.get(person2.getSchoolId());
            try {
                if (person2.isActive()) {
                    if (authServicePerson == null) {
                        this.addUserToAuthService(person2, this.getOrGenerateUserPassword(person2));
                        status.addNumberAdded();
                        continue;
                    }
                    if (authServicePerson.equals(person2)) {
                        status.addNumberSame();
                        continue;
                    }
                    person2.setRole(authServicePerson.getRole());
                    this.updateUserInAuthService(person2, authServicePerson.getId());
                    status.addNumberUpdated();
                    continue;
                }
                if (authServicePerson == null) continue;
                this.disableUserInAuthService(authServicePerson);
                status.addNumberRemoved();
            }
            catch (HttpClientErrorException | HttpServerErrorException e) {
                message = "Error pushing user " + person2.getUsername() + ":" + person2.getSchoolId() + " to auth service - " + e.getMessage() + " -- " + e.getResponseBodyAsString();
                status.getErrors().put(person2.getSchoolId(), message);
                LOG.error(message);
            }
            catch (Exception e) {
                message = "Error pushing user " + person2.getUsername() + ":" + person2.getSchoolId() + " to auth service";
                status.getErrors().put(person2.getSchoolId(), message);
                LOG.error(message, (Throwable)e);
            }
        }
        StringWriter infoMsg = new StringWriter();
        infoMsg.append("Auth Service Bulk Push: Users Found: ").append(Integer.valueOf(status.getNumberOfUsers()).toString()).append(", Users Added: ").append(Integer.valueOf(status.getNumberAdded()).toString()).append(", Users Updated: ").append(Integer.valueOf(status.getNumberUpdated()).toString()).append(", Users Deleted: ").append(Integer.valueOf(status.getNumberRemoved()).toString()).append(", Users Errored: ").append(Integer.valueOf(status.getErrors().size()).toString());
        LOG.info(infoMsg.toString());
        return status;
    }

    protected String getOrGenerateUserPassword(AuthUser person) {
        if (this.useDevPassword()) {
            return this.getDevPassword();
        }
        return UUID.randomUUID().toString();
    }

    protected boolean useDevPassword() {
        return this.configurationService.getPropertyValueAsBoolean(AUTH_USER_PUSH_USE_DEV_PASSWORD);
    }

    protected String getDevPassword() {
        return this.configurationService.getPropertyValueAsString(AUTH_USER_PUSH_DEV_PASSWORD);
    }

    public List<AuthUser> getAllAuthServiceUsers() {
        return this.getCoreServicesUtil().getAll(this.getUsersApiUrl(), Collections.singletonMap(INCLUDE_INACTIVE_PARAM, Boolean.TRUE), new ParameterizedTypeReference<List<AuthUser>>(){});
    }

    protected void addUserToAuthService(AuthUser newUser, String userPassword) {
        newUser.setPassword(userPassword);
        ResponseEntity result = this.restOperations.exchange(this.getUsersApiUrl(), HttpMethod.POST, new HttpEntity((Object)newUser, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), String.class, new Object[0]);
        if (result.getStatusCode() != HttpStatus.CREATED) {
            throw new RestClientException((String)result.getBody());
        }
    }

    protected void updateUserInAuthService(AuthUser updatedUser, String userId) {
        ResponseEntity result = this.restOperations.exchange(this.getUsersApiUrl() + userId, HttpMethod.PUT, new HttpEntity((Object)updatedUser, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), String.class, new Object[0]);
        if (result.getStatusCode() != HttpStatus.OK) {
            throw new RestClientException((String)result.getBody());
        }
    }

    protected void disableUserInAuthService(AuthUser disabledUser) {
        disabledUser.setActive(false);
        ResponseEntity result = this.restOperations.exchange(this.getUsersApiUrl() + disabledUser.getId(), HttpMethod.PUT, new HttpEntity((Object)disabledUser, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), String.class, new Object[0]);
        if (result.getStatusCode() != HttpStatus.OK) {
            throw new RestClientException((String)result.getBody());
        }
    }

    protected String getUsersApiUrl() {
        return this.configurationService.getPropertyValueAsString("auth.users.url") + "/";
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public CoreGroupsService getCoreGroupsService() {
        return this.coreGroupsService;
    }

    public void setCoreGroupsService(CoreGroupsService coreGroupsService) {
        this.coreGroupsService = coreGroupsService;
    }

    public CoreServicesUtil getCoreServicesUtil() {
        return this.coreServicesUtil;
    }

    public void setCoreServicesUtil(CoreServicesUtil coreServicesUtil) {
        this.coreServicesUtil = coreServicesUtil;
    }
}

