/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.ingest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.elasticsearch.action.ingest.SimulatePipelineResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestSimulatePipelineAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_ingest/pipeline/{id}/_simulate"), new RestHandler.Route(RestRequest.Method.POST, "/_ingest/pipeline/{id}/_simulate"), new RestHandler.Route(RestRequest.Method.GET, "/_ingest/pipeline/_simulate"), new RestHandler.Route(RestRequest.Method.POST, "/_ingest/pipeline/_simulate")));
    }

    @Override
    public String getName() {
        return "ingest_simulate_pipeline_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        Tuple<XContentType, BytesReference> sourceTuple = restRequest.contentOrSourceParam();
        SimulatePipelineRequest request = new SimulatePipelineRequest((BytesReference)sourceTuple.v2(), (XContentType)sourceTuple.v1());
        request.setId(restRequest.param("id"));
        request.setVerbose(restRequest.paramAsBoolean("verbose", false));
        return channel -> client.admin().cluster().simulatePipeline(request, new RestToXContentListener<SimulatePipelineResponse>((RestChannel)channel));
    }
}

