/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kew.doctype.DocumentTypePolicyId;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.converters.Boolean01BigDecimalConverter;

@Entity
@IdClass(value=DocumentTypePolicyId.class)
@Table(name="KREW_DOC_TYP_PLCY_RELN_T")
public class DocumentTypePolicy
extends PersistableBusinessObjectBase
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = -4612246888683336474L;
    @Transient
    private String documentTypeId;
    @Id
    @Column(name="DOC_PLCY_NM", nullable=false)
    private String policyName;
    @Column(name="PLCY_NM", nullable=false)
    @Convert(converter=Boolean01BigDecimalConverter.class)
    private Boolean policyValue;
    @Column(name="PLCY_VAL")
    private String policyStringValue;
    @Id
    @JoinColumn(name="DOC_TYP_ID", nullable=false)
    @ManyToOne
    private DocumentType documentType;
    @Transient
    private Boolean inheritedFlag;

    public DocumentTypePolicy() {
    }

    public DocumentTypePolicy(String documentTypeId, String policyName, Boolean policyValue) {
        this.documentTypeId = documentTypeId;
        this.policyName = policyName;
        this.policyValue = policyValue;
    }

    public String getPolicyDisplayValue() {
        if (this._persistence_get_policyValue() != null) {
            if (this._persistence_get_policyValue().booleanValue()) {
                return "Active";
            }
            return "Inactive";
        }
        return "Inherited";
    }

    public Boolean getInheritedFlag() {
        return this.inheritedFlag;
    }

    public void setInheritedFlag(Boolean inheritedFlag) {
        this.inheritedFlag = inheritedFlag;
    }

    public boolean isAllowUnrequestedAction() {
        return org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ALLOW_UNREQUESTED_ACTION.equals((Object)this.getPolicyName());
    }

    public boolean isDefaultApprove() {
        return org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DEFAULT_APPROVE.equals((Object)this.getPolicyName());
    }

    public boolean isDisApprove() {
        return org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DISAPPROVE.getCode().equals(this.getPolicyName());
    }

    public String getDocumentTypeId() {
        return this.documentTypeId;
    }

    public void setDocumentTypeId(String documentTypeId) {
        this.documentTypeId = documentTypeId;
    }

    public String getPolicyName() {
        return this._persistence_get_policyName();
    }

    public void setPolicyName(String policyName) {
        org.kuali.rice.kew.api.doctype.DocumentTypePolicy policy = org.kuali.rice.kew.api.doctype.DocumentTypePolicy.fromCode((String)policyName);
        this._persistence_set_policyName(policy.getCode());
    }

    public Boolean getPolicyValue() {
        return this._persistence_get_policyValue();
    }

    public void setPolicyValue(Boolean policyValue) {
        this._persistence_set_policyValue(policyValue);
    }

    public String getPolicyStringValue() {
        return this._persistence_get_policyStringValue();
    }

    public void setPolicyStringValue(String policyStringValue) {
        this._persistence_set_policyStringValue(policyStringValue);
    }

    public String getActualPolicyValue() {
        if (this._persistence_get_policyStringValue() != null && this._persistence_get_policyStringValue().length() > 0) {
            return this._persistence_get_policyStringValue();
        }
        return this._persistence_get_policyValue().toString();
    }

    public Object copy(boolean preserveKeys) {
        DocumentTypePolicy clone = new DocumentTypePolicy();
        if (preserveKeys) {
            clone.setPolicyName(this.getPolicyName());
        }
        if (this._persistence_get_policyValue() != null) {
            clone.setPolicyValue(new Boolean(this._persistence_get_policyValue()));
        }
        if (this._persistence_get_policyStringValue() != null) {
            clone.setPolicyStringValue(new String(this._persistence_get_policyStringValue()));
        }
        return clone;
    }

    public DocumentType getDocumentType() {
        return this._persistence_get_documentType();
    }

    public void setDocumentType(DocumentType documentType) {
        this._persistence_set_documentType(documentType);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DocumentTypePolicy();
    }

    public Object _persistence_get(String string) {
        if (string == "policyValue") {
            return this.policyValue;
        }
        if (string == "policyName") {
            return this.policyName;
        }
        if (string == "documentType") {
            return this.documentType;
        }
        if (string == "policyStringValue") {
            return this.policyStringValue;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "policyValue") {
            this.policyValue = (Boolean)object;
            return;
        }
        if (string == "policyName") {
            this.policyName = (String)object;
            return;
        }
        if (string == "documentType") {
            this.documentType = (DocumentType)object;
            return;
        }
        if (string == "policyStringValue") {
            this.policyStringValue = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Boolean _persistence_get_policyValue() {
        this._persistence_checkFetched("policyValue");
        return this.policyValue;
    }

    public void _persistence_set_policyValue(Boolean bl) {
        this._persistence_checkFetchedForSet("policyValue");
        this._persistence_propertyChange("policyValue", this.policyValue, bl);
        this.policyValue = bl;
    }

    public String _persistence_get_policyName() {
        this._persistence_checkFetched("policyName");
        return this.policyName;
    }

    public void _persistence_set_policyName(String string) {
        this._persistence_checkFetchedForSet("policyName");
        this._persistence_propertyChange("policyName", this.policyName, string);
        this.policyName = string;
    }

    public DocumentType _persistence_get_documentType() {
        this._persistence_checkFetched("documentType");
        return this.documentType;
    }

    public void _persistence_set_documentType(DocumentType documentType) {
        this._persistence_checkFetchedForSet("documentType");
        this._persistence_propertyChange("documentType", this.documentType, documentType);
        this.documentType = documentType;
    }

    public String _persistence_get_policyStringValue() {
        this._persistence_checkFetched("policyStringValue");
        return this.policyStringValue;
    }

    public void _persistence_set_policyStringValue(String string) {
        this._persistence_checkFetchedForSet("policyStringValue");
        this._persistence_propertyChange("policyStringValue", this.policyStringValue, string);
        this.policyStringValue = string;
    }
}

