/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml.export;

import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Element;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.util.xml.XmlRenderer;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleTemplateOptionBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class RuleTemplateXmlExporter
implements XmlExporter {
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    private XmlRenderer renderer = new XmlRenderer(XmlConstants.RULE_TEMPLATE_NAMESPACE);

    public boolean supportPrettyPrint() {
        return true;
    }

    public Element export(ExportDataSet exportDataSet) {
        KewExportDataSet dataSet = KewExportDataSet.fromExportDataSet(exportDataSet);
        if (!dataSet.getRuleTemplates().isEmpty()) {
            Element rootElement = this.renderer.renderElement(null, "ruleTemplates");
            rootElement.setAttribute("schemaLocation", "ns:workflow/RuleTemplate resource:RuleTemplate", XmlConstants.SCHEMA_NAMESPACE);
            for (RuleTemplateBo template : dataSet.getRuleTemplates()) {
                this.exportRuleTemplate(rootElement, template);
            }
            return rootElement;
        }
        return null;
    }

    private void exportRuleTemplate(Element parent, RuleTemplateBo ruleTemplate) {
        Element templateElement = this.renderer.renderElement(parent, "ruleTemplate");
        this.renderer.renderTextElement(templateElement, "name", ruleTemplate.getName());
        this.renderer.renderTextElement(templateElement, "description", ruleTemplate.getDescription());
        if (ruleTemplate.getDelegationTemplate() != null) {
            this.renderer.renderTextElement(templateElement, "delegationTemplate", ruleTemplate.getDelegationTemplate().getName());
        }
        this.exportAttributes(templateElement, ruleTemplate.getActiveRuleTemplateAttributes());
        this.exportDefaults(templateElement, ruleTemplate);
    }

    private void exportAttributes(Element parent, List ruleTemplateAttributes) {
        if (!ruleTemplateAttributes.isEmpty()) {
            Element attributesElement = this.renderer.renderElement(parent, "attributes");
            for (RuleTemplateAttributeBo attribute : ruleTemplateAttributes) {
                Element attributeElement = this.renderer.renderElement(attributesElement, "attribute");
                this.renderer.renderTextElement(attributeElement, "name", attribute.getRuleAttribute().getName());
                this.renderer.renderBooleanElement(attributeElement, "required", attribute.getRequired(), false);
            }
        }
    }

    private void exportDefaults(Element parent, RuleTemplateBo ruleTemplate) {
        RuleBaseValues defaultRuleValues = KEWServiceLocator.getRuleService().findDefaultRuleByRuleTemplateId(ruleTemplate.getId());
        if (defaultRuleValues != null) {
            RuleDelegationBo defaultDelegationValues = this.getDefaultDelegationValues(defaultRuleValues);
            Element defaultsElement = this.renderer.renderElement(parent, "ruleDefaults");
            if (defaultDelegationValues != null) {
                this.renderer.renderTextElement(defaultsElement, "delegationType", defaultDelegationValues.getDelegationType().getCode());
            }
            this.renderer.renderTextElement(defaultsElement, "description", defaultRuleValues.getDescription());
            if (defaultRuleValues.getFromDateValue() != null) {
                this.renderer.renderDateElement(defaultsElement, "fromDate", (Date)defaultRuleValues.getFromDateValue());
            }
            if (defaultRuleValues.getToDateValue() != null) {
                this.renderer.renderDateElement(defaultsElement, "toDate", (Date)defaultRuleValues.getToDateValue());
            }
            this.renderer.renderBooleanElement(defaultsElement, "forceAction", Boolean.valueOf(defaultRuleValues.isForceAction()), false);
            this.renderer.renderBooleanElement(defaultsElement, "active", Boolean.valueOf(defaultRuleValues.isActive()), true);
            if (defaultDelegationValues == null) {
                RuleTemplateOptionBo defaultActionOption = ruleTemplate.getDefaultActionRequestValue();
                RuleTemplateOptionBo supportsComplete = ruleTemplate.getComplete();
                RuleTemplateOptionBo supportsApprove = ruleTemplate.getApprove();
                RuleTemplateOptionBo supportsAck = ruleTemplate.getAcknowledge();
                RuleTemplateOptionBo supportsFYI = ruleTemplate.getFyi();
                if (defaultActionOption != null) {
                    String defaultActionValue = defaultActionOption == null ? null : defaultActionOption.getValue();
                    this.renderer.renderTextElement(defaultsElement, "defaultActionRequested", defaultActionValue);
                }
                if (supportsComplete != null) {
                    String supportsCompleteValue = supportsComplete.getValue();
                    this.renderer.renderTextElement(defaultsElement, "supportsComplete", supportsCompleteValue);
                }
                if (supportsApprove != null) {
                    String supportsApproveValue = supportsApprove.getValue();
                    this.renderer.renderTextElement(defaultsElement, "supportsApprove", supportsApproveValue);
                }
                if (supportsAck != null) {
                    String supportsAckValue = supportsAck.getValue();
                    this.renderer.renderTextElement(defaultsElement, "supportsAcknowledge", supportsAckValue);
                }
                if (supportsFYI != null) {
                    String supportsFYIValue = supportsFYI.getValue();
                    this.renderer.renderTextElement(defaultsElement, "supportsFYI", supportsFYIValue);
                }
            }
        }
    }

    private RuleDelegationBo getDefaultDelegationValues(RuleBaseValues defaultRuleValues) {
        List<RuleDelegationBo> ruleDelegations = KEWServiceLocator.getRuleDelegationService().findByDelegateRuleId(defaultRuleValues.getId());
        if (ruleDelegations.size() > 1) {
            this.LOG.warn("The rule defaults has more than one associated delegation defaults.");
        }
        return ruleDelegations.isEmpty() ? null : ruleDelegations.get(0);
    }
}

