/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc;

import java.sql.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.CockroachRetryingTransactionalExecutionTemplate;
import org.flywaydb.core.internal.jdbc.DatabaseType;
import org.flywaydb.core.internal.jdbc.ExecutionTemplate;
import org.flywaydb.core.internal.jdbc.PlainExecutionTemplate;
import org.flywaydb.core.internal.jdbc.TableLockingExecutionTemplate;
import org.flywaydb.core.internal.jdbc.TransactionalExecutionTemplate;

public class ExecutionTemplateFactory {
    public static ExecutionTemplate createExecutionTemplate(Connection connection) {
        return ExecutionTemplateFactory.createTransactionalExecutionTemplate(connection, true);
    }

    public static ExecutionTemplate createExecutionTemplate(Connection connection, Database database) {
        if (database.supportsMultiStatementTransactions()) {
            return ExecutionTemplateFactory.createTransactionalExecutionTemplate(connection, true);
        }
        return new PlainExecutionTemplate();
    }

    public static ExecutionTemplate createTableExclusiveExecutionTemplate(Connection connection, Table table, Database database) {
        if (database.supportsMultiStatementTransactions()) {
            return new TableLockingExecutionTemplate(table, ExecutionTemplateFactory.createTransactionalExecutionTemplate(connection, database.supportsDdlTransactions()));
        }
        return new TableLockingExecutionTemplate(table, new PlainExecutionTemplate());
    }

    private static ExecutionTemplate createTransactionalExecutionTemplate(Connection connection, boolean rollbackOnException) {
        DatabaseType databaseType = DatabaseType.fromJdbcConnection(connection);
        if (DatabaseType.COCKROACHDB.equals((Object)databaseType)) {
            return new CockroachRetryingTransactionalExecutionTemplate(connection, rollbackOnException);
        }
        return new TransactionalExecutionTemplate(connection, rollbackOnException);
    }
}

