/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.medusa.MedusaService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.person.attr.PersonEditableField;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionableFormInterface;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.SoftError;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.web.struts.form.KualiTransactionalDocumentFormBase;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class KcTransactionalDocumentFormBase
extends KualiTransactionalDocumentFormBase {
    private static final long serialVersionUID = 1161569719154606103L;
    private static final int LAST_UPDATED_BY_MAX_LENGTH = 30;
    private static final int LAST_UPDATED_BY_USERNAME_MAX_LENGTH = 15;
    private static final int LAST_UPDATED_BY_FULL_NAME_MAX_LENGTH = 30;
    protected String actionName;
    protected String navigateTo;
    private boolean viewOnly;
    private boolean popupViewOnly;
    private boolean medusaOpenedDoc;
    private Map<String, Boolean> personEditableFields;
    private transient KcPersonService kcPersonService;
    private transient ParameterService parameterService;
    private transient DateTimeService dateTimeService;
    private List<String> unitRulesMessages = new ArrayList<String>();

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getNavigateTo() {
        return this.navigateTo;
    }

    public void setNavigateTo(String navigateTo) {
        this.navigateTo = navigateTo;
    }

    public void populate(HttpServletRequest request) {
        String validateParameter;
        super.populate(request);
        String methodToCallAttribute = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.contains((CharSequence)methodToCallAttribute, (CharSequence)"validate") && StringUtils.equals((CharSequence)"0", (CharSequence)(validateParameter = StringUtils.substringBetween((String)methodToCallAttribute, (String)".validate", (String)".")))) {
            GlobalVariables.getMessageMap().clearErrorMessages();
        }
    }

    public Map<String, Collection<SoftError>> getSoftErrors() {
        return (Map)GlobalVariables.getUserSession().retrieveObject("SOFT_ERRORS_KEY");
    }

    public void setupLockRegions() {
        String lockRegion = this.getLockRegion();
        GlobalVariables.getUserSession().addObject("ACTIVE_LOCK_REGION", (Object)lockRegion);
        boolean activeLockRegionChangedInd = this.hasActiveLockRegionChanged(this.getDocument(), lockRegion);
        GlobalVariables.getUserSession().addObject("ACTIVE_LOCK_REGION_CHANGED", (Object)activeLockRegionChangedInd);
    }

    private boolean hasActiveLockRegionChanged(Document document, String activeLockRegion) {
        if (StringUtils.isNotEmpty((CharSequence)activeLockRegion)) {
            for (PessimisticLock lock : document.getPessimisticLocks()) {
                if (lock.getLockDescriptor() == null || lock.getLockDescriptor().contains(activeLockRegion) || !lock.getOwnedByUser().getPrincipalId().equals(GlobalVariables.getUserSession().getPrincipalId())) continue;
                return true;
            }
        } else {
            return document.getPessimisticLocks().size() > 0;
        }
        return false;
    }

    public String getHeaderDispatch() {
        return this.getDocumentActions().containsKey("canSave") ? "save" : "reload";
    }

    protected abstract String getLockRegion();

    public final boolean isViewOnly() {
        return this.viewOnly;
    }

    public final void setViewOnly(boolean viewOnly) {
        this.viewOnly = viewOnly;
    }

    public final boolean isPopupViewOnly() {
        return this.popupViewOnly;
    }

    public final void setPopupViewOnly(boolean popupViewOnly) {
        this.popupViewOnly = popupViewOnly;
    }

    public void setDocument(Document document) {
        super.setDocument(document);
        ((KcTransactionalDocumentBase)document).setViewOnly(this.isViewOnly());
    }

    protected abstract String getDefaultDocumentTypeName();

    public boolean isMedusaOpenedDoc() {
        return this.medusaOpenedDoc;
    }

    public void setMedusaOpenedDoc(boolean medusaOpenedDoc) {
        this.medusaOpenedDoc = medusaOpenedDoc;
    }

    protected void addExtraButton(String property, String source, String altText) {
        this.addExtraButton(property, source, altText, altText);
    }

    protected void addExtraButton(String property, String source, String altText, String label) {
        this.addExtraButton(property, source, altText, label, null);
    }

    protected void addExtraButton(String property, String source, String altText, String label, String extraButtonOnclick) {
        ExtraButton newButton = new ExtraButton();
        newButton.setExtraButtonProperty(property);
        newButton.setExtraButtonSource(source);
        newButton.setExtraButtonAltText(altText);
        newButton.setExtraButtonLabel(label);
        if (StringUtils.isNotBlank((CharSequence)extraButtonOnclick)) {
            newButton.setExtraButtonOnclick(extraButtonOnclick);
        }
        this.extraButtons.add(newButton);
    }

    public Map<String, Boolean> getPersonEditableFields() {
        if (this.personEditableFields == null) {
            this.populatePersonEditableFields();
        }
        return this.personEditableFields;
    }

    public void setPersonEditableFields(Map<String, Boolean> personEditableFields) {
        this.personEditableFields = personEditableFields;
    }

    public void populatePersonEditableFields() {
        this.setPersonEditableFields(new HashMap<String, Boolean>());
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleCode", this.getModuleCode());
        Collection fields = this.getBusinessObjectService().findMatching(PersonEditableField.class, fieldValues);
        for (PersonEditableField field : fields) {
            this.getPersonEditableFields().put(field.getFieldName(), field.isActive());
        }
    }

    private BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    public String getModuleCode() {
        return "0";
    }

    protected void populateFalseCheckboxes(HttpServletRequest request) {
        String[] checkboxesToResetFields;
        Map parameterMap = request.getParameterMap();
        String checkBoxToResetFieldParam = "checkboxToReset";
        if (parameterMap.get("checkboxToReset") != null && (checkboxesToResetFields = request.getParameterValues("checkboxToReset")) != null && checkboxesToResetFields.length > 0) {
            for (String propertyName : checkboxesToResetFields) {
                if (!StringUtils.isBlank((CharSequence)propertyName) && parameterMap.get(propertyName) == null) {
                    if (this instanceof QuestionableFormInterface && (StringUtils.startsWithIgnoreCase((CharSequence)propertyName, (CharSequence)((QuestionableFormInterface)((Object)this)).getQuestionnaireFieldStarter()) && StringUtils.containsIgnoreCase((CharSequence)propertyName, (CharSequence)((QuestionableFormInterface)((Object)this)).getQuestionnaireFieldMiddle()) && StringUtils.endsWithIgnoreCase((CharSequence)propertyName, (CharSequence)((QuestionableFormInterface)((Object)this)).getQuestionnaireFieldEnd()) || propertyName.matches(((QuestionableFormInterface)((Object)this)).getQuestionnaireExpression()))) {
                        this.populateForProperty(propertyName, null, parameterMap);
                        continue;
                    }
                    this.populateForProperty(propertyName, "No", parameterMap);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)propertyName) || parameterMap.get(propertyName) == null || ((String[])parameterMap.get(propertyName)).length < 1 || !((String[])parameterMap.get(propertyName))[0].equalsIgnoreCase("on")) continue;
                this.populateForProperty(propertyName, "Yes", parameterMap);
            }
        }
    }

    public List<String> getUnitRulesMessages() {
        return this.unitRulesMessages;
    }

    public void setUnitRulesMessages(List<String> unitRulesMessages) {
        this.unitRulesMessages = unitRulesMessages;
    }

    public boolean isUnitRulesErrorsExist() {
        return this.getUnitRulesErrors().size() > 0;
    }

    public boolean isUnitRulesWarningsExist() {
        return this.getUnitRulesWarnings().size() > 0;
    }

    public List<String> getUnitRulesErrors() {
        return this.getUnitRulesMessages("E");
    }

    public List<String> getUnitRulesWarnings() {
        return this.getUnitRulesMessages("W");
    }

    public void clearUnitRulesMessages() {
        this.unitRulesMessages = Collections.emptyList();
    }

    protected List<String> getUnitRulesMessages(String messageType) {
        ArrayList<String> messages = new ArrayList<String>();
        for (String message : this.unitRulesMessages) {
            if (!StringUtils.substringBefore((String)message, (String)":").equals(messageType)) continue;
            messages.add(StringUtils.substringAfter((String)message, (String)":"));
        }
        return messages;
    }

    protected String getBaseShortUrl() {
        return this.getConfigurationService().getPropertyValueAsString("application.url");
    }

    protected ConfigurationService getConfigurationService() {
        return KcServiceLocator.getService(ConfigurationService.class);
    }

    public boolean isReactMedusaEnabled() {
        return this.getMedusaService().isReactMedusaEnabled();
    }

    protected MedusaService getMedusaService() {
        return KcServiceLocator.getService(MedusaService.class);
    }

    protected List<HeaderField> getStandardHeaderFields(WorkflowDocument workflowDocument) {
        List headerFields = super.getStandardHeaderFields(workflowDocument);
        if (this.isShowFullNameEnabled()) {
            headerFields.stream().filter(headerField -> "documentInitiator".equals(headerField.getId())).forEach(headerField -> {
                Person initiator = this.getInitiator();
                KcPerson user = this.getKcPersonService().getKcPersonByUserName(initiator.getPrincipalName());
                headerField.setDisplayValue(StringUtils.substring((String)user.getFullName(), (int)0, (int)30) + " (" + StringUtils.substring((String)user.getUserName(), (int)0, (int)15) + ")");
                headerField.setNonLookupValue(this.getPersonInquiryUrlLink(initiator, headerField.getDisplayValue()));
            });
        }
        return headerFields;
    }

    protected void setupLastUpdate(KcTransactionalDocumentBase document, String updateTimestampDdName) {
        if (document.getUpdateTimestamp() != null) {
            String createDateStr = this.getDateTimeService().toString((Date)document.getUpdateTimestamp(), "MM/dd/yy");
            Object lastUpdatedBy = StringUtils.substring((String)document.getUpdateUser(), (int)0, (int)30);
            KcPerson user = this.getKcPersonService().getKcPersonByUserName(document.getUpdateUser());
            if (user != null && this.isShowFullNameEnabled()) {
                lastUpdatedBy = StringUtils.substring((String)user.getFullName(), (int)0, (int)30) + " (" + StringUtils.substring((String)document.getUpdateUser(), (int)0, (int)15) + ")";
            }
            this.getDocInfo().add(new HeaderField(updateTimestampDdName, createDateStr + " by " + (String)lastUpdatedBy));
        } else {
            this.getDocInfo().add(new HeaderField(updateTimestampDdName, ""));
        }
    }

    private ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    private KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    private DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KcServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    protected boolean isShowFullNameEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "Show_Full_Name_In_Header_Fields", Boolean.valueOf(false));
    }
}

