/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.mapper.MapperService;

public final class AutoCreateIndex {
    public static final Setting<AutoCreate> AUTO_CREATE_INDEX_SETTING = new Setting<AutoCreate>("action.auto_create_index", "true", x$0 -> new AutoCreate((String)x$0), Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final boolean dynamicMappingDisabled;
    private final IndexNameExpressionResolver resolver;
    private volatile AutoCreate autoCreate;

    public AutoCreateIndex(Settings settings, ClusterSettings clusterSettings, IndexNameExpressionResolver resolver) {
        this.resolver = resolver;
        this.dynamicMappingDisabled = MapperService.INDEX_MAPPER_DYNAMIC_SETTING.get(settings) == false;
        this.autoCreate = AUTO_CREATE_INDEX_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AUTO_CREATE_INDEX_SETTING, this::setAutoCreate);
    }

    public boolean needToCheck() {
        return this.autoCreate.autoCreateIndex;
    }

    public boolean shouldAutoCreate(String index, ClusterState state) {
        if (this.resolver.hasIndexOrAlias(index, state)) {
            return false;
        }
        AutoCreate autoCreate = this.autoCreate;
        if (!autoCreate.autoCreateIndex) {
            throw new IndexNotFoundException("[" + AUTO_CREATE_INDEX_SETTING.getKey() + "] is [false]", index);
        }
        if (this.dynamicMappingDisabled) {
            throw new IndexNotFoundException("[" + MapperService.INDEX_MAPPER_DYNAMIC_SETTING.getKey() + "] is [false]", index);
        }
        if (autoCreate.expressions.isEmpty()) {
            return true;
        }
        for (Tuple expression : autoCreate.expressions) {
            String indexExpression = (String)expression.v1();
            boolean include = (Boolean)expression.v2();
            if (!Regex.simpleMatch(indexExpression, index)) continue;
            if (include) {
                return true;
            }
            throw new IndexNotFoundException("[" + AUTO_CREATE_INDEX_SETTING.getKey() + "] contains [-" + indexExpression + "] which forbids automatic creation of the index", index);
        }
        throw new IndexNotFoundException("[" + AUTO_CREATE_INDEX_SETTING.getKey() + "] ([" + autoCreate + "]) doesn't match", index);
    }

    AutoCreate getAutoCreate() {
        return this.autoCreate;
    }

    void setAutoCreate(AutoCreate autoCreate) {
        this.autoCreate = autoCreate;
    }

    static class AutoCreate {
        private final boolean autoCreateIndex;
        private final List<Tuple<String, Boolean>> expressions;
        private final String string;

        private AutoCreate(String value) {
            boolean autoCreateIndex;
            ArrayList<Tuple<String, Boolean>> expressions = new ArrayList<Tuple<String, Boolean>>();
            try {
                autoCreateIndex = Booleans.parseBoolean((String)value);
            }
            catch (IllegalArgumentException ex) {
                try {
                    String[] patterns;
                    for (String pattern : patterns = Strings.commaDelimitedListToStringArray(value)) {
                        Tuple expression;
                        if (pattern == null || pattern.trim().length() == 0) {
                            throw new IllegalArgumentException("Can't parse [" + value + "] for setting [action.auto_create_index] must be either [true, false, or a comma separated list of index patterns]");
                        }
                        if ((pattern = pattern.trim()).startsWith("-")) {
                            if (pattern.length() == 1) {
                                throw new IllegalArgumentException("Can't parse [" + value + "] for setting [action.auto_create_index] must contain an index name after [-]");
                            }
                            expression = new Tuple((Object)pattern.substring(1), (Object)false);
                        } else if (pattern.startsWith("+")) {
                            if (pattern.length() == 1) {
                                throw new IllegalArgumentException("Can't parse [" + value + "] for setting [action.auto_create_index] must contain an index name after [+]");
                            }
                            expression = new Tuple((Object)pattern.substring(1), (Object)true);
                        } else {
                            expression = new Tuple((Object)pattern, (Object)true);
                        }
                        expressions.add((Tuple<String, Boolean>)expression);
                    }
                    autoCreateIndex = true;
                }
                catch (IllegalArgumentException ex1) {
                    ex1.addSuppressed(ex);
                    throw ex1;
                }
            }
            this.expressions = expressions;
            this.autoCreateIndex = autoCreateIndex;
            this.string = value;
        }

        boolean isAutoCreateIndex() {
            return this.autoCreateIndex;
        }

        List<Tuple<String, Boolean>> getExpressions() {
            return this.expressions;
        }

        public String toString() {
            return this.string;
        }
    }
}

