/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.ack.CreateIndexClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.collect.List;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataCreateIndexService {
    private static final Logger logger = LogManager.getLogger(MetadataCreateIndexService.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(logger);
    public static final int MAX_INDEX_NAME_BYTES = 255;
    private final Settings settings;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final AliasValidator aliasValidator;
    private final Environment env;
    private final IndexScopedSettings indexScopedSettings;
    private final ActiveShardsObserver activeShardsObserver;
    private final NamedXContentRegistry xContentRegistry;
    private final Collection<SystemIndexDescriptor> systemIndexDescriptors;
    private final boolean forbidPrivateIndexSettings;

    public MetadataCreateIndexService(Settings settings, ClusterService clusterService, IndicesService indicesService, AllocationService allocationService, AliasValidator aliasValidator, Environment env, IndexScopedSettings indexScopedSettings, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, Collection<SystemIndexDescriptor> systemIndexDescriptors, boolean forbidPrivateIndexSettings) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.aliasValidator = aliasValidator;
        this.env = env;
        this.indexScopedSettings = indexScopedSettings;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.xContentRegistry = xContentRegistry;
        this.systemIndexDescriptors = systemIndexDescriptors;
        this.forbidPrivateIndexSettings = forbidPrivateIndexSettings;
    }

    public void validateIndexName(String index, ClusterState state) {
        MetadataCreateIndexService.validateIndexOrAliasName(index, InvalidIndexNameException::new);
        if (!index.toLowerCase(Locale.ROOT).equals(index)) {
            throw new InvalidIndexNameException(index, "must be lowercase");
        }
        if (state.routingTable().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.routingTable().index(index).getIndex());
        }
        if (state.metadata().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.metadata().index(index).getIndex());
        }
        if (state.metadata().hasAlias(index)) {
            throw new InvalidIndexNameException(index, "already exists as alias");
        }
    }

    public void validateDotIndex(String index, ClusterState state, @Nullable Boolean isHidden) {
        if (index.charAt(0) == '.') {
            java.util.List matchingDescriptors = this.systemIndexDescriptors.stream().filter(descriptor -> descriptor.matchesIndexPattern(index)).collect(Collectors.toList());
            if (matchingDescriptors.isEmpty() && (isHidden == null || isHidden == Boolean.FALSE)) {
                DEPRECATION_LOGGER.deprecatedAndMaybeLog("index_name_starts_with_dot", "index name [{}] starts with a dot '.', in the next major version, index names starting with a dot are reserved for hidden indices and system indices", index);
            } else if (matchingDescriptors.size() > 1) {
                StringBuilder errorMessage = new StringBuilder().append("index name [").append(index).append("] is claimed as a system index by multiple system index patterns: [").append(matchingDescriptors.stream().map(descriptor -> "pattern: [" + descriptor.getIndexPattern() + "], description: [" + descriptor.getDescription() + "]").collect(Collectors.joining("; ")));
                assert (false) : errorMessage.toString();
                throw new IllegalStateException(errorMessage.toString());
            }
        }
    }

    public static void validateIndexOrAliasName(String index, BiFunction<String, String, ? extends RuntimeException> exceptionCtor) {
        if (!Strings.validFileName(index)) {
            throw exceptionCtor.apply(index, "must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (index.contains("#")) {
            throw exceptionCtor.apply(index, "must not contain '#'");
        }
        if (index.contains(":")) {
            throw exceptionCtor.apply(index, "must not contain ':'");
        }
        if (index.charAt(0) == '_' || index.charAt(0) == '-' || index.charAt(0) == '+') {
            throw exceptionCtor.apply(index, "must not start with '_', '-', or '+'");
        }
        int byteCount = 0;
        try {
            byteCount = index.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new ElasticsearchException("Unable to determine length of index name", (Throwable)e, new Object[0]);
        }
        if (byteCount > 255) {
            throw exceptionCtor.apply(index, "index name is too long, (" + byteCount + " > " + 255 + ")");
        }
        if (index.equals(".") || index.equals("..")) {
            throw exceptionCtor.apply(index, "must not be '.' or '..'");
        }
    }

    public void createIndex(CreateIndexClusterStateUpdateRequest request, ActionListener<CreateIndexClusterStateUpdateResponse> listener) {
        this.onlyCreateIndex(request, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.activeShardsObserver.waitForActiveShards(new String[]{request.index()}, request.waitForActiveShards(), request.ackTimeout(), shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        logger.debug("[{}] index created, but the operation timed out while waiting for enough shards to be started.", (Object)request.index());
                    }
                    listener.onResponse(new CreateIndexClusterStateUpdateResponse(response.isAcknowledged(), (boolean)shardsAcknowledged));
                }, listener::onFailure);
            } else {
                listener.onResponse(new CreateIndexClusterStateUpdateResponse(false, false));
            }
        }, listener::onFailure));
    }

    private void onlyCreateIndex(final CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        Settings.Builder updatedSettingsBuilder = Settings.builder();
        Settings build = updatedSettingsBuilder.put(request.settings()).normalizePrefix("index.").build();
        this.indexScopedSettings.validate(build, true);
        request.settings(build);
        this.clusterService.submitStateUpdateTask("create-index [" + request.index() + "], cause [" + request.cause() + "]", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return MetadataCreateIndexService.this.applyCreateIndexRequest(currentState, request, false);
            }

            @Override
            public void onFailure(String source, Exception e) {
                if (e instanceof ResourceAlreadyExistsException) {
                    logger.trace(() -> new ParameterizedMessage("[{}] failed to create", (Object)request.index()), (Throwable)e);
                } else {
                    logger.debug(() -> new ParameterizedMessage("[{}] failed to create", (Object)request.index()), (Throwable)e);
                }
                super.onFailure(source, e);
            }
        });
    }

    public ClusterState applyCreateIndexRequest(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) throws Exception {
        IndexMetadata sourceMetadata;
        logger.trace("executing IndexCreationTask for [{}] against cluster state version [{}]", (Object)request, (Object)currentState.version());
        this.validate(request, currentState);
        Index recoverFromIndex = request.recoverFrom();
        IndexMetadata indexMetadata = sourceMetadata = recoverFromIndex == null ? null : currentState.metadata().getIndexSafe(recoverFromIndex);
        if (sourceMetadata != null) {
            return this.applyCreateIndexRequestWithExistingMetadata(currentState, request, silent, sourceMetadata, metadataTransformer);
        }
        Boolean isHiddenFromRequest = IndexMetadata.INDEX_HIDDEN_SETTING.exists(request.settings()) ? IndexMetadata.INDEX_HIDDEN_SETTING.get(request.settings()) : null;
        String v2Template = MetadataIndexTemplateService.findV2Template(currentState.metadata(), request.index(), isHiddenFromRequest == null ? false : isHiddenFromRequest);
        if (v2Template != null) {
            return this.applyCreateIndexRequestWithV2Template(currentState, request, silent, v2Template, metadataTransformer);
        }
        java.util.List<IndexTemplateMetadata> v1Templates = MetadataIndexTemplateService.findV1Templates(currentState.metadata(), request.index(), isHiddenFromRequest);
        if (v1Templates.size() > 1) {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog("index_template_multiple_match", "index [{}] matches multiple legacy templates [{}], composable templates will only match a single template", request.index(), v1Templates.stream().map(IndexTemplateMetadata::name).sorted().collect(Collectors.joining(", ")));
        }
        return this.applyCreateIndexRequestWithV1Templates(currentState, request, silent, v1Templates, metadataTransformer);
    }

    public ClusterState applyCreateIndexRequest(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent) throws Exception {
        return this.applyCreateIndexRequest(currentState, request, silent, null);
    }

    private ClusterState applyCreateIndexWithTemporaryService(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent, IndexMetadata sourceMetadata, IndexMetadata temporaryIndexMeta, Map<String, Map<String, Object>> mappings, Function<IndexService, java.util.List<AliasMetadata>> aliasSupplier, java.util.List<String> templatesApplied, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) throws Exception {
        return (ClusterState)this.indicesService.withTempIndexService(temporaryIndexMeta, indexService -> {
            IndexMetadata indexMetadata;
            try {
                MetadataCreateIndexService.updateIndexMappingsAndBuildSortOrder(indexService, mappings, sourceMetadata);
            }
            catch (Exception e) {
                logger.debug("failed on parsing mappings on index creation [{}]", (Object)request.index());
                throw e;
            }
            java.util.List aliases = (java.util.List)aliasSupplier.apply((IndexService)indexService);
            try {
                indexMetadata = MetadataCreateIndexService.buildIndexMetadata(request.index(), aliases, indexService.mapperService()::documentMapper, () -> indexService.mapperService().documentMapper("_default_"), temporaryIndexMeta.getSettings(), temporaryIndexMeta.getRoutingNumShards(), sourceMetadata);
            }
            catch (Exception e) {
                logger.info("failed to build index metadata [{}]", (Object)request.index());
                throw e;
            }
            logger.log(silent ? Level.DEBUG : Level.INFO, "[{}] creating index, cause [{}], templates {}, shards [{}]/[{}], mappings {}", (Object)request.index(), (Object)request.cause(), (Object)templatesApplied, (Object)indexMetadata.getNumberOfShards(), (Object)indexMetadata.getNumberOfReplicas(), mappings.keySet());
            indexService.getIndexEventListener().beforeIndexAddedToCluster(indexMetadata.getIndex(), indexMetadata.getSettings());
            return MetadataCreateIndexService.clusterStateCreateIndex(currentState, request.blocks(), indexMetadata, this.allocationService::reroute, metadataTransformer);
        });
    }

    private IndexMetadata buildAndValidateTemporaryIndexMetadata(ClusterState currentState, Settings aggregatedIndexSettings, CreateIndexClusterStateUpdateRequest request, int routingNumShards) {
        boolean isHiddenAfterTemplates = IndexMetadata.INDEX_HIDDEN_SETTING.get(aggregatedIndexSettings);
        this.validateDotIndex(request.index(), currentState, isHiddenAfterTemplates);
        Settings.Builder settingsBuilder = Settings.builder().put(aggregatedIndexSettings);
        settingsBuilder.remove(IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.getKey());
        Settings indexSettings = settingsBuilder.build();
        IndexMetadata.Builder tmpImdBuilder = IndexMetadata.builder(request.index());
        tmpImdBuilder.setRoutingNumShards(routingNumShards);
        tmpImdBuilder.settings(indexSettings);
        IndexMetadata tempMetadata = tmpImdBuilder.build();
        MetadataCreateIndexService.validateActiveShardCount(request.waitForActiveShards(), tempMetadata);
        return tempMetadata;
    }

    private ClusterState applyCreateIndexRequestWithV1Templates(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent, java.util.List<IndexTemplateMetadata> templates, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) throws Exception {
        logger.debug("applying create index request using legacy templates {}", templates.stream().map(IndexTemplateMetadata::name).collect(Collectors.toList()));
        Map<String, Map<String, Object>> mappings = Collections.unmodifiableMap(MetadataCreateIndexService.parseV1Mappings(request.mappings(), templates.stream().map(IndexTemplateMetadata::getMappings).map(iom -> {
            HashMap<String, CompressedXContent> converted = new HashMap<String, CompressedXContent>(iom.size());
            for (ObjectObjectCursor cursor : iom) {
                converted.put((String)cursor.key, (CompressedXContent)cursor.value);
            }
            return converted;
        }).collect(Collectors.toList()), this.xContentRegistry));
        Settings aggregatedIndexSettings = MetadataCreateIndexService.aggregateIndexSettings(currentState, request, MetadataIndexTemplateService.resolveSettings(templates), mappings, null, this.settings, this.indexScopedSettings);
        int routingNumShards = MetadataCreateIndexService.getIndexNumberOfRoutingShards(aggregatedIndexSettings, null);
        IndexMetadata tmpImd = this.buildAndValidateTemporaryIndexMetadata(currentState, aggregatedIndexSettings, request, routingNumShards);
        return this.applyCreateIndexWithTemporaryService(currentState, request, silent, null, tmpImd, mappings, indexService -> MetadataCreateIndexService.resolveAndValidateAliases(request.index(), request.aliases(), MetadataIndexTemplateService.resolveAliases(templates), currentState.metadata(), this.aliasValidator, this.xContentRegistry, indexService.newQueryShardContext(0, null, () -> 0L, null)), templates.stream().map(IndexTemplateMetadata::getName).collect(Collectors.toList()), metadataTransformer);
    }

    private ClusterState applyCreateIndexRequestWithV2Template(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent, String templateName, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) throws Exception {
        String sourceMappings;
        logger.debug("applying create index request using composable template [{}]", (Object)templateName);
        if (request.mappings().size() > 0) {
            assert (request.mappings().size() == 1) : "expected request metadata mappings to have 1 type but it had: " + request.mappings();
            sourceMappings = request.mappings().values().iterator().next();
        } else {
            sourceMappings = "{}";
        }
        Map<String, Map<String, Object>> mappings = MetadataCreateIndexService.resolveV2Mappings(sourceMappings, currentState, templateName, this.xContentRegistry);
        Settings aggregatedIndexSettings = MetadataCreateIndexService.aggregateIndexSettings(currentState, request, MetadataIndexTemplateService.resolveSettings(currentState.metadata(), templateName), mappings, null, this.settings, this.indexScopedSettings);
        int routingNumShards = MetadataCreateIndexService.getIndexNumberOfRoutingShards(aggregatedIndexSettings, null);
        IndexMetadata tmpImd = this.buildAndValidateTemporaryIndexMetadata(currentState, aggregatedIndexSettings, request, routingNumShards);
        return this.applyCreateIndexWithTemporaryService(currentState, request, silent, null, tmpImd, mappings, indexService -> MetadataCreateIndexService.resolveAndValidateAliases(request.index(), request.aliases(), MetadataIndexTemplateService.resolveAliases(currentState.metadata(), templateName), currentState.metadata(), this.aliasValidator, this.xContentRegistry, indexService.newQueryShardContext(0, null, () -> 0L, null)), Collections.singletonList(templateName), metadataTransformer);
    }

    public static Map<String, Map<String, Object>> resolveV2Mappings(String requestMappings, ClusterState currentState, String templateName, NamedXContentRegistry xContentRegistry) throws Exception {
        Map<String, Map<String, Object>> mappings = Collections.unmodifiableMap(MetadataCreateIndexService.parseV2Mappings(requestMappings, MetadataIndexTemplateService.resolveMappings(currentState, templateName), xContentRegistry));
        return mappings;
    }

    private ClusterState applyCreateIndexRequestWithExistingMetadata(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent, IndexMetadata sourceMetadata, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) throws Exception {
        Map<String, Map<String, Object>> mappings;
        logger.info("applying create index request using existing index [{}] metadata", (Object)sourceMetadata.getIndex().getName());
        if (request.mappings().size() == 0) {
            mappings = Collections.emptyMap();
        } else {
            assert (request.mappings().size() == 1) : "expected source metadata mappings to have 1 type but it had: " + request.mappings();
            String sourceMappings = request.mappings().values().iterator().next();
            mappings = Collections.singletonMap("_doc", Collections.unmodifiableMap(MapperService.parseMapping(this.xContentRegistry, sourceMappings)));
        }
        Settings aggregatedIndexSettings = MetadataCreateIndexService.aggregateIndexSettings(currentState, request, Settings.EMPTY, mappings, sourceMetadata, this.settings, this.indexScopedSettings);
        int routingNumShards = MetadataCreateIndexService.getIndexNumberOfRoutingShards(aggregatedIndexSettings, sourceMetadata);
        IndexMetadata tmpImd = this.buildAndValidateTemporaryIndexMetadata(currentState, aggregatedIndexSettings, request, routingNumShards);
        return this.applyCreateIndexWithTemporaryService(currentState, request, silent, sourceMetadata, tmpImd, mappings, indexService -> MetadataCreateIndexService.resolveAndValidateAliases(request.index(), request.aliases(), Collections.emptyList(), currentState.metadata(), this.aliasValidator, this.xContentRegistry, indexService.newQueryShardContext(0, null, () -> 0L, null)), List.of(), metadataTransformer);
    }

    static Map<String, Map<String, Object>> parseV2Mappings(String mappingsJson, java.util.List<CompressedXContent> templateMappings, NamedXContentRegistry xContentRegistry) throws Exception {
        Map<String, Object> requestMappings = MapperService.parseMapping(xContentRegistry, mappingsJson);
        Map<String, Object> properties = new HashMap<String, Object>();
        Map<String, Object> nonProperties = new HashMap<String, Object>();
        for (CompressedXContent mapping : templateMappings) {
            Map<String, Object> templateMapping;
            if (mapping == null || (templateMapping = MapperService.parseMapping(xContentRegistry, mapping.string())).isEmpty()) continue;
            if (!(templateMapping.get("_doc") instanceof Map)) {
                templateMapping = Collections.singletonMap("_doc", templateMapping);
            }
            Map innerTemplateMapping = (Map)templateMapping.get("_doc");
            HashMap<String, Object> innerTemplateNonProperties = new HashMap<String, Object>(innerTemplateMapping);
            Map maybeProperties = (Map)innerTemplateNonProperties.remove("properties");
            nonProperties = MetadataCreateIndexService.mergeFailingOnReplacement(nonProperties, innerTemplateNonProperties);
            if (maybeProperties == null) continue;
            properties = MetadataCreateIndexService.mergeFailingOnReplacement(properties, maybeProperties);
        }
        if (requestMappings.get("_doc") != null) {
            Map innerRequestMappings = (Map)requestMappings.get("_doc");
            HashMap<String, Object> innerRequestNonProperties = new HashMap<String, Object>(innerRequestMappings);
            Map maybeRequestProperties = (Map)innerRequestNonProperties.remove("properties");
            nonProperties = MetadataCreateIndexService.mergeFailingOnReplacement(nonProperties, innerRequestNonProperties);
            if (maybeRequestProperties != null) {
                properties = MetadataCreateIndexService.mergeFailingOnReplacement(properties, maybeRequestProperties);
            }
        }
        Map<String, Object> finalMappings = MetadataCreateIndexService.dedupDynamicTemplates(nonProperties);
        finalMappings.put("properties", properties);
        return Collections.singletonMap("_doc", finalMappings);
    }

    private static Map<String, Object> removeDuplicatedDynamicTemplates(Map<String, Object> previouslySeenMapping, Map<String, Object> newMapping) {
        HashMap<String, Object> result = new HashMap<String, Object>(previouslySeenMapping);
        java.util.List newDynamicTemplates = (java.util.List)newMapping.get("dynamic_templates");
        java.util.List previouslySeenDynamicTemplates = (java.util.List)previouslySeenMapping.get("dynamic_templates");
        java.util.List<Map<String, Object>> filteredDynamicTemplates = MetadataCreateIndexService.removeOverlapping(previouslySeenDynamicTemplates, newDynamicTemplates);
        if (filteredDynamicTemplates != previouslySeenDynamicTemplates) {
            result.put("dynamic_templates", filteredDynamicTemplates);
        }
        return result;
    }

    private static java.util.List<Map<String, Object>> removeOverlapping(java.util.List<Map<String, Object>> first, java.util.List<Map<String, Object>> second) {
        if (first == null) {
            return first;
        }
        MetadataCreateIndexService.validateValuesAreMapsOfSizeOne(first);
        if (second == null) {
            return first;
        }
        MetadataCreateIndexService.validateValuesAreMapsOfSizeOne(second);
        Set keys = second.stream().map(value -> (String)value.keySet().iterator().next()).collect(Collectors.toSet());
        return first.stream().filter(value -> !keys.contains(value.keySet().iterator().next())).collect(Collectors.toList());
    }

    private static void validateValuesAreMapsOfSizeOne(java.util.List<Map<String, Object>> second) {
        for (Map<String, Object> map : second) {
            if (map.size() == 1) continue;
            throw new IllegalArgumentException("unexpected argument, expected maps with one key, but got " + map);
        }
    }

    private static Map<String, Object> dedupDynamicTemplates(Map<String, Object> mappings) {
        Objects.requireNonNull(mappings, "deduping the dynamic templates a non-null mapping");
        HashMap<String, Object> results = new HashMap<String, Object>(mappings);
        java.util.List dynamicTemplates = (java.util.List)mappings.get("dynamic_templates");
        if (dynamicTemplates == null) {
            return results;
        }
        LinkedHashMap<String, Map> dedupedDynamicTemplates = new LinkedHashMap<String, Map>(dynamicTemplates.size(), 1.0f);
        for (Map dynamicTemplate : dynamicTemplates) {
            dedupedDynamicTemplates.put((String)dynamicTemplate.keySet().iterator().next(), dynamicTemplate);
        }
        results.put("dynamic_templates", new ArrayList(dedupedDynamicTemplates.values()));
        return results;
    }

    static Map<String, Object> mergeFailingOnReplacement(Map<String, Object> first, Map<String, Object> second) {
        Objects.requireNonNull(first, "merging requires two non-null maps but the first map was null");
        Objects.requireNonNull(second, "merging requires two non-null maps but the second map was null");
        HashMap<String, Object> results = new HashMap<String, Object>(first);
        Set prefixes = second.keySet().stream().map(MetadataCreateIndexService::prefix).collect(Collectors.toSet());
        java.util.List matchedPrefixes = results.keySet().stream().filter(k -> prefixes.contains(MetadataCreateIndexService.prefix(k))).collect(Collectors.toList());
        if (matchedPrefixes.size() > 0) {
            throw new IllegalArgumentException("mapping fields " + matchedPrefixes + " cannot be replaced during template composition");
        }
        results.putAll(second);
        return results;
    }

    private static String prefix(String s) {
        return s.split("\\.", 2)[0];
    }

    static Map<String, Map<String, Object>> parseV1Mappings(Map<String, String> requestMappings, java.util.List<Map<String, CompressedXContent>> templateMappings, NamedXContentRegistry xContentRegistry) throws Exception {
        HashMap<String, Map<String, Object>> mappings = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, String> entry : requestMappings.entrySet()) {
            Map<String, Object> mapping = MapperService.parseMapping(xContentRegistry, entry.getValue());
            if (mapping.isEmpty()) continue;
            assert (mapping.size() == 1) : mapping;
            assert (entry.getKey().equals(mapping.keySet().iterator().next())) : entry.getKey() + " != " + mapping;
            mappings.put(entry.getKey(), mapping);
        }
        for (Map map : templateMappings) {
            for (Map.Entry cursor : map.entrySet()) {
                Map<String, Object> templateMapping;
                String mappingString = ((CompressedXContent)cursor.getValue()).string();
                String type = (String)cursor.getKey();
                if (mappings.containsKey(type)) {
                    XContentHelper.mergeDefaults((Map)mappings.get(type), MapperService.parseMapping(xContentRegistry, mappingString));
                    continue;
                }
                if (mappings.size() == 1 && type.equals("_doc")) {
                    templateMapping = MapperService.parseMapping(xContentRegistry, mappingString);
                    assert (templateMapping.size() == 1) : templateMapping;
                    assert (type.equals(templateMapping.keySet().iterator().next())) : type + " != " + templateMapping;
                    Map.Entry mappingEntry = mappings.entrySet().iterator().next();
                    templateMapping = Collections.singletonMap((String)mappingEntry.getKey(), templateMapping.values().iterator().next());
                    XContentHelper.mergeDefaults((Map)mappingEntry.getValue(), templateMapping);
                    continue;
                }
                if (map.size() == 1 && mappings.containsKey("_doc")) {
                    templateMapping = MapperService.parseMapping(xContentRegistry, mappingString);
                    assert (templateMapping.size() == 1) : templateMapping;
                    assert (type.equals(templateMapping.keySet().iterator().next())) : type + " != " + templateMapping;
                    Map mapping = (Map)mappings.get("_doc");
                    templateMapping = Collections.singletonMap("_doc", templateMapping.values().iterator().next());
                    XContentHelper.mergeDefaults(mapping, templateMapping);
                    continue;
                }
                mappings.put(type, MapperService.parseMapping(xContentRegistry, mappingString));
            }
        }
        return mappings;
    }

    static Settings aggregateIndexSettings(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, Settings templateSettings, Map<String, Map<String, Object>> mappings, @Nullable IndexMetadata sourceMetadata, Settings settings, IndexScopedSettings indexScopedSettings) {
        Settings.Builder indexSettingsBuilder = Settings.builder();
        if (sourceMetadata == null) {
            indexSettingsBuilder.put(templateSettings);
        }
        indexSettingsBuilder.put(request.settings());
        if (indexSettingsBuilder.get(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey()) == null) {
            DiscoveryNodes nodes = currentState.nodes();
            Version createdVersion = Version.min(Version.CURRENT, nodes.getSmallestNonClientNodeVersion());
            indexSettingsBuilder.put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), createdVersion);
        }
        if (indexSettingsBuilder.get("index.number_of_shards") == null) {
            int numberOfShards = MetadataCreateIndexService.getNumberOfShards(indexSettingsBuilder);
            indexSettingsBuilder.put("index.number_of_shards", settings.getAsInt("index.number_of_shards", numberOfShards));
        }
        if (indexSettingsBuilder.get("index.number_of_replicas") == null) {
            indexSettingsBuilder.put("index.number_of_replicas", settings.getAsInt("index.number_of_replicas", 1));
        }
        if (settings.get("index.auto_expand_replicas") != null && indexSettingsBuilder.get("index.auto_expand_replicas") == null) {
            indexSettingsBuilder.put("index.auto_expand_replicas", settings.get("index.auto_expand_replicas"));
        }
        if (indexSettingsBuilder.get("index.creation_date") == null) {
            indexSettingsBuilder.put("index.creation_date", Instant.now().toEpochMilli());
        }
        indexSettingsBuilder.put("index.provided_name", request.getProvidedName());
        indexSettingsBuilder.put("index.uuid", UUIDs.randomBase64UUID());
        if (sourceMetadata != null) {
            assert (request.resizeType() != null);
            MetadataCreateIndexService.prepareResizeIndexSettings(currentState, mappings.keySet(), indexSettingsBuilder, request.recoverFrom(), request.index(), request.resizeType(), request.copySettings(), indexScopedSettings);
        }
        Settings indexSettings = indexSettingsBuilder.build();
        MetadataCreateIndexService.checkShardLimit(indexSettings, currentState);
        if (!indexSettings.getAsBoolean(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), true).booleanValue()) {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog("soft_deletes_disabled", "Creating indices with soft-deletes disabled is deprecated and will be removed in future Elasticsearch versions. Please do not specify value for setting [index.soft_deletes.enabled] of index [" + request.index() + "].", new Object[0]);
        }
        MetadataCreateIndexService.validateTranslogRetentionSettings(indexSettings);
        return indexSettings;
    }

    static int getNumberOfShards(Settings.Builder indexSettingsBuilder) {
        assert (Version.CURRENT.major == 7);
        Version indexVersionCreated = Version.fromId(Integer.parseInt(indexSettingsBuilder.get(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey())));
        int numberOfShards = indexVersionCreated.before(Version.V_7_0_0) ? 5 : 1;
        return numberOfShards;
    }

    static int getIndexNumberOfRoutingShards(Settings indexSettings, @Nullable IndexMetadata sourceMetadata) {
        int routingNumShards;
        int numTargetShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(indexSettings);
        Version indexVersionCreated = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(indexSettings);
        if (sourceMetadata == null || sourceMetadata.getNumberOfShards() == 1) {
            routingNumShards = IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(indexSettings) ? IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.get(indexSettings) : MetadataCreateIndexService.calculateNumRoutingShards(numTargetShards, indexVersionCreated);
        } else {
            assert (!IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(indexSettings)) : "index.number_of_routing_shards should not be present on the target index on resize";
            routingNumShards = sourceMetadata.getRoutingNumShards();
        }
        return routingNumShards;
    }

    public static java.util.List<AliasMetadata> resolveAndValidateAliases(String index, Set<Alias> aliases, java.util.List<Map<String, AliasMetadata>> templateAliases, Metadata metadata, AliasValidator aliasValidator, NamedXContentRegistry xContentRegistry, QueryShardContext queryShardContext) {
        ArrayList<AliasMetadata> resolvedAliases = new ArrayList<AliasMetadata>();
        for (Alias alias : aliases) {
            aliasValidator.validateAlias(alias, index, metadata);
            if (Strings.hasLength(alias.filter())) {
                aliasValidator.validateAliasFilter(alias.name(), alias.filter(), queryShardContext, xContentRegistry);
            }
            AliasMetadata aliasMetadata = AliasMetadata.builder(alias.name()).filter(alias.filter()).indexRouting(alias.indexRouting()).searchRouting(alias.searchRouting()).writeIndex(alias.writeIndex()).isHidden(alias.isHidden()).build();
            resolvedAliases.add(aliasMetadata);
        }
        HashMap<String, AliasMetadata> templatesAliases = new HashMap<String, AliasMetadata>();
        for (Map<String, AliasMetadata> templateAliasConfig : templateAliases) {
            for (Map.Entry<String, AliasMetadata> entry : templateAliasConfig.entrySet()) {
                AliasMetadata aliasMetadata = entry.getValue();
                if (aliases.contains(new Alias(aliasMetadata.alias())) || templatesAliases.containsKey(entry.getKey())) continue;
                if (aliasMetadata.alias().contains("{index}")) {
                    String templatedAlias = aliasMetadata.alias().replace("{index}", index);
                    aliasMetadata = AliasMetadata.newAliasMetadata(aliasMetadata, templatedAlias);
                }
                aliasValidator.validateAliasMetadata(aliasMetadata, index, metadata);
                if (aliasMetadata.filter() != null) {
                    aliasValidator.validateAliasFilter(aliasMetadata.alias(), aliasMetadata.filter().uncompressed(), queryShardContext, xContentRegistry);
                }
                templatesAliases.put(aliasMetadata.alias(), aliasMetadata);
                resolvedAliases.add(aliasMetadata);
            }
        }
        return resolvedAliases;
    }

    static ClusterState clusterStateCreateIndex(ClusterState currentState, Set<ClusterBlock> clusterBlocks, IndexMetadata indexMetadata, BiFunction<ClusterState, String, ClusterState> rerouteRoutingTable, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) {
        Metadata.Builder builder = Metadata.builder(currentState.metadata()).put(indexMetadata, false);
        if (metadataTransformer != null) {
            metadataTransformer.accept(builder, indexMetadata);
        }
        Metadata newMetadata = builder.build();
        String indexName = indexMetadata.getIndex().getName();
        ClusterBlocks.Builder blocks = MetadataCreateIndexService.createClusterBlocksBuilder(currentState, indexName, clusterBlocks);
        blocks.updateBlocks(indexMetadata);
        ClusterState updatedState = ClusterState.builder(currentState).blocks(blocks).metadata(newMetadata).build();
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable()).addAsNew(updatedState.metadata().index(indexName));
        updatedState = ClusterState.builder(updatedState).routingTable(routingTableBuilder.build()).build();
        return rerouteRoutingTable.apply(updatedState, "index [" + indexName + "] created");
    }

    static IndexMetadata buildIndexMetadata(String indexName, java.util.List<AliasMetadata> aliases, Supplier<DocumentMapper> documentMapperSupplier, Supplier<DocumentMapper> defaultDocumentMapperSupplier, Settings indexSettings, int routingNumShards, @Nullable IndexMetadata sourceMetadata) {
        IndexMetadata.Builder indexMetadataBuilder = MetadataCreateIndexService.createIndexMetadataBuilder(indexName, sourceMetadata, indexSettings, routingNumShards);
        HashMap<String, MappingMetadata> mappingsMetadata = new HashMap<String, MappingMetadata>();
        for (DocumentMapper mapper : Arrays.asList(documentMapperSupplier.get(), defaultDocumentMapperSupplier.get())) {
            if (mapper == null) continue;
            MappingMetadata mappingMd = new MappingMetadata(mapper);
            mappingsMetadata.put(mapper.type(), mappingMd);
        }
        for (MappingMetadata mappingMd : mappingsMetadata.values()) {
            indexMetadataBuilder.putMapping(mappingMd);
        }
        for (int i = aliases.size() - 1; i >= 0; --i) {
            indexMetadataBuilder.putAlias(aliases.get(i));
        }
        indexMetadataBuilder.state(IndexMetadata.State.OPEN);
        return indexMetadataBuilder.build();
    }

    private static IndexMetadata.Builder createIndexMetadataBuilder(String indexName, @Nullable IndexMetadata sourceMetadata, Settings indexSettings, int routingNumShards) {
        IndexMetadata.Builder builder = IndexMetadata.builder(indexName);
        builder.setRoutingNumShards(routingNumShards);
        builder.settings(indexSettings);
        if (sourceMetadata != null) {
            long primaryTerm = IntStream.range(0, sourceMetadata.getNumberOfShards()).mapToLong(sourceMetadata::primaryTerm).max().getAsLong();
            for (int shardId = 0; shardId < builder.numberOfShards(); ++shardId) {
                builder.primaryTerm(shardId, primaryTerm);
            }
        }
        return builder;
    }

    private static ClusterBlocks.Builder createClusterBlocksBuilder(ClusterState currentState, String index, Set<ClusterBlock> blocks) {
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        if (!blocks.isEmpty()) {
            for (ClusterBlock block : blocks) {
                blocksBuilder.addIndexBlock(index, block);
            }
        }
        return blocksBuilder;
    }

    private static void updateIndexMappingsAndBuildSortOrder(IndexService indexService, Map<String, Map<String, Object>> mappings, @Nullable IndexMetadata sourceMetadata) throws IOException {
        MapperService mapperService = indexService.mapperService();
        if (!mappings.isEmpty()) {
            assert (mappings.size() == 1) : mappings;
            CompressedXContent content = new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(mappings)));
            mapperService.merge(mappings, MapperService.MergeReason.MAPPING_UPDATE);
        }
        if (sourceMetadata == null) {
            indexService.getIndexSortSupplier().get();
        }
    }

    private static void validateActiveShardCount(ActiveShardCount waitForActiveShards, IndexMetadata indexMetadata) {
        if (waitForActiveShards == ActiveShardCount.DEFAULT) {
            waitForActiveShards = indexMetadata.getWaitForActiveShards();
        }
        if (!waitForActiveShards.validate(indexMetadata.getNumberOfReplicas())) {
            throw new IllegalArgumentException("invalid wait_for_active_shards[" + waitForActiveShards + "]: cannot be greater than number of shard copies [" + (indexMetadata.getNumberOfReplicas() + 1) + "]");
        }
    }

    private void validate(CreateIndexClusterStateUpdateRequest request, ClusterState state) {
        this.validateIndexName(request.index(), state);
        this.validateIndexSettings(request.index(), request.settings(), this.forbidPrivateIndexSettings);
    }

    public void validateIndexSettings(String indexName, Settings settings, boolean forbidPrivateIndexSettings) throws IndexCreationException {
        java.util.List<String> validationErrors = this.getIndexSettingsValidationErrors(settings, forbidPrivateIndexSettings);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new IndexCreationException(indexName, validationException);
        }
    }

    public static void checkShardLimit(Settings settings, ClusterState clusterState) {
        int numberOfReplicas;
        int numberOfShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(settings);
        int shardsToCreate = numberOfShards * (1 + (numberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(settings).intValue()));
        Optional<String> shardLimit = IndicesService.checkShardLimit(shardsToCreate, clusterState);
        if (shardLimit.isPresent()) {
            ValidationException e = new ValidationException();
            e.addValidationError(shardLimit.get());
            throw e;
        }
    }

    java.util.List<String> getIndexSettingsValidationErrors(Settings settings, boolean forbidPrivateIndexSettings) {
        java.util.List<String> validationErrors = MetadataCreateIndexService.validateIndexCustomPath(settings, this.env.sharedDataFile());
        if (forbidPrivateIndexSettings) {
            validationErrors.addAll(MetadataCreateIndexService.validatePrivateSettingsNotExplicitlySet(settings, this.indexScopedSettings));
        }
        return validationErrors;
    }

    private static java.util.List<String> validatePrivateSettingsNotExplicitlySet(Settings settings, IndexScopedSettings indexScopedSettings) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (String key : settings.keySet()) {
            Setting<?> setting = indexScopedSettings.get(key);
            if (setting == null) {
                assert (indexScopedSettings.isPrivateSetting(key)) : "expected [" + key + "] to be private but it was not";
                continue;
            }
            if (!setting.isPrivateIndex()) continue;
            validationErrors.add("private index setting [" + key + "] can not be set explicitly");
        }
        return validationErrors;
    }

    private static java.util.List<String> validateIndexCustomPath(Settings settings, @Nullable Path sharedDataPath) {
        String customPath = IndexMetadata.INDEX_DATA_PATH_SETTING.get(settings);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!Strings.isEmpty(customPath)) {
            if (sharedDataPath == null) {
                validationErrors.add("path.shared_data must be set in order to use custom data paths");
            } else {
                Path resolvedPath = PathUtils.get((Path[])new Path[]{sharedDataPath}, (String)customPath);
                if (resolvedPath == null) {
                    validationErrors.add("custom path [" + customPath + "] is not a sub-path of path.shared_data [" + sharedDataPath + "]");
                }
            }
        }
        return validationErrors;
    }

    static java.util.List<String> validateShrinkIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetadata sourceMetadata = MetadataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        assert (IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings));
        IndexMetadata.selectShrinkShards(0, sourceMetadata, IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        if (sourceMetadata.getNumberOfShards() == 1) {
            throw new IllegalArgumentException("can't shrink an index with only one shard");
        }
        IndexRoutingTable table = state.routingTable().index(sourceIndex);
        HashMap<String, AtomicInteger> nodesToNumRouting = new HashMap<String, AtomicInteger>();
        int numShards = sourceMetadata.getNumberOfShards();
        for (ShardRouting routing : table.shardsWithState(ShardRoutingState.STARTED)) {
            nodesToNumRouting.computeIfAbsent(routing.currentNodeId(), s -> new AtomicInteger(0)).incrementAndGet();
        }
        ArrayList<String> nodesToAllocateOn = new ArrayList<String>();
        for (Map.Entry entries : nodesToNumRouting.entrySet()) {
            int numAllocations = ((AtomicInteger)entries.getValue()).get();
            assert (numAllocations <= numShards) : "wait what? " + numAllocations + " is > than num shards " + numShards;
            if (numAllocations != numShards) continue;
            nodesToAllocateOn.add((String)entries.getKey());
        }
        if (nodesToAllocateOn.isEmpty()) {
            throw new IllegalStateException("index " + sourceIndex + " must have all shards allocated on the same node to shrink index");
        }
        return nodesToAllocateOn;
    }

    static void validateSplitIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetadata sourceMetadata = MetadataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        IndexMetadata.selectSplitShard(0, sourceMetadata, IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        if (sourceMetadata.getCreationVersion().before(Version.V_6_0_0_alpha1)) {
            throw new IllegalStateException("source index created version is too old to apply a split operation");
        }
    }

    static void validateCloneIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetadata sourceMetadata = MetadataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        IndexMetadata.selectCloneShard(0, sourceMetadata, IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
    }

    static IndexMetadata validateResize(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        if (state.metadata().hasIndex(targetIndexName)) {
            throw new ResourceAlreadyExistsException(state.metadata().index(targetIndexName).getIndex());
        }
        IndexMetadata sourceMetadata = state.metadata().index(sourceIndex);
        if (sourceMetadata == null) {
            throw new IndexNotFoundException(sourceIndex);
        }
        if (!state.blocks().indexBlocked(ClusterBlockLevel.WRITE, sourceIndex)) {
            throw new IllegalStateException("index " + sourceIndex + " must be read-only to resize index. use \"index.blocks.write=true\"");
        }
        if (targetIndexMappingsTypes.size() > 1 || !(targetIndexMappingsTypes.isEmpty() || targetIndexMappingsTypes.contains("_default_"))) {
            throw new IllegalArgumentException("mappings are not allowed when resizing indices, all mappings are copied from the source index");
        }
        if (IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            IndexMetadata.getRoutingFactor(sourceMetadata.getNumberOfShards(), IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        }
        return sourceMetadata;
    }

    static void prepareResizeIndexSettings(ClusterState currentState, Set<String> mappingKeys, Settings.Builder indexSettingsBuilder, Index resizeSourceIndex, String resizeIntoName, ResizeType type, boolean copySettings, IndexScopedSettings indexScopedSettings) {
        String initialRecoveryIdFilter = IndexMetadata.INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getKey() + "_id";
        IndexMetadata sourceMetadata = currentState.metadata().index(resizeSourceIndex.getName());
        if (type == ResizeType.SHRINK) {
            java.util.List<String> nodesToAllocateOn = MetadataCreateIndexService.validateShrinkIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.put(initialRecoveryIdFilter, Strings.arrayToCommaDelimitedString(nodesToAllocateOn.toArray()));
        } else if (type == ResizeType.SPLIT) {
            MetadataCreateIndexService.validateSplitIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.putNull(initialRecoveryIdFilter);
        } else if (type == ResizeType.CLONE) {
            MetadataCreateIndexService.validateCloneIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.putNull(initialRecoveryIdFilter);
        } else {
            throw new IllegalStateException("unknown resize type is " + (Object)((Object)type));
        }
        Settings.Builder builder = Settings.builder();
        if (copySettings) {
            for (String key : sourceMetadata.getSettings().keySet()) {
                Setting<?> setting = indexScopedSettings.get(key);
                if (setting == null) {
                    assert (indexScopedSettings.isPrivateSetting(key)) : key;
                } else if (setting.getProperties().contains((Object)Setting.Property.NotCopyableOnResize)) continue;
                if (indexSettingsBuilder.keys().contains(key)) continue;
                builder.copy(key, sourceMetadata.getSettings());
            }
        } else {
            Predicate<String> sourceSettingsPredicate = s -> (s.startsWith("index.similarity.") || s.startsWith("index.analysis.") || s.startsWith("index.sort.") || s.equals("index.soft_deletes.enabled")) && !indexSettingsBuilder.keys().contains(s);
            builder.put(sourceMetadata.getSettings().filter(sourceSettingsPredicate));
        }
        indexSettingsBuilder.put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), sourceMetadata.getCreationVersion()).put("index.version.upgraded", sourceMetadata.getUpgradedVersion()).put(builder.build()).put("index.routing_partition_size", sourceMetadata.getRoutingPartitionSize()).put(IndexMetadata.INDEX_RESIZE_SOURCE_NAME.getKey(), resizeSourceIndex.getName()).put(IndexMetadata.INDEX_RESIZE_SOURCE_UUID.getKey(), resizeSourceIndex.getUUID());
    }

    public static int calculateNumRoutingShards(int numShards, Version indexVersionCreated) {
        if (indexVersionCreated.onOrAfter(Version.V_7_0_0)) {
            int log2MaxNumShards = 10;
            int log2NumShards = 32 - Integer.numberOfLeadingZeros(numShards - 1);
            int numSplits = log2MaxNumShards - log2NumShards;
            numSplits = Math.max(1, numSplits);
            return numShards * 1 << numSplits;
        }
        return numShards;
    }

    public static void validateTranslogRetentionSettings(Settings indexSettings) {
        if (IndexSettings.INDEX_SOFT_DELETES_SETTING.get(indexSettings).booleanValue() && (IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(indexSettings) || IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(indexSettings))) {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog("translog_retention", "Translog retention settings [index.translog.retention.age] and [index.translog.retention.size] are deprecated and effectively ignored. They will be removed in a future version.", new Object[0]);
        }
    }
}

