/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.AvgAggregator;
import org.elasticsearch.search.aggregations.metrics.MetricAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

class AvgAggregatorFactory
extends ValuesSourceAggregatorFactory {
    AvgAggregatorFactory(String name, ValuesSourceConfig config, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
    }

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("avg", Arrays.asList(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), (AggregatorSupplier)new MetricAggregatorSupplier(){

            @Override
            public Aggregator build(String name, ValuesSource valuesSource, DocValueFormat formatter, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
                return new AvgAggregator(name, (ValuesSource.Numeric)valuesSource, formatter, context, parent, metadata);
            }
        });
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new AvgAggregator(this.name, null, this.config.format(), searchContext, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "avg");
        if (!(aggregatorSupplier instanceof MetricAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected MetricAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((MetricAggregatorSupplier)aggregatorSupplier).build(this.name, valuesSource, this.config.format(), searchContext, parent, metadata);
    }
}

