/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.PercentilesAggregatorSupplier;
import org.elasticsearch.search.aggregations.metrics.PercentilesConfig;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

class PercentilesAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final double[] percents;
    private final PercentilesConfig percentilesConfig;
    private final boolean keyed;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("percentiles", Arrays.asList(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), (AggregatorSupplier)new PercentilesAggregatorSupplier(){

            @Override
            public Aggregator build(String name, ValuesSource valuesSource, SearchContext context, Aggregator parent, double[] percents, PercentilesConfig percentilesConfig, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
                return percentilesConfig.createPercentilesAggregator(name, valuesSource, context, parent, percents, keyed, formatter, metadata);
            }
        });
    }

    PercentilesAggregatorFactory(String name, ValuesSourceConfig config, double[] percents, PercentilesConfig percentilesConfig, boolean keyed, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.percents = percents;
        this.percentilesConfig = percentilesConfig;
        this.keyed = keyed;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return this.percentilesConfig.createPercentilesAggregator(this.name, null, searchContext, parent, this.percents, this.keyed, this.config.format(), metadata);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "percentiles");
        if (!(aggregatorSupplier instanceof PercentilesAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected PercentilesAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        PercentilesAggregatorSupplier percentilesAggregatorSupplier = (PercentilesAggregatorSupplier)aggregatorSupplier;
        return percentilesAggregatorSupplier.build(this.name, valuesSource, searchContext, parent, this.percents, this.percentilesConfig, this.keyed, this.config.format(), metadata);
    }
}

