/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.nonpersonnel;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetFormulatedCostDetail;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.rate.AbstractBudgetRate;
import org.kuali.coeus.common.budget.framework.rate.ValidCeRateType;
import org.kuali.coeus.propdev.impl.core.AddLineHelper;

public class AddProjectBudgetLineItemHelper
extends AddLineHelper {
    private String editLineIndex;
    private BudgetLineItem budgetLineItem;
    private BudgetPeriod currentTabBudgetPeriod;
    private String budgetCategoryTypeCode;
    private BudgetFormulatedCostDetail budgetFormulatedCostDetail;
    private String budgetFormulatedCostIndex;

    public AddProjectBudgetLineItemHelper() {
        this.initBudgetLineItemDetails();
    }

    @Override
    public void reset() {
        super.reset();
        this.initBudgetLineItemDetails();
    }

    private void initBudgetLineItemDetails() {
        this.editLineIndex = null;
        this.budgetLineItem = new BudgetLineItem();
        this.currentTabBudgetPeriod = new BudgetPeriod();
        this.budgetCategoryTypeCode = "";
    }

    public String getEditLineIndex() {
        return this.editLineIndex;
    }

    public void setEditLineIndex(String editLineIndex) {
        this.editLineIndex = editLineIndex;
    }

    public BudgetLineItem getBudgetLineItem() {
        return this.budgetLineItem;
    }

    public void setBudgetLineItem(BudgetLineItem budgetLineItem) {
        this.budgetLineItem = budgetLineItem;
    }

    public BudgetPeriod getCurrentTabBudgetPeriod() {
        return this.currentTabBudgetPeriod;
    }

    public void setCurrentTabBudgetPeriod(BudgetPeriod currentTabBudgetPeriod) {
        this.currentTabBudgetPeriod = currentTabBudgetPeriod;
    }

    public String getBudgetCategoryTypeCode() {
        return this.budgetCategoryTypeCode;
    }

    public void setBudgetCategoryTypeCode(String budgetCategoryTypeCode) {
        this.budgetCategoryTypeCode = budgetCategoryTypeCode;
    }

    public List<AbstractBudgetRate> getInflationType() {
        ArrayList<AbstractBudgetRate> budgetRates = new ArrayList<AbstractBudgetRate>();
        if (this.budgetLineItem.getCostElementBO() != null) {
            String rateTypeCode = this.getInflationRateTypeCode(this.budgetLineItem.getCostElementBO().getValidCeRateTypes());
            if (this.budgetLineItem.getBudget() != null) {
                budgetRates.addAll(this.getInflationRates(this.budgetLineItem.getBudget().getAllBudgetRates(), rateTypeCode));
            }
        }
        return budgetRates;
    }

    protected String getInflationRateTypeCode(List<ValidCeRateType> validCeRateTypes) {
        for (ValidCeRateType validCeRateType : this.budgetLineItem.getCostElementBO().getValidCeRateTypes()) {
            if (!StringUtils.equals((CharSequence)validCeRateType.getRateClassType(), (CharSequence)RateClassType.INFLATION.getRateClassType())) continue;
            return validCeRateType.getRateTypeCode();
        }
        return null;
    }

    protected List<AbstractBudgetRate> getInflationRates(List<AbstractBudgetRate> budgetRates, String rateTypeCode) {
        ArrayList<AbstractBudgetRate> inflationRates = new ArrayList<AbstractBudgetRate>();
        for (AbstractBudgetRate abstractBudgetRate : this.budgetLineItem.getBudget().getBudgetRates()) {
            DateTime budgetRateStartDate = new DateTime(abstractBudgetRate.getStartDate().getTime());
            DateTime budgetRateEndDate = budgetRateStartDate.plusYears(1).minusDays(1);
            Interval periodInterval = new Interval(this.budgetLineItem.getStartDate().getTime(), this.budgetLineItem.getEndDate().getTime());
            Interval rateInterval = new Interval(budgetRateStartDate.getMillis(), budgetRateEndDate.getMillis());
            if (!StringUtils.equals((CharSequence)rateTypeCode, (CharSequence)abstractBudgetRate.getRateTypeCode()) || !StringUtils.equals((CharSequence)abstractBudgetRate.getRateClassType(), (CharSequence)RateClassType.INFLATION.getRateClassType()) || !this.budgetLineItem.getOnOffCampusFlag().equals(abstractBudgetRate.getOnOffCampusFlag()) || !periodInterval.overlaps((ReadableInterval)rateInterval)) continue;
            inflationRates.add(abstractBudgetRate);
        }
        return inflationRates;
    }

    public BudgetFormulatedCostDetail getBudgetFormulatedCostDetail() {
        return this.budgetFormulatedCostDetail;
    }

    public void setBudgetFormulatedCostDetail(BudgetFormulatedCostDetail budgetFormulatedCostDetail) {
        this.budgetFormulatedCostDetail = budgetFormulatedCostDetail;
    }

    public String getBudgetFormulatedCostIndex() {
        return this.budgetFormulatedCostIndex;
    }

    public void setBudgetFormulatedCostIndex(String budgetFormulatedCostIndex) {
        this.budgetFormulatedCostIndex = budgetFormulatedCostIndex;
    }
}

