/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.history.TransactionDetail;
import org.kuali.kra.timeandmoney.history.TransactionDetailType;
import org.kuali.kra.timeandmoney.service.ActivePendingTransactionsService;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class ActivePendingTransactionsServiceImpl
implements ActivePendingTransactionsService {
    BusinessObjectService businessObjectService;
    AwardAmountInfoService awardAmountInfoService;
    AwardVersionService awardVersionService;
    ParameterService parameterService;
    private PersonService personService;
    protected GenerateAwardAmountInfoFunction sourceDownNodeAmountInfoFunc = (a, b, c, d, e, f) -> this.getUpdatedSourceDownNodeAmountInfo(a, b, c, d, e, f);
    protected GenerateAwardAmountInfoFunction sourceUpNodeAmountInfoFunc = (a, b, c, d, e, f) -> this.getUpdatedSourceUpNodeAmountInfo(a, b, c, d, e, f);
    protected GenerateAwardAmountInfoFunction updatedDestinationUpNodeAmountInfoFunc = (a, b, c, d, e, f) -> this.getUpdatedDestinationUpNodeAmountInfo(a, b, c, d, e, f);
    protected GenerateAwardAmountInfoFunction updatedDestinationDownNodeAmountInfoFunc = (a, b, c, d, e, f) -> this.getUpdatedDestinationDownNodeAmountInfo(a, b, c, d, e, f);
    protected GenerateAwardAmountInfoFunction updatedIntermediateDownNodeAmountInfoFunc = (a, b, c, d, e, f) -> this.getUpdatedIntermediateDownNodeAmountInfo(a, b, c, d, e, f);
    protected GenerateAwardAmountInfoFunction updatedIntermediateUpNodeAmountInfoFunc = (a, b, c, d, e, f) -> this.getUpdatedIntermediateUpNodeAmountInfo(a, b, c, d, e, f);

    @Override
    public void approveTransactions(TimeAndMoneyDocument doc, AwardAmountTransaction newAwardAmountTransaction) {
        HashMap<String, AwardAmountTransaction> awardAmountTransactionItems = new HashMap<String, AwardAmountTransaction>();
        ArrayList<Award> awardItems = new ArrayList<Award>();
        ArrayList<TransactionDetail> transactionDetailItems = new ArrayList<TransactionDetail>();
        this.replaceSessionWithRoutedBy(doc);
        List<AwardAmountTransaction> awardAmountTransactions = this.processTransactions(doc, newAwardAmountTransaction, awardAmountTransactionItems, awardItems, transactionDetailItems, false);
        this.performSave(doc, transactionDetailItems, awardItems, awardAmountTransactions);
    }

    @Override
    public List<AwardAmountTransaction> processTransactions(TimeAndMoneyDocument doc, AwardAmountTransaction newAwardAmountTransaction, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, List<TransactionDetail> transactionDetailItems, Boolean refreshFlag) {
        ArrayList<PendingTransaction> updatedPendingTransactions = new ArrayList<PendingTransaction>();
        ArrayList<PendingTransaction> pendingTransactionsToBeDeleted = new ArrayList<PendingTransaction>();
        updatedPendingTransactions.addAll(doc.getPendingTransactions());
        Map<String, AwardHierarchyNode> awardHierarchyNodes = doc.getAwardHierarchyNodes();
        for (PendingTransaction pendingTransaction : doc.getPendingTransactions()) {
            if (pendingTransaction.getProcessedFlag().booleanValue()) continue;
            AwardHierarchyNode sourceAwardNode = awardHierarchyNodes.get(pendingTransaction.getSourceAwardNumber());
            AwardHierarchyNode destinationAwardNode = awardHierarchyNodes.get(pendingTransaction.getDestinationAwardNumber());
            AwardHierarchyNode parentNode = new AwardHierarchyNode();
            if (!refreshFlag.booleanValue()) {
                pendingTransaction.setProcessedFlag(true);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)pendingTransaction.getSourceAwardNumber(), (CharSequence)"000000-00000")) {
                this.processPendingTransactionWhenSourceIsExternal(doc, newAwardAmountTransaction, updatedPendingTransactions, transactionDetailItems, awardAmountTransactionItems, awardItems, pendingTransaction, awardHierarchyNodes, destinationAwardNode);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)pendingTransaction.getDestinationAwardNumber(), (CharSequence)"000000-00000")) {
                this.processPendingTransactionWhenDestinationIsExternal(doc, newAwardAmountTransaction, updatedPendingTransactions, transactionDetailItems, awardAmountTransactionItems, awardItems, pendingTransaction, awardHierarchyNodes, sourceAwardNode);
            } else if (this.parentChildRelationshipExists(sourceAwardNode.getAwardNumber(), destinationAwardNode.getAwardNumber(), awardHierarchyNodes, parentNode)) {
                this.processPendingTransactionWhenParentChildRelationShipExists(doc, newAwardAmountTransaction, updatedPendingTransactions, parentNode, transactionDetailItems, awardAmountTransactionItems, awardItems, pendingTransaction, awardHierarchyNodes, sourceAwardNode, destinationAwardNode);
            } else if (this.childParentRelationshipExists(destinationAwardNode.getAwardNumber(), sourceAwardNode.getAwardNumber(), awardHierarchyNodes, parentNode)) {
                this.processPendingTransactionWhenChildParentRelationShipExists(doc, newAwardAmountTransaction, updatedPendingTransactions, parentNode, transactionDetailItems, awardAmountTransactionItems, awardItems, pendingTransaction, awardHierarchyNodes, sourceAwardNode, destinationAwardNode);
            } else {
                this.processPendingTransactionWithIndirectRelationship(doc, newAwardAmountTransaction, updatedPendingTransactions, transactionDetailItems, awardAmountTransactionItems, awardItems, pendingTransaction, sourceAwardNode, destinationAwardNode);
            }
            updatedPendingTransactions.remove(pendingTransaction);
            pendingTransactionsToBeDeleted.add(pendingTransaction);
        }
        for (Map.Entry entry : doc.getAwardHierarchyNodes().entrySet()) {
            Award award = this.awardVersionService.getWorkingAwardVersion(((AwardHierarchyNode)entry.getValue()).getAwardNumber());
            AwardAmountInfo awardAmountInfo = this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
            ((AwardHierarchyNode)entry.getValue()).setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
            ((AwardHierarchyNode)entry.getValue()).setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
            ((AwardHierarchyNode)entry.getValue()).setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
            ((AwardHierarchyNode)entry.getValue()).setAnticipatedTotalAmount(awardAmountInfo.getAnticipatedTotalAmount());
            ((AwardHierarchyNode)entry.getValue()).setAnticipatedTotalDirect(awardAmountInfo.getAnticipatedTotalDirect());
            ((AwardHierarchyNode)entry.getValue()).setAnticipatedTotalIndirect(awardAmountInfo.getAnticipatedTotalIndirect());
            ((AwardHierarchyNode)entry.getValue()).setAmountObligatedToDate(awardAmountInfo.getAmountObligatedToDate());
            ((AwardHierarchyNode)entry.getValue()).setObligatedTotalDirect(awardAmountInfo.getObligatedTotalDirect());
            ((AwardHierarchyNode)entry.getValue()).setObligatedTotalIndirect(awardAmountInfo.getObligatedTotalIndirect());
            ((AwardHierarchyNode)entry.getValue()).setObliDistributableAmount(awardAmountInfo.getObliDistributableAmount());
            ((AwardHierarchyNode)entry.getValue()).setAntDistributableAmount(awardAmountInfo.getAntDistributableAmount());
        }
        List<AwardAmountTransaction> awardAmountTransactions = this.prepareAwardAmountTransactionsListForPersistence(awardAmountTransactionItems);
        return awardAmountTransactions;
    }

    @Override
    public List<Award> processTransactionsForAddRuleProcessing(TimeAndMoneyDocument doc, AwardAmountTransaction newAwardAmountTransaction, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, List<TransactionDetail> transactionDetailItems) {
        ArrayList<PendingTransaction> updatedPendingTransactions = new ArrayList<PendingTransaction>();
        ArrayList<PendingTransaction> pendingTransactionsToBeDeleted = new ArrayList<PendingTransaction>();
        updatedPendingTransactions.addAll(doc.getPendingTransactions());
        for (PendingTransaction pendingTransaction : doc.getPendingTransactions()) {
            if (pendingTransaction.getProcessedFlag().booleanValue()) continue;
            Map<String, AwardHierarchyNode> awardHierarchyNodes = doc.getAwardHierarchyNodes();
            AwardHierarchyNode sourceAwardNode = awardHierarchyNodes.get(pendingTransaction.getSourceAwardNumber());
            AwardHierarchyNode destinationAwardNode = awardHierarchyNodes.get(pendingTransaction.getDestinationAwardNumber());
            AwardHierarchyNode parentNode = new AwardHierarchyNode();
            if (StringUtils.equalsIgnoreCase((CharSequence)pendingTransaction.getSourceAwardNumber(), (CharSequence)"000000-00000")) {
                this.processPendingTransactionWhenSourceIsExternal(doc, newAwardAmountTransaction, updatedPendingTransactions, transactionDetailItems, awardAmountTransactionItems, awardItems, pendingTransaction, awardHierarchyNodes, destinationAwardNode);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)pendingTransaction.getDestinationAwardNumber(), (CharSequence)"000000-00000")) {
                this.processPendingTransactionWhenDestinationIsExternal(doc, newAwardAmountTransaction, updatedPendingTransactions, transactionDetailItems, awardAmountTransactionItems, awardItems, pendingTransaction, awardHierarchyNodes, sourceAwardNode);
            } else if (this.parentChildRelationshipExists(sourceAwardNode.getAwardNumber(), destinationAwardNode.getAwardNumber(), awardHierarchyNodes, parentNode)) {
                this.processPendingTransactionWhenParentChildRelationShipExists(doc, newAwardAmountTransaction, updatedPendingTransactions, parentNode, transactionDetailItems, awardAmountTransactionItems, awardItems, pendingTransaction, awardHierarchyNodes, sourceAwardNode, destinationAwardNode);
            } else if (this.childParentRelationshipExists(destinationAwardNode.getAwardNumber(), sourceAwardNode.getAwardNumber(), awardHierarchyNodes, parentNode)) {
                this.processPendingTransactionWhenChildParentRelationShipExists(doc, newAwardAmountTransaction, updatedPendingTransactions, parentNode, transactionDetailItems, awardAmountTransactionItems, awardItems, pendingTransaction, awardHierarchyNodes, sourceAwardNode, destinationAwardNode);
            } else {
                this.processPendingTransactionWithIndirectRelationship(doc, newAwardAmountTransaction, updatedPendingTransactions, transactionDetailItems, awardAmountTransactionItems, awardItems, pendingTransaction, sourceAwardNode, destinationAwardNode);
            }
            updatedPendingTransactions.remove(pendingTransaction);
            pendingTransactionsToBeDeleted.add(pendingTransaction);
        }
        return awardItems;
    }

    protected List<AwardAmountTransaction> prepareAwardAmountTransactionsListForPersistence(Map<String, AwardAmountTransaction> awardAmountTransactionItems) {
        ArrayList<AwardAmountTransaction> awardAmountTransactions = new ArrayList<AwardAmountTransaction>();
        for (Map.Entry<String, AwardAmountTransaction> awardAmountTransaction : awardAmountTransactionItems.entrySet()) {
            awardAmountTransactions.add(awardAmountTransaction.getValue());
        }
        return awardAmountTransactions;
    }

    protected void performSave(TimeAndMoneyDocument doc, List<TransactionDetail> transactionDetailItems, List<Award> awardItems, List<AwardAmountTransaction> awardAmountTransactions) {
        this.businessObjectService.save(transactionDetailItems);
        this.businessObjectService.save(awardAmountTransactions);
        this.businessObjectService.save(awardItems);
        this.businessObjectService.save((PersistableBusinessObject)doc);
    }

    protected void processPendingTransactionWithIndirectRelationship(TimeAndMoneyDocument doc, AwardAmountTransaction newAwardAmountTransaction, List<PendingTransaction> updatedPendingTransactions, List<TransactionDetail> transactionDetailItems, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, PendingTransaction pendingTransaction, AwardHierarchyNode sourceAwardNode, AwardHierarchyNode destinationAwardNode) {
        AwardHierarchyNode parentNode = new AwardHierarchyNode();
        String commonParent = this.findCommonParent(doc.getAwardHierarchyNodes(), sourceAwardNode.getRootAwardNumber(), sourceAwardNode.getAwardNumber(), destinationAwardNode.getAwardNumber());
        this.processPendingTransactionWhenChildParentRelationShipExistsIndirect(doc, newAwardAmountTransaction, updatedPendingTransactions, parentNode, transactionDetailItems, awardAmountTransactionItems, awardItems, pendingTransaction, doc.getAwardHierarchyNodes(), sourceAwardNode, doc.getAwardHierarchyNodes().get(commonParent));
        this.processPendingTransactionWhenParentChildRelationShipExistsIndirect(doc, newAwardAmountTransaction, updatedPendingTransactions, parentNode, transactionDetailItems, awardAmountTransactionItems, awardItems, pendingTransaction, doc.getAwardHierarchyNodes(), doc.getAwardHierarchyNodes().get(commonParent), destinationAwardNode);
        this.addTransactionDetails(sourceAwardNode.getAwardNumber(), destinationAwardNode.getAwardNumber(), doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.PRIMARY);
    }

    protected void processPendingTransactionWhenSourceIsExternal(TimeAndMoneyDocument doc, AwardAmountTransaction newAwardAmountTransaction, List<PendingTransaction> updatedPendingTransactions, List<TransactionDetail> transactionDetailItems, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, PendingTransaction pendingTransaction, Map<String, AwardHierarchyNode> awardHierarchyNodes, AwardHierarchyNode destinationAwardNode) {
        if (StringUtils.equalsIgnoreCase((CharSequence)pendingTransaction.getDestinationAwardNumber(), (CharSequence)destinationAwardNode.getRootAwardNumber())) {
            this.handleTransaction(pendingTransaction, destinationAwardNode.getAwardNumber(), awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.updatedDestinationDownNodeAmountInfoFunc);
            this.addTransactionDetails("000000-00000", destinationAwardNode.getAwardNumber(), doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.PRIMARY);
            this.addTransactionDetails("000000-00000", destinationAwardNode.getAwardNumber(), doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.INTERMEDIATE);
        } else {
            this.createIntermediateTransactionsWhenParentIsExternal(doc, awardAmountTransactionItems, awardItems, pendingTransaction, destinationAwardNode.getAwardNumber(), awardHierarchyNodes.get(destinationAwardNode.getAwardNumber()).getParentAwardNumber(), "000000-00000", true, transactionDetailItems, updatedPendingTransactions, newAwardAmountTransaction);
            this.handleTransaction(pendingTransaction, destinationAwardNode.getAwardNumber(), awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.updatedDestinationDownNodeAmountInfoFunc);
            this.addTransactionDetails("000000-00000", destinationAwardNode.getAwardNumber(), doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.PRIMARY);
        }
    }

    protected void processPendingTransactionWhenDestinationIsExternal(TimeAndMoneyDocument doc, AwardAmountTransaction newAwardAmountTransaction, List<PendingTransaction> updatedPendingTransactions, List<TransactionDetail> transactionDetailItems, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, PendingTransaction pendingTransaction, Map<String, AwardHierarchyNode> awardHierarchyNodes, AwardHierarchyNode sourceAwardNode) {
        if (StringUtils.equalsIgnoreCase((CharSequence)sourceAwardNode.getParentAwardNumber(), (CharSequence)"000000-00000")) {
            this.handleTransaction(pendingTransaction, sourceAwardNode.getAwardNumber(), awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.sourceUpNodeAmountInfoFunc);
            this.addTransactionDetails(pendingTransaction.getSourceAwardNumber(), "000000-00000", doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.PRIMARY);
            this.addTransactionDetails(pendingTransaction.getSourceAwardNumber(), "000000-00000", doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.INTERMEDIATE);
        } else {
            this.handleTransaction(pendingTransaction, sourceAwardNode.getAwardNumber(), awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.sourceUpNodeAmountInfoFunc);
            this.addTransactionDetails(pendingTransaction.getSourceAwardNumber(), "000000-00000", doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.PRIMARY);
            this.createIntermediateTransactionsWhenDestinationIsExternal(doc, awardAmountTransactionItems, awardItems, pendingTransaction, sourceAwardNode.getAwardNumber(), awardHierarchyNodes.get(sourceAwardNode.getAwardNumber()).getParentAwardNumber(), "000000-00000", true, transactionDetailItems, updatedPendingTransactions, newAwardAmountTransaction);
        }
    }

    protected void processPendingTransactionWhenParentChildRelationShipExists(TimeAndMoneyDocument doc, AwardAmountTransaction newAwardAmountTransaction, List<PendingTransaction> updatedPendingTransactions, AwardHierarchyNode parentNode, List<TransactionDetail> transactionDetailItems, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, PendingTransaction pendingTransaction, Map<String, AwardHierarchyNode> awardHierarchyNodes, AwardHierarchyNode sourceAwardNode, AwardHierarchyNode destinationAwardNode) {
        this.handleTransaction(pendingTransaction, sourceAwardNode.getAwardNumber(), awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.sourceDownNodeAmountInfoFunc);
        if (!destinationAwardNode.getParentAwardNumber().equals(sourceAwardNode.getAwardNumber())) {
            this.createIntermediateDownTransactionsWhenParentChildRelationshipExists(doc, awardAmountTransactionItems, awardItems, pendingTransaction, destinationAwardNode.getAwardNumber(), awardHierarchyNodes.get(destinationAwardNode.getAwardNumber()).getParentAwardNumber(), sourceAwardNode.getAwardNumber(), transactionDetailItems, updatedPendingTransactions, newAwardAmountTransaction);
        }
        this.handleTransaction(pendingTransaction, destinationAwardNode.getAwardNumber(), awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.updatedDestinationDownNodeAmountInfoFunc);
        this.addTransactionDetails(pendingTransaction.getSourceAwardNumber(), destinationAwardNode.getAwardNumber(), doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.PRIMARY);
        if (destinationAwardNode.getParentAwardNumber().equals(sourceAwardNode.getAwardNumber())) {
            this.addTransactionDetails(pendingTransaction.getSourceAwardNumber(), destinationAwardNode.getAwardNumber(), doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.INTERMEDIATE);
        }
    }

    protected void processPendingTransactionWhenParentChildRelationShipExistsIndirect(TimeAndMoneyDocument doc, AwardAmountTransaction newAwardAmountTransaction, List<PendingTransaction> updatedPendingTransactions, AwardHierarchyNode parentNode, List<TransactionDetail> transactionDetailItems, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, PendingTransaction pendingTransaction, Map<String, AwardHierarchyNode> awardHierarchyNodes, AwardHierarchyNode sourceAwardNode, AwardHierarchyNode destinationAwardNode) {
        if (!destinationAwardNode.getAwardNumber().equals(sourceAwardNode.getAwardNumber())) {
            this.createIntermediateDownTransactionsWhenParentChildRelationshipExists(doc, awardAmountTransactionItems, awardItems, pendingTransaction, destinationAwardNode.getAwardNumber(), awardHierarchyNodes.get(destinationAwardNode.getAwardNumber()).getParentAwardNumber(), sourceAwardNode.getAwardNumber(), transactionDetailItems, updatedPendingTransactions, newAwardAmountTransaction);
        }
        this.handleTransaction(pendingTransaction, destinationAwardNode.getAwardNumber(), awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.updatedDestinationDownNodeAmountInfoFunc);
    }

    protected void processPendingTransactionWhenChildParentRelationShipExists(TimeAndMoneyDocument doc, AwardAmountTransaction newAwardAmountTransaction, List<PendingTransaction> updatedPendingTransactions, AwardHierarchyNode parentNode, List<TransactionDetail> transactionDetailItems, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, PendingTransaction pendingTransaction, Map<String, AwardHierarchyNode> awardHierarchyNodes, AwardHierarchyNode sourceAwardNode, AwardHierarchyNode destinationAwardNode) {
        this.handleTransaction(pendingTransaction, sourceAwardNode.getAwardNumber(), awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.sourceUpNodeAmountInfoFunc);
        if (!sourceAwardNode.getParentAwardNumber().equals(destinationAwardNode.getAwardNumber())) {
            this.createIntermediateUpTransactionsWhenParentChildRelationshipExists(doc, awardAmountTransactionItems, awardItems, pendingTransaction, destinationAwardNode.getAwardNumber(), awardHierarchyNodes.get(sourceAwardNode.getAwardNumber()).getParentAwardNumber(), awardHierarchyNodes.get(sourceAwardNode.getAwardNumber()).getAwardNumber(), transactionDetailItems, updatedPendingTransactions, newAwardAmountTransaction);
        }
        this.handleTransaction(pendingTransaction, destinationAwardNode.getAwardNumber(), awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.updatedDestinationUpNodeAmountInfoFunc);
        this.addTransactionDetails(pendingTransaction.getSourceAwardNumber(), destinationAwardNode.getAwardNumber(), doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.PRIMARY);
        if (sourceAwardNode.getParentAwardNumber().equals(destinationAwardNode.getAwardNumber())) {
            this.addTransactionDetails(pendingTransaction.getSourceAwardNumber(), destinationAwardNode.getAwardNumber(), doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.INTERMEDIATE);
        }
    }

    protected void processPendingTransactionWhenChildParentRelationShipExistsIndirect(TimeAndMoneyDocument doc, AwardAmountTransaction newAwardAmountTransaction, List<PendingTransaction> updatedPendingTransactions, AwardHierarchyNode parentNode, List<TransactionDetail> transactionDetailItems, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, PendingTransaction pendingTransaction, Map<String, AwardHierarchyNode> awardHierarchyNodes, AwardHierarchyNode sourceAwardNode, AwardHierarchyNode destinationAwardNode) {
        this.handleTransaction(pendingTransaction, sourceAwardNode.getAwardNumber(), awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.sourceUpNodeAmountInfoFunc);
        if (!sourceAwardNode.getParentAwardNumber().equals(destinationAwardNode.getAwardNumber())) {
            this.createIntermediateUpTransactionsWhenParentChildRelationshipExists(doc, awardAmountTransactionItems, awardItems, pendingTransaction, destinationAwardNode.getAwardNumber(), awardHierarchyNodes.get(sourceAwardNode.getAwardNumber()).getParentAwardNumber(), awardHierarchyNodes.get(sourceAwardNode.getAwardNumber()).getAwardNumber(), transactionDetailItems, updatedPendingTransactions, newAwardAmountTransaction);
        }
    }

    protected void createIntermediateDownTransactionsWhenParentChildRelationshipExists(TimeAndMoneyDocument doc, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, PendingTransaction pendingTransaction, String destinationAwardNumber, String parentAwardNumber, String sourceAwardNumber, List<TransactionDetail> transactionDetailItems, List<PendingTransaction> updatedPendingTransactions, AwardAmountTransaction newAwardAmountTransaction) {
        ArrayList<TransactionDetail> transactionDetailList = new ArrayList<TransactionDetail>();
        while (!StringUtils.equalsIgnoreCase((CharSequence)parentAwardNumber, (CharSequence)sourceAwardNumber)) {
            this.handleTransaction(pendingTransaction, parentAwardNumber, awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.updatedIntermediateDownNodeAmountInfoFunc);
            transactionDetailList.add(this.createTransactionDetail(parentAwardNumber, destinationAwardNumber, doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), TransactionDetailType.INTERMEDIATE));
            parentAwardNumber = doc.getAwardHierarchyNodes().get(parentAwardNumber).getParentAwardNumber();
            destinationAwardNumber = doc.getAwardHierarchyNodes().get(destinationAwardNumber).getParentAwardNumber();
        }
        this.addTransactionDetails(parentAwardNumber, destinationAwardNumber, doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.INTERMEDIATE);
        Collections.reverse(transactionDetailList);
        transactionDetailItems.addAll(transactionDetailList);
    }

    protected void createIntermediateUpTransactionsWhenParentChildRelationshipExists(TimeAndMoneyDocument doc, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, PendingTransaction pendingTransaction, String destinationAwardNumber, String parentOfSourceAwardNumber, String sourceAwardNumber, List<TransactionDetail> transactionDetailItems, List<PendingTransaction> updatedPendingTransactions, AwardAmountTransaction newAwardAmountTransaction) {
        while (!StringUtils.equalsIgnoreCase((CharSequence)destinationAwardNumber, (CharSequence)parentOfSourceAwardNumber)) {
            this.handleTransaction(pendingTransaction, parentOfSourceAwardNumber, awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.updatedIntermediateUpNodeAmountInfoFunc);
            this.addTransactionDetails(sourceAwardNumber, parentOfSourceAwardNumber, doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.INTERMEDIATE);
            sourceAwardNumber = doc.getAwardHierarchyNodes().get(sourceAwardNumber).getParentAwardNumber();
            parentOfSourceAwardNumber = doc.getAwardHierarchyNodes().get(parentOfSourceAwardNumber).getParentAwardNumber();
        }
        this.addTransactionDetails(sourceAwardNumber, parentOfSourceAwardNumber, doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.INTERMEDIATE);
    }

    protected void createIntermediateTransactionsWhenParentIsExternal(TimeAndMoneyDocument doc, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, PendingTransaction pendingTransaction, String destinationAwardNumber, String parentAwardNumber, String defaultExternalAwardNumber, boolean direction, List<TransactionDetail> transactionDetailItems, List<PendingTransaction> updatedPendingTransactions, AwardAmountTransaction newAwardAmountTransaction) {
        ArrayList<TransactionDetail> transactionDetailList = new ArrayList<TransactionDetail>();
        while (!StringUtils.equalsIgnoreCase((CharSequence)parentAwardNumber, (CharSequence)"000000-00000")) {
            this.handleTransaction(pendingTransaction, parentAwardNumber, awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.updatedIntermediateDownNodeAmountInfoFunc);
            transactionDetailList.add(this.createTransactionDetail(parentAwardNumber, destinationAwardNumber, doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), TransactionDetailType.INTERMEDIATE));
            parentAwardNumber = doc.getAwardHierarchyNodes().get(parentAwardNumber).getParentAwardNumber();
            destinationAwardNumber = doc.getAwardHierarchyNodes().get(destinationAwardNumber).getParentAwardNumber();
        }
        this.addTransactionDetails(parentAwardNumber, destinationAwardNumber, doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.INTERMEDIATE);
        Collections.reverse(transactionDetailList);
        transactionDetailItems.addAll(transactionDetailList);
    }

    protected void createIntermediateTransactionsWhenDestinationIsExternal(TimeAndMoneyDocument doc, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, PendingTransaction pendingTransaction, String sourceAwardNumber, String parentOfSourceAwardNumber, String destinationAwardNumber, boolean direction, List<TransactionDetail> transactionDetailItems, List<PendingTransaction> updatedPendingTransactions, AwardAmountTransaction newAwardAmountTransaction) {
        while (!StringUtils.equalsIgnoreCase((CharSequence)parentOfSourceAwardNumber, (CharSequence)"000000-00000")) {
            this.handleTransaction(pendingTransaction, parentOfSourceAwardNumber, awardAmountTransactionItems, awardItems, updatedPendingTransactions, newAwardAmountTransaction, doc.getDocumentNumber(), this.updatedIntermediateUpNodeAmountInfoFunc);
            this.addTransactionDetails(sourceAwardNumber, parentOfSourceAwardNumber, doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.INTERMEDIATE);
            parentOfSourceAwardNumber = doc.getAwardHierarchyNodes().get(parentOfSourceAwardNumber).getParentAwardNumber();
            sourceAwardNumber = doc.getAwardHierarchyNodes().get(sourceAwardNumber).getParentAwardNumber();
        }
        this.addTransactionDetails(sourceAwardNumber, parentOfSourceAwardNumber, doc.getAward().getSequenceNumber(), pendingTransaction, doc.getAwardNumber(), doc.getDocumentNumber(), transactionDetailItems, TransactionDetailType.INTERMEDIATE);
    }

    protected boolean parentChildRelationshipExists(String awardNumber1, String awardNumber2, Map<String, AwardHierarchyNode> awardHierarchyNodes, AwardHierarchyNode parentNode) {
        boolean parentChild = Boolean.FALSE;
        String parentAwardNumber = awardHierarchyNodes.get(awardNumber2).getParentAwardNumber();
        while (!StringUtils.equalsIgnoreCase((CharSequence)parentAwardNumber, (CharSequence)"000000-00000")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)parentAwardNumber, (CharSequence)awardNumber1)) {
                parentChild = Boolean.TRUE;
                break;
            }
            parentAwardNumber = awardHierarchyNodes.get(parentAwardNumber).getParentAwardNumber();
        }
        if (parentChild) {
            parentNode.setAwardNumber(awardHierarchyNodes.get(parentAwardNumber).getAwardNumber());
        }
        return parentChild;
    }

    protected boolean childParentRelationshipExists(String awardNumber1, String awardNumber2, Map<String, AwardHierarchyNode> awardHierarchyNodes, AwardHierarchyNode parentNode) {
        boolean parentChild = Boolean.FALSE;
        String parentAwardNumber = awardHierarchyNodes.get(awardNumber2).getParentAwardNumber();
        while (!StringUtils.equalsIgnoreCase((CharSequence)parentAwardNumber, (CharSequence)"000000-00000")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)parentAwardNumber, (CharSequence)awardNumber1)) {
                parentChild = Boolean.TRUE;
                break;
            }
            parentAwardNumber = awardHierarchyNodes.get(parentAwardNumber).getParentAwardNumber();
        }
        if (parentChild) {
            parentNode.setAwardNumber(awardHierarchyNodes.get(parentAwardNumber).getAwardNumber());
        }
        return parentChild;
    }

    protected TransactionDetail createTransactionDetail(String sourceAwardNumber, String destinationAwardNumber, Integer sequenceNumber, PendingTransaction pendingTransaction, String currentAwardNumber, String documentNumber, TransactionDetailType transactionDetailtype) {
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setSourceAwardNumber(sourceAwardNumber);
        transactionDetail.setSequenceNumber(sequenceNumber);
        transactionDetail.setDestinationAwardNumber(destinationAwardNumber);
        transactionDetail.setAnticipatedAmount(pendingTransaction.getAnticipatedAmount());
        transactionDetail.setAnticipatedDirectAmount(pendingTransaction.getAnticipatedDirectAmount());
        transactionDetail.setAnticipatedIndirectAmount(pendingTransaction.getAnticipatedIndirectAmount());
        transactionDetail.setObligatedAmount(pendingTransaction.getObligatedAmount());
        transactionDetail.setObligatedDirectAmount(pendingTransaction.getObligatedDirectAmount());
        transactionDetail.setObligatedIndirectAmount(pendingTransaction.getObligatedIndirectAmount());
        transactionDetail.setAwardNumber(currentAwardNumber);
        transactionDetail.setTransactionId(pendingTransaction.getTransactionId());
        transactionDetail.setTimeAndMoneyDocumentNumber(documentNumber);
        transactionDetail.setComments(pendingTransaction.getComments());
        transactionDetail.setTransactionDetailType(transactionDetailtype.toString());
        return transactionDetail;
    }

    protected void addTransactionDetails(String sourceAwardNumber, String destinationAwardNumber, Integer sequenceNumber, PendingTransaction pendingTransaction, String currentAwardNumber, String documentNumber, List<TransactionDetail> transactionDetailItems, TransactionDetailType transactionDetailtype) {
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setSourceAwardNumber(sourceAwardNumber);
        transactionDetail.setSequenceNumber(sequenceNumber);
        transactionDetail.setDestinationAwardNumber(destinationAwardNumber);
        transactionDetail.setAnticipatedAmount(pendingTransaction.getAnticipatedAmount());
        transactionDetail.setAnticipatedDirectAmount(pendingTransaction.getAnticipatedDirectAmount());
        transactionDetail.setAnticipatedIndirectAmount(pendingTransaction.getAnticipatedIndirectAmount());
        transactionDetail.setObligatedAmount(pendingTransaction.getObligatedAmount());
        transactionDetail.setObligatedDirectAmount(pendingTransaction.getObligatedDirectAmount());
        transactionDetail.setObligatedIndirectAmount(pendingTransaction.getObligatedIndirectAmount());
        transactionDetail.setAwardNumber(currentAwardNumber);
        transactionDetail.setTransactionId(pendingTransaction.getTransactionId());
        transactionDetail.setTimeAndMoneyDocumentNumber(documentNumber);
        transactionDetail.setComments(pendingTransaction.getComments());
        transactionDetail.setTransactionDetailType(transactionDetailtype.toString());
        transactionDetailItems.add(transactionDetail);
    }

    protected String findCommonParent(Map<String, AwardHierarchyNode> awardHierarchyNodes, String rootAwardNumber, String sourceAwardNumber, String destinationAwardNumber) {
        ArrayList<String> listOfParentsOfSource = new ArrayList<String>();
        ArrayList<String> listOfParentsOfDestination = new ArrayList<String>();
        String commonParent = null;
        this.buildListOfParents(awardHierarchyNodes, listOfParentsOfSource, sourceAwardNumber, rootAwardNumber);
        this.buildListOfParents(awardHierarchyNodes, listOfParentsOfDestination, destinationAwardNumber, rootAwardNumber);
        for (String an1 : listOfParentsOfSource) {
            for (String an2 : listOfParentsOfDestination) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)an1, (CharSequence)an2)) continue;
                commonParent = an1;
                break;
            }
            if (commonParent == null) continue;
            break;
        }
        return commonParent;
    }

    protected void buildListOfParents(Map<String, AwardHierarchyNode> awardHierarchyNodes, List<String> listOfParentsOfSource, String currentAwardNumber, String rootAwardNumber) {
        while (!StringUtils.equalsIgnoreCase((CharSequence)currentAwardNumber, (CharSequence)rootAwardNumber)) {
            String parentAwardNumber = awardHierarchyNodes.get(currentAwardNumber).getParentAwardNumber();
            listOfParentsOfSource.add(parentAwardNumber);
            currentAwardNumber = parentAwardNumber;
        }
    }

    protected AwardAmountInfo getUpdatedDestinationDownNodeAmountInfo(PendingTransaction pendingTransaction, AwardAmountInfo awardAmountInfo, Map<String, AwardAmountTransaction> awardAmountTransactionItems, AwardAmountTransaction newAwardAmountTransaction, String documentNumber, Award award) {
        AwardAmountInfo newAwardAmountInfo = this.getNewAwardAmountInfo();
        newAwardAmountInfo.setAwardNumber(awardAmountInfo.getAwardNumber());
        newAwardAmountInfo.setSequenceNumber(award.getSequenceNumber());
        newAwardAmountInfo.setOriginatingAwardVersion(award.getSequenceNumber());
        newAwardAmountInfo.setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
        newAwardAmountInfo.setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
        newAwardAmountInfo.setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
        newAwardAmountInfo.setTimeAndMoneyDocumentNumber(documentNumber);
        newAwardAmountInfo.setTransactionId(pendingTransaction.getTransactionId());
        newAwardAmountInfo.setObligatedChange(pendingTransaction.getObligatedAmount());
        newAwardAmountInfo.setAnticipatedChange(pendingTransaction.getAnticipatedAmount());
        newAwardAmountInfo.setObliDistributableAmount((ScaleTwoDecimal)awardAmountInfo.getObliDistributableAmount().add((AbstractDecimal)pendingTransaction.getObligatedAmount()));
        newAwardAmountInfo.setAmountObligatedToDate((ScaleTwoDecimal)awardAmountInfo.getAmountObligatedToDate().add((AbstractDecimal)pendingTransaction.getObligatedAmount()));
        newAwardAmountInfo.setObligatedTotalDirect((ScaleTwoDecimal)awardAmountInfo.getObligatedTotalDirect().add((AbstractDecimal)pendingTransaction.getObligatedDirectAmount()));
        newAwardAmountInfo.setObligatedTotalIndirect((ScaleTwoDecimal)awardAmountInfo.getObligatedTotalIndirect().add((AbstractDecimal)pendingTransaction.getObligatedIndirectAmount()));
        newAwardAmountInfo.setAntDistributableAmount((ScaleTwoDecimal)awardAmountInfo.getAntDistributableAmount().add((AbstractDecimal)pendingTransaction.getAnticipatedAmount()));
        newAwardAmountInfo.setAnticipatedTotalAmount((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalAmount().add((AbstractDecimal)pendingTransaction.getAnticipatedAmount()));
        newAwardAmountInfo.setAnticipatedTotalDirect((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalDirect().add((AbstractDecimal)pendingTransaction.getAnticipatedDirectAmount()));
        newAwardAmountInfo.setAnticipatedTotalIndirect((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalIndirect().add((AbstractDecimal)pendingTransaction.getAnticipatedIndirectAmount()));
        newAwardAmountInfo.setObligatedChangeDirect(pendingTransaction.getObligatedDirectAmount());
        newAwardAmountInfo.setObligatedChangeIndirect(pendingTransaction.getObligatedIndirectAmount());
        newAwardAmountInfo.setAnticipatedChangeDirect(pendingTransaction.getAnticipatedDirectAmount());
        newAwardAmountInfo.setAnticipatedChangeIndirect(pendingTransaction.getAnticipatedIndirectAmount());
        this.addAwardAmountTransaction(newAwardAmountInfo.getAwardNumber(), awardAmountTransactionItems, newAwardAmountTransaction, documentNumber);
        return newAwardAmountInfo;
    }

    AwardAmountInfo getNewAwardAmountInfo() {
        return new AwardAmountInfo();
    }

    protected AwardAmountInfo getUpdatedDestinationUpNodeAmountInfo(PendingTransaction pendingTransaction, AwardAmountInfo awardAmountInfo, Map<String, AwardAmountTransaction> awardAmountTransactionItems, AwardAmountTransaction newAwardAmountTransaction, String documentNumber, Award award) {
        AwardAmountInfo newAwardAmountInfo = this.getNewAwardAmountInfo();
        newAwardAmountInfo.setAwardNumber(awardAmountInfo.getAwardNumber());
        newAwardAmountInfo.setSequenceNumber(award.getSequenceNumber());
        newAwardAmountInfo.setOriginatingAwardVersion(award.getSequenceNumber());
        newAwardAmountInfo.setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
        newAwardAmountInfo.setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
        newAwardAmountInfo.setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
        newAwardAmountInfo.setTimeAndMoneyDocumentNumber(documentNumber);
        newAwardAmountInfo.setTransactionId(pendingTransaction.getTransactionId());
        newAwardAmountInfo.setObligatedChange(ScaleTwoDecimal.ZERO);
        newAwardAmountInfo.setAnticipatedChange(ScaleTwoDecimal.ZERO);
        newAwardAmountInfo.setObliDistributableAmount((ScaleTwoDecimal)awardAmountInfo.getObliDistributableAmount().add((AbstractDecimal)pendingTransaction.getObligatedAmount()));
        newAwardAmountInfo.setAmountObligatedToDate(awardAmountInfo.getAmountObligatedToDate());
        newAwardAmountInfo.setObligatedTotalDirect(awardAmountInfo.getObligatedTotalDirect());
        newAwardAmountInfo.setObligatedTotalIndirect(awardAmountInfo.getObligatedTotalIndirect());
        newAwardAmountInfo.setAntDistributableAmount((ScaleTwoDecimal)awardAmountInfo.getAntDistributableAmount().add((AbstractDecimal)pendingTransaction.getAnticipatedAmount()));
        newAwardAmountInfo.setAnticipatedTotalAmount(awardAmountInfo.getAnticipatedTotalAmount());
        newAwardAmountInfo.setAnticipatedTotalDirect(awardAmountInfo.getAnticipatedTotalDirect());
        newAwardAmountInfo.setAnticipatedTotalIndirect(awardAmountInfo.getAnticipatedTotalIndirect());
        newAwardAmountInfo.setObligatedChangeDirect(pendingTransaction.getObligatedDirectAmount());
        newAwardAmountInfo.setObligatedChangeIndirect(pendingTransaction.getObligatedIndirectAmount());
        newAwardAmountInfo.setAnticipatedChangeDirect(pendingTransaction.getAnticipatedDirectAmount());
        newAwardAmountInfo.setAnticipatedChangeIndirect(pendingTransaction.getAnticipatedIndirectAmount());
        this.addAwardAmountTransaction(newAwardAmountInfo.getAwardNumber(), awardAmountTransactionItems, newAwardAmountTransaction, documentNumber);
        return newAwardAmountInfo;
    }

    protected AwardAmountInfo getUpdatedSourceDownNodeAmountInfo(PendingTransaction pendingTransaction, AwardAmountInfo awardAmountInfo, Map<String, AwardAmountTransaction> awardAmountTransactionItems, AwardAmountTransaction newAwardAmountTransaction, String documentNumber, Award award) {
        AwardAmountInfo newAwardAmountInfo = this.getNewAwardAmountInfo();
        newAwardAmountInfo.setAwardNumber(awardAmountInfo.getAwardNumber());
        newAwardAmountInfo.setSequenceNumber(award.getSequenceNumber());
        newAwardAmountInfo.setOriginatingAwardVersion(award.getSequenceNumber());
        newAwardAmountInfo.setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
        newAwardAmountInfo.setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
        newAwardAmountInfo.setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
        newAwardAmountInfo.setTimeAndMoneyDocumentNumber(documentNumber);
        newAwardAmountInfo.setTransactionId(pendingTransaction.getTransactionId());
        newAwardAmountInfo.setObligatedChange(ScaleTwoDecimal.ZERO);
        newAwardAmountInfo.setAnticipatedChange(ScaleTwoDecimal.ZERO);
        newAwardAmountInfo.setObliDistributableAmount((ScaleTwoDecimal)awardAmountInfo.getObliDistributableAmount().subtract((AbstractDecimal)pendingTransaction.getObligatedAmount()));
        newAwardAmountInfo.setAmountObligatedToDate(awardAmountInfo.getAmountObligatedToDate());
        newAwardAmountInfo.setObligatedTotalDirect(awardAmountInfo.getObligatedTotalDirect());
        newAwardAmountInfo.setObligatedTotalIndirect(awardAmountInfo.getObligatedTotalIndirect());
        newAwardAmountInfo.setAntDistributableAmount((ScaleTwoDecimal)awardAmountInfo.getAntDistributableAmount().subtract((AbstractDecimal)pendingTransaction.getAnticipatedAmount()));
        newAwardAmountInfo.setAnticipatedTotalAmount(awardAmountInfo.getAnticipatedTotalAmount());
        newAwardAmountInfo.setAnticipatedTotalDirect(awardAmountInfo.getAnticipatedTotalDirect());
        newAwardAmountInfo.setAnticipatedTotalIndirect(awardAmountInfo.getAnticipatedTotalIndirect());
        newAwardAmountInfo.setObligatedChangeDirect(pendingTransaction.getObligatedDirectAmount());
        newAwardAmountInfo.setObligatedChangeIndirect(pendingTransaction.getObligatedIndirectAmount());
        newAwardAmountInfo.setAnticipatedChangeDirect(pendingTransaction.getAnticipatedDirectAmount());
        newAwardAmountInfo.setAnticipatedChangeIndirect(pendingTransaction.getAnticipatedIndirectAmount());
        this.addAwardAmountTransaction(newAwardAmountInfo.getAwardNumber(), awardAmountTransactionItems, newAwardAmountTransaction, documentNumber);
        return newAwardAmountInfo;
    }

    protected AwardAmountInfo getUpdatedSourceUpNodeAmountInfo(PendingTransaction pendingTransaction, AwardAmountInfo awardAmountInfo, Map<String, AwardAmountTransaction> awardAmountTransactionItems, AwardAmountTransaction newAwardAmountTransaction, String documentNumber, Award award) {
        AwardAmountInfo newAwardAmountInfo = this.getNewAwardAmountInfo();
        newAwardAmountInfo.setAwardNumber(awardAmountInfo.getAwardNumber());
        newAwardAmountInfo.setSequenceNumber(award.getSequenceNumber());
        newAwardAmountInfo.setOriginatingAwardVersion(award.getSequenceNumber());
        newAwardAmountInfo.setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
        newAwardAmountInfo.setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
        newAwardAmountInfo.setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
        newAwardAmountInfo.setTimeAndMoneyDocumentNumber(documentNumber);
        newAwardAmountInfo.setTransactionId(pendingTransaction.getTransactionId());
        newAwardAmountInfo.setObligatedChange((ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)pendingTransaction.getObligatedAmount()));
        newAwardAmountInfo.setAnticipatedChange((ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)pendingTransaction.getAnticipatedAmount()));
        newAwardAmountInfo.setObliDistributableAmount((ScaleTwoDecimal)awardAmountInfo.getObliDistributableAmount().subtract((AbstractDecimal)pendingTransaction.getObligatedAmount()));
        newAwardAmountInfo.setAmountObligatedToDate((ScaleTwoDecimal)awardAmountInfo.getAmountObligatedToDate().subtract((AbstractDecimal)pendingTransaction.getObligatedAmount()));
        newAwardAmountInfo.setObligatedTotalDirect((ScaleTwoDecimal)awardAmountInfo.getObligatedTotalDirect().subtract((AbstractDecimal)pendingTransaction.getObligatedDirectAmount()));
        newAwardAmountInfo.setObligatedTotalIndirect((ScaleTwoDecimal)awardAmountInfo.getObligatedTotalIndirect().subtract((AbstractDecimal)pendingTransaction.getObligatedIndirectAmount()));
        newAwardAmountInfo.setAntDistributableAmount((ScaleTwoDecimal)awardAmountInfo.getAntDistributableAmount().subtract((AbstractDecimal)pendingTransaction.getAnticipatedAmount()));
        newAwardAmountInfo.setAnticipatedTotalAmount((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalAmount().subtract((AbstractDecimal)pendingTransaction.getAnticipatedAmount()));
        newAwardAmountInfo.setAnticipatedTotalDirect((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalDirect().subtract((AbstractDecimal)pendingTransaction.getAnticipatedDirectAmount()));
        newAwardAmountInfo.setAnticipatedTotalIndirect((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalIndirect().subtract((AbstractDecimal)pendingTransaction.getAnticipatedIndirectAmount()));
        newAwardAmountInfo.setObligatedChangeDirect((ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)pendingTransaction.getObligatedDirectAmount()));
        newAwardAmountInfo.setObligatedChangeIndirect((ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)pendingTransaction.getObligatedIndirectAmount()));
        newAwardAmountInfo.setAnticipatedChangeDirect((ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)pendingTransaction.getAnticipatedDirectAmount()));
        newAwardAmountInfo.setAnticipatedChangeIndirect((ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)pendingTransaction.getAnticipatedIndirectAmount()));
        this.addAwardAmountTransaction(newAwardAmountInfo.getAwardNumber(), awardAmountTransactionItems, newAwardAmountTransaction, documentNumber);
        return newAwardAmountInfo;
    }

    protected AwardAmountInfo getUpdatedIntermediateDownNodeAmountInfo(PendingTransaction pendingTransaction, AwardAmountInfo awardAmountInfo, Map<String, AwardAmountTransaction> awardAmountTransactionItems, AwardAmountTransaction newAwardAmountTransaction, String documentNumber, Award award) {
        AwardAmountInfo newAwardAmountInfo = this.getNewAwardAmountInfo();
        newAwardAmountInfo.setAwardNumber(awardAmountInfo.getAwardNumber());
        newAwardAmountInfo.setSequenceNumber(award.getSequenceNumber());
        newAwardAmountInfo.setOriginatingAwardVersion(award.getSequenceNumber());
        newAwardAmountInfo.setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
        newAwardAmountInfo.setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
        newAwardAmountInfo.setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
        newAwardAmountInfo.setTimeAndMoneyDocumentNumber(documentNumber);
        newAwardAmountInfo.setTransactionId(pendingTransaction.getTransactionId());
        newAwardAmountInfo.setObligatedChange(pendingTransaction.getObligatedAmount());
        newAwardAmountInfo.setAnticipatedChange(pendingTransaction.getAnticipatedAmount());
        newAwardAmountInfo.setObliDistributableAmount(awardAmountInfo.getObliDistributableAmount());
        newAwardAmountInfo.setAmountObligatedToDate((ScaleTwoDecimal)awardAmountInfo.getAmountObligatedToDate().add((AbstractDecimal)pendingTransaction.getObligatedAmount()));
        newAwardAmountInfo.setObligatedTotalDirect((ScaleTwoDecimal)awardAmountInfo.getObligatedTotalDirect().add((AbstractDecimal)pendingTransaction.getObligatedDirectAmount()));
        newAwardAmountInfo.setObligatedTotalIndirect((ScaleTwoDecimal)awardAmountInfo.getObligatedTotalIndirect().add((AbstractDecimal)pendingTransaction.getObligatedIndirectAmount()));
        newAwardAmountInfo.setAntDistributableAmount(awardAmountInfo.getAntDistributableAmount());
        newAwardAmountInfo.setAnticipatedTotalAmount((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalAmount().add((AbstractDecimal)pendingTransaction.getAnticipatedAmount()));
        newAwardAmountInfo.setAnticipatedTotalDirect((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalDirect().add((AbstractDecimal)pendingTransaction.getAnticipatedDirectAmount()));
        newAwardAmountInfo.setAnticipatedTotalIndirect((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalIndirect().add((AbstractDecimal)pendingTransaction.getAnticipatedIndirectAmount()));
        newAwardAmountInfo.setObligatedChangeDirect(pendingTransaction.getObligatedDirectAmount());
        newAwardAmountInfo.setObligatedChangeIndirect(pendingTransaction.getObligatedIndirectAmount());
        newAwardAmountInfo.setAnticipatedChangeDirect(pendingTransaction.getAnticipatedDirectAmount());
        newAwardAmountInfo.setAnticipatedChangeIndirect(pendingTransaction.getAnticipatedIndirectAmount());
        this.addAwardAmountTransaction(newAwardAmountInfo.getAwardNumber(), awardAmountTransactionItems, newAwardAmountTransaction, documentNumber);
        return newAwardAmountInfo;
    }

    protected AwardAmountInfo getUpdatedIntermediateUpNodeAmountInfo(PendingTransaction pendingTransaction, AwardAmountInfo awardAmountInfo, Map<String, AwardAmountTransaction> awardAmountTransactionItems, AwardAmountTransaction newAwardAmountTransaction, String documentNumber, Award award) {
        AwardAmountInfo newAwardAmountInfo = this.getNewAwardAmountInfo();
        newAwardAmountInfo.setAwardNumber(awardAmountInfo.getAwardNumber());
        newAwardAmountInfo.setSequenceNumber(award.getSequenceNumber());
        newAwardAmountInfo.setOriginatingAwardVersion(award.getSequenceNumber());
        newAwardAmountInfo.setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
        newAwardAmountInfo.setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
        newAwardAmountInfo.setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
        newAwardAmountInfo.setTimeAndMoneyDocumentNumber(documentNumber);
        newAwardAmountInfo.setTransactionId(pendingTransaction.getTransactionId());
        newAwardAmountInfo.setObligatedChange((ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)pendingTransaction.getObligatedAmount()));
        newAwardAmountInfo.setAnticipatedChange((ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)pendingTransaction.getAnticipatedAmount()));
        newAwardAmountInfo.setObliDistributableAmount(awardAmountInfo.getObliDistributableAmount());
        newAwardAmountInfo.setAmountObligatedToDate((ScaleTwoDecimal)awardAmountInfo.getAmountObligatedToDate().subtract((AbstractDecimal)pendingTransaction.getObligatedAmount()));
        newAwardAmountInfo.setObligatedTotalDirect((ScaleTwoDecimal)awardAmountInfo.getObligatedTotalDirect().subtract((AbstractDecimal)pendingTransaction.getObligatedDirectAmount()));
        newAwardAmountInfo.setObligatedTotalIndirect((ScaleTwoDecimal)awardAmountInfo.getObligatedTotalIndirect().subtract((AbstractDecimal)pendingTransaction.getObligatedIndirectAmount()));
        newAwardAmountInfo.setAntDistributableAmount(awardAmountInfo.getAntDistributableAmount());
        newAwardAmountInfo.setAnticipatedTotalAmount((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalAmount().subtract((AbstractDecimal)pendingTransaction.getAnticipatedAmount()));
        newAwardAmountInfo.setAnticipatedTotalDirect((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalDirect().subtract((AbstractDecimal)pendingTransaction.getAnticipatedDirectAmount()));
        newAwardAmountInfo.setAnticipatedTotalIndirect((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalIndirect().subtract((AbstractDecimal)pendingTransaction.getAnticipatedIndirectAmount()));
        newAwardAmountInfo.setObligatedChangeDirect((ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)pendingTransaction.getObligatedDirectAmount()));
        newAwardAmountInfo.setObligatedChangeIndirect((ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)pendingTransaction.getObligatedIndirectAmount()));
        newAwardAmountInfo.setAnticipatedChangeDirect((ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)pendingTransaction.getAnticipatedDirectAmount()));
        newAwardAmountInfo.setAnticipatedChangeIndirect((ScaleTwoDecimal)ScaleTwoDecimal.ZERO.subtract((AbstractDecimal)pendingTransaction.getAnticipatedIndirectAmount()));
        this.addAwardAmountTransaction(newAwardAmountInfo.getAwardNumber(), awardAmountTransactionItems, newAwardAmountTransaction, documentNumber);
        return newAwardAmountInfo;
    }

    protected void handleTransaction(PendingTransaction pendingTransaction, String awardNumber, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, List<PendingTransaction> pendingTransactions, AwardAmountTransaction newAwardAmountTransaction, String documentNumber, GenerateAwardAmountInfoFunction amountInfoFunc) {
        if (this.allowTimeAndMoneyWhenPendingAwardExists()) {
            Award pendingAward = this.awardVersionService.getPendingAwardVersion(awardNumber);
            this.updateAmountInfo(pendingTransaction, awardAmountTransactionItems, awardItems, newAwardAmountTransaction, documentNumber, pendingAward, amountInfoFunc);
            Award activeAward = this.awardVersionService.getActiveAwardVersion(awardNumber);
            this.updateAmountInfo(pendingTransaction, awardAmountTransactionItems, awardItems, newAwardAmountTransaction, documentNumber, activeAward, amountInfoFunc);
        } else {
            Award workingAward = this.awardVersionService.getWorkingAwardVersion(awardNumber);
            this.updateAmountInfo(pendingTransaction, awardAmountTransactionItems, awardItems, newAwardAmountTransaction, documentNumber, workingAward, amountInfoFunc);
        }
    }

    protected boolean allowTimeAndMoneyWhenPendingAwardExists() {
        return this.parameterService.getParameterValueAsBoolean("KC-T", "Document", "ALLOW_TM_WHEN_PENDING_AWARD_EXISTS");
    }

    private void updateAmountInfo(PendingTransaction pendingTransaction, Map<String, AwardAmountTransaction> awardAmountTransactionItems, List<Award> awardItems, AwardAmountTransaction newAwardAmountTransaction, String documentNumber, Award award, GenerateAwardAmountInfoFunction amountInfoFunc) {
        if (award != null) {
            AwardAmountInfo awardAmountInfo = this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
            award.getAwardAmountInfos().add(amountInfoFunc.apply(pendingTransaction, awardAmountInfo, awardAmountTransactionItems, newAwardAmountTransaction, documentNumber, award));
            awardItems.add(award);
        }
    }

    protected void addAwardAmountTransaction(String awardNumber, Map<String, AwardAmountTransaction> awardAmountTransactionItems, AwardAmountTransaction newAwardAmountTransaction, String documentNumber) {
        if (!awardAmountTransactionItems.containsKey(awardNumber)) {
            AwardAmountTransaction newAwardAmountTransaction1 = new AwardAmountTransaction();
            newAwardAmountTransaction1.setAwardNumber(awardNumber);
            newAwardAmountTransaction1.setDocumentNumber(documentNumber);
            newAwardAmountTransaction1.setTransactionTypeCode(newAwardAmountTransaction.getTransactionTypeCode());
            newAwardAmountTransaction1.setComments(newAwardAmountTransaction.getComments());
            newAwardAmountTransaction1.setNoticeDate(newAwardAmountTransaction.getNoticeDate());
            awardAmountTransactionItems.put(awardNumber, newAwardAmountTransaction1);
        }
    }

    public AwardVersionService getAwardVersionService() {
        this.awardVersionService = KcServiceLocator.getService(AwardVersionService.class);
        return this.awardVersionService;
    }

    protected UserSession replaceSessionWithRoutedBy(TimeAndMoneyDocument doc) {
        String routedByUserId = doc.getDocumentHeader().getWorkflowDocument().getRoutedByPrincipalId();
        UserSession oldSession = GlobalVariables.getUserSession();
        if (ObjectUtils.isNotNull((Object)routedByUserId)) {
            Person person = this.getPersonService().getPerson(routedByUserId);
            GlobalVariables.setUserSession((UserSession)new UserSession(person.getPrincipalName()));
        }
        return oldSession;
    }

    protected PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public AwardAmountInfoService getAwardAmountInfoService() {
        return this.awardAmountInfoService;
    }

    public void setAwardVersionService(AwardVersionService awardVersionService) {
        this.awardVersionService = awardVersionService;
    }

    public void setAwardAmountInfoService(AwardAmountInfoService awardAmountInfoService) {
        this.awardAmountInfoService = awardAmountInfoService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @FunctionalInterface
    protected static interface GenerateAwardAmountInfoFunction {
        public AwardAmountInfo apply(PendingTransaction var1, AwardAmountInfo var2, Map<String, AwardAmountTransaction> var3, AwardAmountTransaction var4, String var5, Award var6);
    }
}

